﻿--[[

-- Atlas Data (Traditional Chinese)
-- Translated and maintained by Arith Hsu
-- arithmandarjp at yahoo.co.jp
-- Special thanks for Alfred and his website "Alfred's WoW Treasure BOX"
-- http://statue.sayya.org/wowdb/index.php
--
-- Last Updated: 8/09/2007

--]]
if (GetLocale() == 	"zhTW") then

--[[
sets.lua
The loot tables for all item sets and collections is defined here.
]]

AtlasLoot_Data["AtlasLootSetItems"] = {
    EmptyInstance = {};

-- Pre 60 Sets
    
    DEADMINES = {
        { 0, "INV_Box_01", "=q6=#pre60s1#", "=ec1=#a2#. =q1=#z1#" },
        { 10399, "INV_Chest_Leather_08", "=q3=黑暗迪菲亞護甲", "=ds=#s5#, =q2=#n6#", "14.77%" },
        { 10401, "INV_Gauntlets_18", "=q2=黑暗迪菲亞手套", "=ds=#s9#, =q2=#n9#", "1.76%" },
        { 10403, "INV_Belt_26", "=q2=黑暗迪菲亞腰帶", "=ds=#s10#, =q2=#n7#", "23.26%" },
        { 10400, "INV_Pants_12", "=q2=黑暗迪菲亞護腿", "=ds=#s11#, =q2=#n9#", "1.64%" },
        { 10402, "INV_Boots_05", "=q2=黑暗迪菲亞長靴", "=ds=#s12#, =q2=#n8#", "1.23%" },
        }; 

    WAILING = {
        { 0, "INV_Box_01", "=q6=#pre60s2#", "=ec1=#a2#. =q1=#z2#" },
        { 6473, "INV_Shirt_16", "=q2=尖牙鎧甲", "=ds=#s5#, =q2=#n5#", "52.05%" },
        { 10413, "INV_Gauntlets_18", "=q2=尖牙手套", "=ds=#s9#, =q2=#n4#", "1.20%" },
        { 10412, "INV_Belt_30", "=q2=尖牙腰帶", "=ds=#s10#, =q2=#n2#", "8.64%" },
        { 10410, "INV_Pants_11", "=q3=尖牙護腿", "=ds=#s11#, =q2=#n1#", "16.03%" },
        { 10411, "INV_Boots_04", "=q2=尖牙足墊", "=ds=#s12#, =q2=#n3#", "19.08%" },
        }; 

    SCARLET = {
        { 0, "INV_Box_01", "=q6=#pre60s3#", "=ec1=#a3#. =q1=#z3#" },
        { 10328, "INV_Chest_Chain_07", "=q3=血色十字軍護胸", "=ds=#s5#, =q2=#n12#", "0.3%"},
        { 10333, "INV_Bracer_03", "=q2=血色十字軍腕甲", "=ds=#s8#, =q2=#n15#", "1.6%"},
        { 10331, "INV_Gauntlets_19", "=q2=血色十字軍護手", "=ds=#s9#, =q2=#n13#", "1.7%" },
        { 10329, "INV_Belt_06", "=q2=血色十字軍腰帶", "=ds=#s10#, =q2=#n10#", "1.6%"},
        { 10330, "INV_Pants_03", "=q3=血色十字軍護腿", "=ds=#s11#, =q2=#n14#", "13.2%"},
        { 10332, "INV_Boots_02", "=q3=血色十字軍戰靴", "=ds=#s12#, =q2=#n11#", "0.1%"},
        };

    BLACKROCKD = {
        { 0, "INV_Box_01", "=q6=#pre60s4#", "=ec1=#a3#. =q1=#z4#" },
        { 11729, "INV_Helmet_01", "=q3=野蠻角鬥士頭盔", "=ds=#s1#, =q2=#brd3#, #brd5#", "10.08%" },
        { 11726, "INV_Chest_Chain_15", "=q4=野蠻角鬥士鏈甲", "=ds=#s5#, =q2=#brd3#", "14.52%" },
        { 11730, "INV_Gauntlets_04", "=q3=野蠻角鬥士護手", "=ds=#s9#, =q2=#brd2#", "14.12%"},
        { 11728, "INV_Pants_03", "=q3=野蠻角鬥士護腿", "=ds=#s11#, =q2=#brd6#", "14.95%" },
        { 11731, "INV_Boots_01", "=q3=野蠻角鬥士護脛", "=ds=#s12#, =q2=#brd1#", "15.14%" },
        };

    IRONWEAVE = {
        { 0, "INV_Box_01", "=q6=#pre60s5#", "=ec1=#a1#, =q1=#m1# #c5#, #c3#, #c8#" },
        { 22302, "INV_Helmet_30", "=q3=鐵織兜帽", "=ds=#s1#, =q2=#n16# (#z9#)", "27.72%" },
        { 22305, "INV_Shoulder_05", "=q3=鐵織襯肩", "=ds=#s3#, =q2=#n17# (#z4#)", "30.39%" },
        { 22301, "INV_Chest_Cloth_48", "=q3=鐵織長袍", "=ds=#s5#, =q2=#n18# (#z6#)", "19.00%" },
        { 22313, "INV_Bracer_13", "=q3=鐵織護腕", "=ds=#s8#, =q2=#n19# (#z10#)", "18.16%" },
        { 22304, "INV_Gauntlets_27", "=q3=鐵織手套", "=ds=#s9#, =q2=#n20# (#z13#)", "16.24%" },
        { 22306, "INV_Belt_03", "=q3=鐵織腰帶", "=ds=#s10#, =q2=#n21# (#z10#)", "20.28%" }, 
        { 22303, "INV_Pants_08", "=q3=鐵織長褲", "=ds=#s11#, =q2=#n22# (#z5#)", "23.33%" },
        { 22311,"INV_Boots_Cloth_05","=q3=鐵織長靴", "=ds=#s12#, =q2=#n23# (#z9#)", "12.31%" },
        };

    ScholoCloth = {
        { 0, "INV_Box_01", "=q6=#pre60s6#", "=ec1=#a1#. =q1=#z5#" },
        { 14633, "INV_Shoulder_02", "=q3=骨堆襯肩", "=ds=#s3#", "1.12%" },
        { 14626, "INV_Chest_Cloth_43", "=q3=骨堆長袍", "=ds=#s5#", "1.27%" },
        { 14629, "INV_Bracer_07", "=q3=骨堆腕輪", "=ds=#s8#", "1.03%" },
        { 14632, "INV_Pants_08", "=q3=骨堆護腿", "=ds=#s11#", "0.85%" },
        { 14631, "INV_Boots_05", "=q3=骨堆長靴", "=ds=#s12#", "0.88%" },
        };

    ScholoLeather = {
        { 0, "INV_Box_01", "=q6=#pre60s7#", "=ec1=#a2#. =q1=#z5#" },
        { 14637, "INV_Chest_Leather_03", "=q3=蒼白護甲", "=ds=#s5#", "1.51%" },
        { 14640, "INV_Gauntlets_15", "=q3=蒼白手套", "=ds=#s9#", "0.82%" },
        { 14636, "INV_Belt_16", "=q3=蒼白腰帶", "=ds=#s10#", "0.60%" },
        { 14638, "INV_Pants_07", "=q3=蒼白護腿", "=ds=#s11#", "1.09%" },
        { 14641, "INV_Boots_05", "=q3=蒼白長靴", "=ds=#s12#", "0.67%" },
        };

    ScholoMail = {
        { 0, "INV_Box_01", "=q6=#pre60s8#", "=ec1=#a3#. =q1=#z5#" },
        { 14611, "INV_Chest_Leather_05", "=q3=血鏈鎖甲", "=ds=#s5#", "0.54%" },
        { 14615, "INV_Gauntlets_26", "=q3=血鏈護手", "=ds=#s9#", "0.09%" },
        { 14614, "INV_Belt_23", "=q3=血鏈腰帶", "=ds=#s10#", "0.60%" },
        { 14612, "INV_Pants_06", "=q3=血鏈護腿", "=ds=#s11#", "0.42%" },
        { 14616, "INV_Boots_01", "=q3=血鏈戰靴", "=ds=#s12#", "0.36%" },
        };

    ScholoPlate = {
        { 0, "INV_Box_01", "=q6=#pre60s9#", "=ec1= #a4#. =q1=#z5#" },
        { 14624, "INV_Chest_Chain_15", "=q3=亡骨胸甲", "=ds=#s5#", "0.45%" },
        { 14622, "INV_Gauntlets_28", "=q3=亡骨護手", "=ds=#s9#", "0.45%" },
        { 14620, "INV_Belt_12", "=q3=亡骨腰帶", "=ds=#s10#", "0.67%" },
        { 14623, "INV_Pants_04", "=q3=亡骨腿甲", "=ds=#s11#", "1.12%" },
        { 14621, "INV_Boots_01", "=q3=亡骨馬靴", "=ds=#s12#", "0.57%" },
        };

    STRAT = {
        { 0, "INV_Box_01", "=q6=#pre60s10#", "=ec1=#a1#, =q2=#n24#. =q1=#z6#" },
        { 13390, "INV_Misc_Bandage_15", "=q3=郵差護腕", "=ds=#s1#", "" },
        { 13388, "INV_Chest_Leather_10", "=q3=郵差外套", "=ds=#s5#", "" },
        { 13389, "INV_Pants_06", "=q3=郵差長褲", "=ds=#s11#", "" },
        { 13391, "INV_Boots_02", "=q3=郵差的布靴", "=ds=#s12#", "" },
        { 13392, "INV_Jewelry_Ring_23", "=q3=郵差徽記", "=ds=#s13#", "" },
        };

    ScourgeInvasion = {
        { 0, "INV_Jewelry_Talisman_13", "=q6=#pre60s11#", "=ec1=#a1#" },
        { 23085, "INV_Chest_Leather_06", "=q3=弒妖外套", "=ds=#s5#, =q2=#n25#", "" },
        { 23091, "INV_Bracer_12", "=q3=淨妖護腕", "=ds=#s8#, =q2=#n26#, #n27#", "" },
        { 23084, "INV_Gauntlets_16", "=q3=淨妖手套", "=ds=#s9#, =q2=#m4#", "" },
        { 0,"","","" },
        { 0, "INV_Jewelry_Talisman_13", "=q6=#pre60s12#", "=ec1=#a2#" },
        { 23089, "INV_Chest_Cloth_04", "=q3=淨妖長袍", "=ds=#s5#, =q2=#n25#", "" },
        { 23093, "INV_Bracer_08", "=q3=弒妖裹腕", "=ds=#s8#, =q2=#n26#, #n27#", "" },
        { 23081, "INV_Gauntlets_06", "=q3=弒妖裹手", "=ds=#s9#, =q2=#m4#", "" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Jewelry_Talisman_13", "=q6=#pre60s13#", "=ec1=#a3#" },
        { 23088, "INV_Chest_Chain_08", "=q3=弒妖護胸", "=ds=#s5#, =q2=#n25#", "" },
        { 23092, "INV_Bracer_16", "=q3=弒妖腕甲", "=ds=#s8#, =q2=#n26#, #n27#", "" },
        { 23082, "INV_Gauntlets_11", "=q3=弒妖護手", "=ds=#s9#, =q2=#m4#", "" },
        { 0,"","","" },
        { 0, "INV_Jewelry_Talisman_13", "=q6=#pre60s14#", "=ec1=#a4#" },
        { 23087, "INV_Chest_Plate10", "=q3=弒妖胸愷", "=ds=#s5#, =q2=#n25#", "" },
        { 23090, "INV_Bracer_14", "=q3=弒妖護腕", "=ds=#s8#, =q2=#n26#, #n27#", "" },
        { 23078, "INV_Gauntlets_29", "=q3=弒妖手套", "=ds=#s9#, =q2=#m4#", "" },
        };

    ShardOfGods = {
        { 0, "INV_Box_01", "=q6=#pre60s15#", "=q1=#z7#" },
        { 17082, "INV_Misc_Orb_05", "=q4=烈焰碎片", "=ds=#s14#, =q2=#n35# (#z14#)", "4.46%" }, 
        { 17064, "INV_Misc_MonsterScales_15", "=q4=龍鱗碎片", "=ds=#s14#, =q2=#n36# (#z15#)", "3.71%" }, 
        };

    ZGRings = {
        { 0, "INV_Box_01", "=q6=#pre60s16#", "=q1=#z8#" },
        { 19898, "INV_Jewelry_Ring_44", "=q3=食人妖族長徽記", "=ds=#s13#, =q2=#n28#", "8.81%" },
        { 19925, "INV_Jewelry_Ring_44", "=q3=食人妖族長指環", "=ds=#s13#, =q2=#n29#", "10.36%" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#pre60s17#", "=q1=#z8#" },
        { 19873, "INV_Jewelry_Ring_39", "=q3=督軍的紅色指環", "=ds=#s13#, =q2=#n33#", "10.12%" },
        { 19912, "INV_Jewelry_Ring_39", "=q3=督軍的瑪瑙指環", "=ds=#s13#, =q2=#n30#", "14.51%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#pre60s18#", "=q1=#z8#" },
        { 19863, "INV_Jewelry_Ring_47", "=q3=始祖徽記", "=ds=#s13#, =q2=#n33#", "9.72%" },
        { 19920, "INV_Jewelry_Ring_47", "=q3=首領指環", "=ds=#s13#, =q2=#n31#", "8.95%" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#pre60s19#", "=q1=#z8#" },
        { 19905, "INV_Jewelry_Ring_46", "=q3=贊吉爾指環", "=ds=#s13#, =q2=#n32#", "9.24%" },
        { 19893, "INV_Jewelry_Ring_46", "=q3=贊吉爾的徽記", "=ds=#s13#, =q2=#n33#", "10.12%" },
        };

    SpiritofEskhandar = {
        { 0, "INV_Box_01", "=q6=#pre60s20#", "=q1=#z7#" },
        { 18204, "INV_Misc_Cape_07", "=q4=艾斯卡達爾的毛皮", "=ds=#s4#, =q2=#n37#", "9.16%" },
        { 18205, "INV_Belt_12", "=q4=艾斯卡達爾的項圈", "=ds=#s2#, =q2=#n36# (#z15#)", "14.29% " },
        { 18203, "INV_Misc_MonsterClaw_04", "=q4=艾斯卡達爾的右爪", "=ds=#h3#, #w13#, =q2=#n38# (#z14#)", "16.97%" },
        { 18202, "INV_Misc_MonsterClaw_04", "=q4=艾斯卡達爾的左爪", "=ds=#h4#, #w13#, =q2=#n39#", "12.36%" },
        };

    HakkariBlades = {
        { 0, "INV_Box_01", "=q6=#pre60s21#", "=q1=#z8#" },
        { 19865, "INV_Sword_55", "=q4=哈卡萊戰刃", "=ds=#h3#, #w10#, =q2=#n34#", "5.18%" },
        { 19866, "INV_Sword_55", "=q4=哈卡萊戰刃", "=ds=#h4#, #w10#, =q2=#n33#", "4.55%" },
        };

    PrimalBlessing = {
        { 0, "INV_Box_01", "=q6=#pre60s22#", "=q1=#z8#" },
        { 19896, "INV_Weapon_Hand_01", "=q4=塞卡爾之握", "=ds=#h3#, #w13#, =q2=#n28#", "5.20%" },
        { 19910, "INV_Weapon_Hand_01", "=q4=婭爾羅之握", "=ds=#h4#, #w13#, =q2=#n30#", "4.54%" },
        };

    DalRend = {
        { 0, "INV_Box_01", "=q6=#pre60s23#", "=q1=#z9#" },
        { 12940, "INV_Sword_43", "=q3=雷德的神聖控訴者", "=ds=#h3#, #w10#, =q2=#n40#", "6.62%" },
        { 12939, "INV_Sword_40", "=q3=雷德的部族護衛者", "=ds=#h4#, #w10#, =q2=#n40#", "7.44%" },
        };

    SpiderKiss = {
        { 0, "INV_Box_01", "=q6=#pre60s24#", "=q1=#z10#" },
        { 13218, "INV_Weapon_ShortBlade_16", "=q3=水晶蜘蛛之牙", "=ds=#h1#, #w4#, =q2=#n41#", "15.46%" },
        { 13183, "INV_Weapon_Hand_01", "=q3=噴毒者", "=ds=#h1#, #w6#, =q2=#n42#", "13.07%" },
        };

    TwinStars = {
        { 0, "INV_Box_01", "=q6=#bcs1#", "=q1=#z17#" },
        { 31338, "INV_Jewelry_Necklace_36", "=q4=夏綠蒂的常春藤", "=ds=#s2#", "0.01%" },
        { 31339, "INV_Jewelry_Ring_56", "=q4=蘿拉之夜", "=ds=#s13#", "0.01%" },
        };

    AzzinothBlades = {
        { 0, "INV_Box_01", "=q6=#bcs2#", "=q1=#z18#" },
        { 32837, "INV_Weapon_Glave_01", "=q5=埃辛諾斯戰刃", "=ds=#h3#, #w10#, =q1=#m1# =ds=#c9#, #c6#" },
        { 32838, "INV_Weapon_Glave_01", "=q5=埃辛諾斯戰刃", "=ds=#h4#, #w10#, =q1=#m1# =ds=#c9#, #c6#" },
        };

-- Crafted Epic Weapons

    CraftedWeapons1 = {
        { 0, "INV_Box_01", "=q6=#p15#", "" },
        { 28425, "INV_Sword_1H_Blacksmithing_01", "=q4=火焰衛士", "=ds=#h1#, #w10#" },
        { 28426, "INV_Sword_1H_Blacksmithing_02", "=q4=燃燒守護者", "=ds=#h1#, #w10#" },
        { 28427, "INV_Sword_1H_Blacksmithing_03", "=q4=燃燒之怒", "=ds=#h1#, #w10#" },
        { 28428, "INV_Sword_2H_Blacksmithing_01", "=q4=獅心之劍", "=ds=#h2#, #w10#" },
        { 28429, "INV_Sword_2H_Blacksmithing_02", "=q4=獅心勇士劍", "=ds=#h2#, #w10#" },
        { 28430, "INV_Sword_2H_Blacksmithing_03", "=q4=獅心斬首者", "=ds=#h2#, #w10#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#p14#", "" },
        { 28431, "INV_Axe_1H_BlackSmithing_01", "=q4=黑色真渦之刃", "=ds=#h3#, #w1#" },
        { 28432, "INV_Axe_1H_BlackSmithing_02", "=q4=黑色真渦之刃", "=ds=#h3#, #w1#" },
        { 28433, "INV_Axe_1H_BlackSmithing_03", "=q4=邪惡真渦之刃", "=ds=#h3#, #w1#" },
        { 28434, "INV_Axe_50", "=q4=新月斧", "=ds=#h2#, #w1#" },
        { 28435, "INV_Axe_51", "=q4=月光切割者", "=ds=#h2#, #w1#" },
        { 28436, "INV_Axe_52", "=q4=血月", "=ds=#h2#, #w1#" },
        { 0, "INV_Box_01", "=q6=#p22#", "" },
        { 28437, "INV_Mace_37", "=q4=龍拳之錘", "=ds=#h3#, #w6#" },
        { 28438, "INV_Mace_38", "=q4=龍喉", "=ds=#h3#, #w6#" },
        { 28439, "INV_Mace_39", "=q4=龍擊", "=ds=#h3#, #w6#" },
        { 28440, "INV_Mace_2H_Blacksmithing_01", "=q4=雷", "=ds=#h2#, #w6#" },
        { 28441, "INV_Mace_2H_Blacksmithing_02", "=q4=深雷", "=ds=#h2#, #w6#" },
        { 28442, "INV_Mace_2H_Blacksmithing_03", "=q4=風暴先驅者", "=ds=#h2#, #w6#" },
        };

    CraftedWeapons2 = {
        { 0, "INV_Box_01", "=q6=#p2#", "=q1=#j10#" },
        { 23554, "INV_Weapon_ShortBlade_05", "=q4=恆金符文刃", "=ds=#h3#, #w4#" },
        { 23555, "INV_Weapon_ShortBlade_05", "=q4=輓歌之刃", "=ds=#h1#, #w4#" },
        { 23540, "INV_Sword_59", "=q4=魔鋼長刃", "=ds=#h1#, #w10#" },
        { 23541, "INV_Sword_08", "=q4=克銀勇士", "=ds=#h2#, #w10#" },
        { 23542, "INV_Axe_15", "=q4=魔鐵戰斧", "=ds=#h1#, #w1#" },
        { 23543, "INV_Axe_02", "=q4=魔鋼斧", "=ds=#h2#, #w1#" },
        { 23556, "INV_Mace_16", "=q4=永恆之手", "=ds=#h3#, #w6#" },
        { 23544, "INV_Hammer_09", "=q4=符文錘", "=ds=#h1#, #w6#" },
        { 23546, "INV_Hammer_17", "=q4=魔鐵強化錘", "=ds=#h2#, #w6#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#p5#", "=q1=#j10#" },
        { 32756, "INV_Weapon_Rifle_13", "=q4=迴轉平衡克銀毀滅火槍", "=ds=#w5#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#p2#", "=q1=#j9#" },
        { 19166, "INV_Weapon_ShortBlade_12", "=q4=黑色赦免者", "=ds=#h1#, #w4#" },
        { 22383, "INV_Sword_51", "=q4=聖劍", "=ds=#h3#, #w10#" },
        { 19168, "INV_Sword_39", "=q4=黑色衛士", "=ds=#h1#, #w10#" },
        { 19169, "INV_Axe_12", "=q4=夜幕", "=ds=#h2#, #w1#" },
        { 22384, "INV_Hammer_08", "=q4=刺錘", "=ds=#h3#, #w6#" },
        { 19170, "INV_Hammer_19", "=q4=黑檀木手", "=ds=#h1#, #w6#" },
        { 17193, "INV_Hammer_Unique_Sulfuras", "=q4=薩弗隆戰錘", "=ds=#h2#, #w6#" },
        { 19167, "INV_Spear_08", "=q4=黑色怒火", "=ds=#w7#" },
        { 22198, "INV_Shield_22", "=q4=鋸齒黑曜石之盾", "=ds=#w8#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#p5#", "=q1=#j9#" },
        { 18282, "INV_Weapon_Rifle_05", "=q4=火核狙擊步槍", "=ds=#w5#" },
        { 18168, "Spell_Arcane_PortalDarnassus", "=q4=力回饋盾牌", "=ds=#w8#" },
        };

-- Blacksmithing Plate Sets

    ImperialPlate = {
        { 0, "INV_Hammer_20", "=q6=#craftbp1#", "" },
        { 12427, "INV_Helmet_22", "=q2=君王鎧甲頭盔", "=ds=#s1#, #a4#" },
        { 12428, "INV_Shoulder_02", "=q2=君王鎧甲護肩", "=ds=#s3#, #a4#" },
        { 12422, "INV_Chest_Plate10", "=q2=君王鎧甲護胸", "=ds=#s5#, #a4#" },
        { 12425, "INV_Bracer_19", "=q2=君王鎧甲護腕", "=ds=#s8#, #a4#" },
        { 12424, "INV_Belt_01", "=q2=君王鎧甲腰帶", "=ds=#s10#, #a4#" },
        { 12429, "INV_Pants_04", "=q2=君王鎧甲護腿", "=ds=#s11#, #a4#" },
        { 12426, "INV_Boots_Plate_01", "=q2=君王鎧甲戰靴", "=ds=#s12#, #a4#" },
        };

    TheDarksoul = {
        { 0, "INV_Hammer_20", "=q6=#craftbp2#", "" },
        { 19695, "INV_Shoulder_01", "=q3=黑暗之魂護肩", "=ds=#s3#, #a4#" },
        { 19693, "INV_Chest_Plate08", "=q3=黑暗之魂胸甲", "=ds=#s5#, #a4#" },
        { 19694, "INV_Pants_Plate_21", "=q3=黑暗之魂護腿", "=ds=#s11#, #a4#" },
        };   

    FelIronPlate = {
        { 0, "INV_Hammer_20", "=q6=#craftbp3#", "" },
        { 23489, "INV_Chest_Plate07", "=q2=魔鐵胸甲", "=ds=#s5#, #a4#" },
        { 23482, "INV_Gauntlets_03", "=q2=魔鐵鎧甲手套", "=ds=#s9#, #a4#" },
        { 23484, "INV_Belt_21", "=q2=魔鐵鎧甲腰帶", "=ds=#s10#, #a4#" },
        { 23488, "INV_Pants_Plate_18", "=q2=魔鐵鎧甲護腿", "=ds=#s11#, #a4#" },
        { 23487, "INV_Boots_Chain_11", "=q2=魔鐵鎧甲長靴", "=ds=#s12#, #a4#" },
        };

    AdamantiteB = {
        { 0, "INV_Hammer_20", "=q6=#craftbp4#","" },
        { 23507, "INV_Chest_Plate11", "=q3=艾曼泰胸甲", "=ds=#s5#, #a4#" },
        { 23506, "INV_Bracer_07", "=q3=艾曼泰鎧甲護腕", "=ds=#s8#, #a4#" },
        { 23508, "INV_Gauntlets_30", "=q3=艾曼泰鎧甲手套", "=ds=#s9#, #a4#" },
        };

    FlameG = {
        { 0, "INV_Hammer_20", "=q6=#craftbp5#", "=q1=#j11#" },
        { 23516, "INV_Helmet_22", "=q3=暗影毀滅頭盔", "=ds=#s1#, #a4#" },
        { 23513, "INV_Chest_Plate16", "=q3=暗影毀滅胸甲", "=ds=#s5#, #a4#" },
        { 23515, "INV_Bracer_19", "=q3=暗影毀滅護腕", "=ds=#s8#, #a4#" },
        { 23514, "INV_Gauntlets_11", "=q3=暗影毀滅手套", "=ds=#s9#, #a4#" },
        };   

    EnchantedAdaman = {
        { 0, "INV_Hammer_20", "=q6=#craftbp6#", "=q1=#j12#" },
        { 23509, "INV_Chest_Plate10", "=q3=附魔艾曼泰胸甲", "=ds=#s5#, #a4#" },
        { 23510, "INV_Belt_29", "=q3=附魔艾曼泰腰帶", "=ds=#s10#, #a4#" },
        { 23512, "INV_Pants_Plate_12", "=q3=附魔艾曼泰護腿", "=ds=#s11#, #a4#" },
        { 23511, "INV_Boots_Chain_08", "=q3=附魔艾曼泰長靴", "=ds=#s12#, #a4#" },
        };

    KhoriumWard = {
        { 0, "INV_Hammer_20", "=q6=#craftbp7#", "" },
        { 23524, "INV_Belt_11", "=q3=可利安腰帶", "=ds=#s10#, #a4#" },
        { 23523, "INV_Pants_Plate_04", "=q3=可利安護腿", "=ds=#s11#, #a4#" },
        { 23525, "INV_Boots_Chain_01", "=q3=可利安長靴", "=ds=#s12#, #a4#" },
        };
         
    FaithFelsteel = { 
        { 0, "INV_Hammer_20", "=q6=#craftbp8#", "" },
        { 23519, "INV_Helmet_22", "=q3=魔鋼頭盔", "=ds=#s1#, #a4#" },
        { 23517, "INV_Gauntlets_29", "=q3=魔鋼手套", "=ds=#s9#, #a4#" },
        { 23518, "INV_Pants_Plate_06", "=q3=魔鋼護腿", "=ds=#s11#, #a4#" },
        };

    BurningRage = { 
        { 0, "INV_Hammer_20", "=q6=#craftbp9#", "" },
        { 23521, "INV_Helmet_22", "=q3=怒鋼頭盔", "=ds=#s1#, #a4#" },
        { 23522, "INV_Chest_Chain_16", "=q3=怒鋼胸甲", "=ds=#s5#, #a4#" },
        { 23520, "INV_Gauntlets_26", "=q3=怒鋼手套", "=ds=#s9#, #a4#" },
        };

-- Blacksmithing Mail Sets

    BloodsoulEmbrace = {
        { 0, "INV_Hammer_20", "=q6=#craftbm1#", "" },
        { 19691, "INV_Shoulder_15", "=q3=血魂護肩", "=ds=#s3#, #a3#" },
        { 19690, "INV_Chest_Chain_14", "=q3=血魂胸甲", "=ds=#s5#, #a3#" },
        { 19692, "INV_Gauntlets_31", "=q3=血魂護手", "=ds=#s9#, #a3#" },
        };

    FelIronChain = {
        { 0, "INV_Hammer_20", "=q6=#craftbm2#", "" },
        { 23493, "INV_Helmet_35", "=q2=魔鐵鍊甲頭盔", "=ds=#s1#, #a3#" },
        { 23490, "INV_Chest_Chain_14", "=q2=魔鐵鍊甲外衣", "=ds=#s5#, #a3#" },
        { 23494, "INV_Bracer_13", "=q2=魔鐵鍊甲護腕", "=ds=#s8#, #a3#" },
        { 23491, "INV_Gauntlets_11", "=q2=魔鐵鍊甲手套", "=ds=#s9#, #a3#" },
        };

-- Tailoring Sets
           
    BloodvineG = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt1#", "" },
        { 19682, "INV_Chest_Cloth_07", "=q3=血藤外套", "=ds=#s5#, #a1#" },
        { 19683, "INV_Pants_Cloth_14", "=q3=血藤護腿", "=ds=#s11#, #a1#" },
        { 19684, "INV_Boots_Cloth_02","=q3=血藤長靴", "=ds=#s12#, #a1#" },
        };
 
    NeatherVest = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt2#", "" },
        { 21855, "INV_Shirt_04", "=q2=地紋外套", "=ds=#s5#, #a1#" },
        { 21854, "INV_Chest_Cloth_29", "=q2=地紋長袍", "=ds=#s5#, #a1#" }, 
        { 21849, "INV_Bracer_07", "=q2=地紋護腕", "=ds=#s8#, #a1#" },
        { 21851, "INV_Gauntlets_27", "=q2=地紋手套", "=ds=#s9#, #a1##" },
        { 21850, "INV_Belt_04", "=q2=地紋腰帶", "=ds=#s10#, #a1#" },
        { 21852, "INV_Pants_09", "=q2=地紋短褲", "=ds=#s11#, #a1#" },
        { 21853, "INV_Boots_05","=q2=地紋長靴", "=ds=#s12#, #a1#" },  
        };  

    ImbuedNeather = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt3#", "" },
        { 21862, "INV_Chest_Cloth_45", "=q3=韌化地紋外套", "=ds=#s5#, #a1#" },
        { 21861, "INV_Chest_Cloth_12", "=q3=韌化地紋長袍", "=ds=#s5#, #a1#" }, 
        { 21859, "INV_Pants_Leather_09", "=q3=韌化地紋短褲", "=ds=#s11#, #a1#" },
        { 21860, "INV_Boots_07","=q3=韌化地紋之靴", "=ds=#s12#, #a1#" },   
        };  
  
    ArcanoVest = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt4#", "=q1=#j12#" },
        { 21868, "INV_Chest_Cloth_01", "=q3=奧紋長袍", "=ds=#s5#, #a1#" },
        { 21866, "INV_Bracer_19", "=q3=奧紋護腕", "=ds=#s8#, #a1#" },  
        { 21867, "INV_Boots_07","=q3=奧紋長靴", "=ds=#s12#, #a1#" },  
        };

    TheUnyielding = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt5#", "" },
        { 24249, "INV_Bracer_11", "=q3=頑強護腕", "=ds=#s8#, #a1#" },
        { 24255, "INV_Belt_03", "=q4=頑強腰帶", "=ds=#s10#, #a1#" }, 
        };

    WhitemendWis = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt6#", "" },
        { 24264, "INV_Helmet_53", "=q4=白癒兜帽", "=ds=#s1#, #a1#" },  
        { 24261, "INV_Pants_Cloth_07", "=q4=白癒短褲", "=ds=#s11#, #a1#" },
        };

    SpellstrikeInfu = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt7#", "" },
        { 24266, "INV_Helmet_27", "=q4=法擊頭環", "=ds=#s1#, #a1#" },  
        { 24262, "INV_Pants_Cloth_14", "=q4=法擊短褲", "=ds=#s11#, #a1#" },   
        };

    BattlecastG = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt8#", "" },
        { 24267, "INV_Helmet_70", "=q4=戰放頭環", "=ds=#s1#, #a1#" },  
        { 24263, "INV_Pants_Cloth_12", "=q4=戰放護腿", "=ds=#s11#, #a1#" },  
        };

    SoulclothEm = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt9#", "=q1=#j12#" },
        { 21864, "INV_Shoulder_02", "=q4=靈魂布護肩", "=ds=#s3#, #a1#" },
        { 21865, "INV_Chest_Cloth_12", "=q4=靈魂布外衣", "=ds=#s5#, #a1#" },  
        { 21863, "INV_Gauntlets_17", "=q4=靈魂布手套", "=ds=#s9#, #a1#" },  
        };      

    PrimalMoon = {
        { 0, "INV_Fabric_Linen_02", "=q6=#crafttm1#", "=q1=#p19#" }, 
        { 21874, "INV_Shoulder_02", "=q4=原始月布護肩", "=ds=#s3#, #a1#" }, 
        { 21875, "INV_Chest_Cloth_04", "=q4=原始月布長袍", "=ds=#s5#, #a1#" },  
        { 21873, "INV_Belt_31", "=q4=原始月布腰帶", "=ds=#s10#, #a1#" },
        };  
  
    ShadowEmbrace = {
        { 0, "INV_Fabric_Linen_02", "=q6=#crafttsh1#", "=q1=#p20#" }, 
        { 21869, "INV_Shoulder_25", "=q4=冰霜暗紋護肩", "=ds=#s3#, #a1#" },
        { 21871, "INV_Chest_Cloth_08", "=q4=冰霜暗紋外衣", "=ds=#s5#, #a1#" },  
        { 21870, "INV_Boots_Cloth_03","=q4=冰霜暗紋之靴", "=ds=#s12#, #a1#" },
        };      
  
    SpellfireWrath = {
        { 0, "INV_Fabric_Linen_02", "=q6=#crafttsf1#", "=q1=#p21#" },  
        { 21848, "INV_Chest_Cloth_02", "=q3=魔焰外衣", "=ds=#s5#, #a1#" },
        { 21847, "INV_Gauntlets_19", "=q3=魔焰外衣", "=ds=#s9#, #a1#" },
        { 21846, "INV_Belt_04", "=q3=魔焰腰帶", "=ds=#s10#, #a1#" },  
        };      

-- Leatherworking Leather Sets
        
    VolcanicArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwl1#", "=q1=#j11#" },
        { 15055, "INV_Shoulder_13", "=q2=火山護肩", "=ds=#s3#, #a2#" },
        { 15053, "INV_Chest_Leather_07", "=q2=火山胸甲", "=ds=#s5#, #a2#" },
        { 15054, "INV_Pants_06", "=q2=火山護腿", "=ds=#s11#, #a2#" },
        }; 
 
    IronfeatherArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwl2#", "" },
        { 15067, "INV_Shoulder_06", "=q3=鐵羽護肩", "=ds=#s3#, #a2#" },
        { 15066, "INV_Chest_Leather_06", "=q3=鐵羽胸甲", "=ds=#s5#, #a2#" },
        };

    StormshroudArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwl3#", "" },
        { 15058, "INV_Shoulder_05", "=q3=雷暴護肩", "=ds=#s3#, #a2#" },
        { 15056, "INV_Chest_Leather_08", "=q3=雷暴護甲", "=ds=#s5#, #a2#" },
        { 21278, "INV_Gauntlets_05", "=q3=雷暴手套", "=ds=#s9#, #a2#" },
        { 15057, "INV_Pants_09", "=q3=雷暴短褲", "=ds=#s11#, #a2#" },
        };

    DevilsaurArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwl4#", "" },
        { 15063, "INV_Gauntlets_26", "=q3=魔暴龍皮手套", "=ds=#s9#, #a2#" },
        { 15062, "INV_Pants_Wolf", "=q3=魔暴龍皮護腿", "=ds=#s11#, #a2#" },
        };


    BloodTigerH = {
        { 0, "INV_Box_01", "=q6=#craftlwl5#", "" },
        { 19689, "INV_Shoulder_23", "=q3=血虎護肩", "=ds=#s3#, #a2#" },
        { 19688, "INV_Chest_Leather_07", "=q3=血虎胸甲", "=ds=#s5#, #a2#" },
        };
  
    PrimalBatskin = {
        { 0, "INV_Box_01", "=q6=#craftlwl6#", "" },
        { 19685, "INV_Chest_Leather_03", "=q3=原始蝙蝠皮外套", "=ds=#s5#, #a2#" },
        { 19687, "INV_Bracer_07", "=q3=原始蝙蝠皮護腕", "=ds=#s8#, #a2#" },
        { 19686, "INV_Gauntlets_31", "=q3=原始蝙蝠皮手套", "=ds=#s9#, #a2#" },
        };    

    WildDraenishA = {
        { 0, "INV_Box_01", "=q6=#craftlwl7#", "" },
        { 25676, "INV_Chest_Leather_07", "=q2=狂野德萊尼外衣", "=ds=#s5#, #a2#" },
        { 25674, "INV_Gauntlets_04", "=q2=狂野德萊尼手套", "=ds=#s9#, #a2#" },
        { 25675, "INV_Pants_Leather_07", "=q2=狂野德萊尼護腿", "=ds=#s11#, #a2#" },
        { 25673, "INV_Boots_Chain_01", "=q2=狂野德萊尼長靴", "=ds=#s12#, #a2#" },
        };
  
    ThickDraenicA = {
        { 0, "INV_Box_01", "=q6=#craftlwl8#", "" },
        { 25671, "INV_Chest_Leather_07", "=q2=厚德萊尼背心", "=ds=#s5#, #a2#" },
        { 25669, "INV_Gauntlets_04", "=q2=厚德萊尼手套", "=ds=#s9#, #a2#" },
        { 25670, "INV_Pants_Leather_07", "=q2=厚德萊尼短褲", "=ds=#s11#, #a2#" },
        { 25668, "INV_Boots_Chain_01", "=q2=厚德萊尼長靴", "=ds=#s12#, #a2#" },
        };  

    FelSkin = {
        { 0, "INV_Box_01", "=q6=#craftlwl9#", "" },
        { 25685, "INV_Gauntlets_22", "=q3=惡魔皮手套", "=ds=#s9#, #a2#" },
        { 25687, "INV_Pants_Leather_03", "=q3=惡魔皮護腿", "=ds=#s11#, #a2#" },
        { 25686, "INV_Boots_Cloth_05", "=q3=惡魔皮靴", "=ds=#s12#, #a2#" },
        };
  
    SClefthoof = {
        { 0, "INV_Box_01", "=q6=#craftlwl10#", "" },
        { 25689, "INV_Chest_Leather_06", "=q3=重型裂蹄背心", "=ds=#s5#, #a2#" },
        { 25690, "INV_Pants_12", "=q3=重型裂蹄護腿", "=ds=#s11#, #a2#" },
        { 25691, "INV_Boots_07", "=q3=重型裂蹄長靴", "=ds=#s12#, #a2#" },
        };

-- Leatherworking Mail Sets

    GreenDragonM = {
        { 0, "INV_Box_01", "=q6=#craftlwm1#", "=q1=#j13#" },
        { 15045, "INV_Chest_Chain_06", "=q3=綠龍鱗片胸甲", "=ds=#s5#, #a3#" },
        { 20296, "INV_Gauntlets_12", "=q3=綠色龍鱗護手", "=ds=#s9#, #a3#" },
        { 15046, "INV_Pants_05", "=q3=綠龍鱗片護腿", "=ds=#s11#, #a3#" },
        };

    BlueDragonM = {
        { 0, "INV_Box_01", "=q6=#craftlwm2#", "=q1=#j12#" },
        { 15049, "INV_Shoulder_18", "=q3=藍龍鱗片護肩", "=ds=#s3#, #a3#" },
        { 15048, "INV_Chest_Chain_04", "=q3=藍色龍鱗胸甲", "=ds=#s5#, #a3#" },
        { 20295, "INV_Pants_Mail_15", "=q3=藍色龍鱗護腿", "=ds=#s11#, #a3#" },
        }; 

    BlackDragonM = {
        { 0, "INV_Box_01", "=q6=#craftlwm3#", "=q1=#j11#" },
        { 15051, "INV_Shoulder_01", "=q3=黑龍鱗片護肩", "=ds=#s3#, #a3#" },
        { 15050, "INV_Chest_Plate06", "=q3=黑色龍鱗胸甲", "=ds=#s5#, #a3#" },
        { 15052, "INV_Pants_03", "=q3=黑色龍鱗護腿", "=ds=#s11#, #a3#" },
        { 16984, "INV_Boots_Plate_09","=q4=黑色龍鱗戰靴", "=ds=#s12#, #a3#" },
        };

    ScaledDraenicA = {
        { 0, "INV_Box_01", "=q6=#craftlwm4#", "" },
        { 25660, "INV_Chest_Chain_16", "=q2=德萊尼鱗甲背心", "=ds=#s5#, #a3#" },
        { 25661, "INV_Gauntlets_04", "=q2=德萊尼鱗甲手套", "=ds=#s9#, #a3#" },
        { 25662, "INV_Pants_Mail_07", "=q2=德萊尼鱗甲短褲", "=ds=#s11#, #a3#" },
        { 25659, "INV_Boots_Chain_01", "=q2=德萊尼鱗甲長靴", "=ds=#s12#, #a3#" },
        };    

    FelscaleArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwm5#", "" },
        { 25657, "INV_Chest_Chain_13", "=q2=魔鱗胸甲", "=ds=#s5#, #a3#" },
        { 25654, "INV_Gauntlets_04", "=q2=魔鱗護手", "=ds=#s9#, #a3#" },
        { 25656, "INV_Pants_Mail_08", "=q2=魔鱗護腿", "=ds=#s11#, #a3#" },
        { 25655, "INV_Boots_Chain_08", "=q2=魔鱗長靴", "=ds=#s12#, #a3#" },
        };    

    FelstalkerArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwm6#", "" },
        { 25696, "INV_Chest_Chain_13", "=q3=惡魔捕獵者胸甲", "=ds=#s5#, #a3#" },
        { 25697, "INV_Bracer_14", "=q3=惡魔捕獵者護腕", "=ds=#s8#, #a3#" },
        { 25695, "INV_Belt_13", "=q3=惡魔捕獵者腰帶", "=ds=#s10#, #a3#" },
        };

    NetherFury = {
        { 0, "INV_Box_01", "=q6=#craftlwm7#", "" },
        { 25694, "INV_Belt_15", "=q3=地獄之怒腰帶", "=ds=#s10#, #a3#" },
        { 25692, "INV_Pants_Plate_12", "=q3=地獄之怒護腿", "=ds=#s11#, #a3#" },
        { 25693, "INV_Boots_Chain_06", "=q3=地獄之怒長靴", "=ds=#s12#, #a3#" },
        };  

    PrimalIntent = {
        { 0, "INV_Box_01", "=q6=#craftlwe1#", "=q1=#p11#" },
        { 29525, "INV_Chest_Cloth_45", "=q4=原始之擊背心", "=ds=#s5#, #a2#" },
        { 29527, "INV_Bracer_07", "=q4=原始之擊護腕", "=ds=#s8#, #a2#" },
        { 29526, "INV_Belt_03", "=q4=原始之擊腰帶", "=ds=#s10#, #a2#" },
        };

    WindhawkArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwt1#", "=q1=#p10#" },
        { 29522, "INV_Chest_Leather_01", "=q4=風鷹鎖甲", "=ds=#s5#, #a2#" },
        { 29523, "INV_Bracer_07", "=q4=風鷹護婉", "=ds=#s8#, #a2#" },
        { 29524, "INV_Belt_03", "=q4=風鷹腰帶", "=ds=#s10#, #a2#" },
        };

    NetherscaleArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwd1#", "=q1=#p9#" },
        { 29515, "INV_Chest_Plate08", "=q4=黑地獄鱗胸甲", "=ds=#s5#, #a3#" },
        { 29517, "INV_Bracer_19", "=q4=黑地獄鱗護腕", "=ds=#s8#, #a3#" },
        { 29516, "INV_Belt_29", "=q4=黑地獄鱗腰帶", "=ds=#s10#, #a3#" },
        };
  
    NetherstrikeArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwd2#", "=q1=#p9#" },
        { 29519, "INV_Chest_Plate07", "=q4=地擊胸甲", "=ds=#s5#, #a3#" },
        { 29521, "INV_Bracer_12", "=q4=地擊護腕", "=ds=#s8#, #a3#" },
        { 29520, "INV_Belt_03", "=q4=地擊腰帶", "=ds=#s10#, #a3#" },
        };

-- Arena Season 1 Sets
 
    ArenaDruid = {
        { 0, "Spell_Nature_Regeneration", "=q6=#arenas1_1#", "" },
        { 28127, "INV_Helmet_30", "=q4=鬥士的龍皮頭盔", "=ds=#a2#, #s1#", "", "1630", "#arena#" },
        { 28129, "INV_Shoulder_12", "=q4=鬥士的龍皮護肩", "=ds=#a2#, #s3#", "", "1304", "#arena#" },
        { 28130, "INV_Chest_Leather_03", "=q4=鬥士的龍皮外衣", "=ds=#a2#, #s5#", "", "1630", "#arena#" },
        { 28126, "INV_Gauntlets_28", "=q4=鬥士的龍皮手套", "=ds=#a2#, #s9#", "", "978", "#arena#" },
        { 28128, "INV_Pants_Cloth_05", "=q4=鬥士的龍皮護腿", "=ds=#a2#, #s11#", "", "1630", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_Nature_Regeneration", "=q6=#arenas1_2#", "" },
        { 28137, "INV_Helmet_30", "=q4=鬥士的火龍皮頭盔", "=ds=#a2#, #s1#", "", "1630", "#arena#" },
        { 28139, "INV_Shoulder_12", "=q4=鬥士的火龍皮護肩", "=ds=#a2#, #s3#", "", "1304", "#arena#" },
        { 28140, "INV_Chest_Leather_03", "=q4=鬥士的火龍皮外衣", "=ds=#a2#, #s5#", "", "1630", "#arena#" },
        { 28136, "INV_Gauntlets_28", "=q4=鬥士的火龍皮手套", "=ds=#a2#, #s9#", "", "978", "#arena#" },
        { 28138, "INV_Pants_Cloth_05", "=q4=鬥士的火龍皮護腿", "=ds=#a2#, #s11#", "", "1630", "#arena#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Nature_Regeneration", "=q6=#arenas1_3#", "" },
        { 31376, "INV_Helmet_30", "=q4=鬥士的科多皮頭盔", "=ds=#a2#, #s1#", "", "1630", "#arena#" },
        { 31378, "INV_Shoulder_12", "=q4=鬥士的科多皮肩甲", "=ds=#a2#, #s3#", "", "1304", "#arena#" },
        { 31379, "INV_Chest_Leather_03", "=q4=鬥士的科多皮外衣", "=ds=#a2#, #s5#", "", "1630", "#arena#" },
        { 31375, "INV_Gauntlets_28", "=q4=鬥士的科多皮手套", "=ds=#a2#, #s9#", "", "978", "#arena#" },
        { 31377, "INV_Pants_Cloth_05", "=q4=鬥士的科多皮護腿", "=ds=#a2#, #s11#", "", "1630", "#arena#" },
        };

    ArenaHunter = {
        { 0, "Ability_Hunter_RunningShot", "=q6=#arenas2#", "" },
        { 28331, "INV_Helmet_09", "=q4=鬥士的鍊甲頭盔", "=ds=#a3#, #s1#", "", "1630", "#arena#" },
        { 28333, "INV_Shoulder_29", "=q4=鬥士的鍊甲護肩", "=ds=#a3#, #s3#", "", "1304", "#arena#" },
        { 28334, "INV_Chest_Chain_11", "=q4=鬥士的鍊甲", "=ds=#a3#, #s5#", "", "1630", "#arena#" },
        { 28335, "INV_Gauntlets_11", "=q4=鬥士的鍊甲護手", "=ds=#a3#, #s9#", "", "978", "#arena#" },
        { 28332, "INV_Pants_Mail_15", "=q4=鬥士的鍊甲護腿", "=ds=#a3#, #s11#", "", "1630", "#arena#" },
        };
        
    ArenaMage = {
        { 0, "Spell_Frost_IceStorm", "=q6=#arenas3#", "" },
        { 25855, "INV_Helmet_08", "=q4=鬥士的絲質斗篷", "=ds=#a1#, #s1#", "", "1630", "#arena#" },
        { 25854, "INV_Shoulder_19", "=q4=鬥士的絲質襯肩", "=ds=#a1#, #s3#", "", "1304", "#arena#" },
        { 25856, "INV_Chest_Leather_01", "=q4=鬥士的絲質外衣", "=ds=#a1#, #s5#", "", "1630", "#arena#" },
        { 25857, "INV_Gauntlets_19", "=q4=鬥士的絲質護腿", "=ds=#a1#, #s9#", "", "978", "#arena#" },
        { 25858, "INV_Pants_07", "=q4=鬥士的絲質長褲", "=ds=#a1#, #s11#", "", "1630", "#arena#" },
        };
        
    ArenaPaladin = {
        { 0, "Spell_Holy_SealOfMight", "=q6=#arenas4_1#", "" },
        { 27704, "INV_Helmet_22", "=q4=鬥士的薄層頭盔", "=ds=#a4#, #s1#", "", "1630", "#arena#" },
        { 27706, "INV_Shoulder_22", "=q4=鬥士的薄層肩甲", "=ds=#a4#, #s3#", "", "1304", "#arena#" },
        { 27702, "INV_Chest_Plate05", "=q4=鬥士的薄層胸甲", "=ds=#a4#, #s5#", "", "1630", "#arena#" },
        { 27703, "INV_Gauntlets_29", "=q4=鬥士的薄層手套", "=ds=#a4#, #s9#", "", "978", "#arena#" },
        { 27705, "INV_Pants_Plate_17", "=q4=鬥士的薄層護腿", "=ds=#a4#, #s11#", "", "1630", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_Holy_SealOfMight", "=q6=#arenas4_2#", "" },
        { 27881, "INV_Helmet_22", "=q4=鬥士的綴鱗頭盔", "=ds=#a4#, #s1#", "", "1630", "#arena#" },
        { 27883, "INV_Shoulder_22", "=q4=鬥士的綴鱗護肩", "=ds=#a4#, #s3#", "", "1304", "#arena#" },
        { 27879, "INV_Chest_Plate05", "=q4=鬥士的綴鱗胸甲", "=ds=#a4#, #s5#", "", "1630", "#arena#" },
        { 27880, "INV_Gauntlets_29", "=q4=鬥士的綴鱗手套", "=ds=#a4#, #s9#", "", "978", "#arena#" },
        { 27882, "INV_Pants_Plate_17", "=q4=鬥士的綴鱗護腿", "=ds=#a4#, #s11#", "", "1630", "#arena#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Holy_SealOfMight", "=q6=#arenas4_3#", "" },
        { 31616, "INV_Helmet_22", "=q4=鬥士的裝飾頭巾", "=ds=#a4#, #s1#", "", "1630", "#arena#" },
        { 31619, "INV_Shoulder_22", "=q4=鬥士的裝飾肩甲", "=ds=#a4#, #s3#", "", "1304", "#arena#" },
        { 31613, "INV_Chest_Plate05", "=q4=鬥士的裝飾護甲", "=ds=#a4#, #s5#", "", "1630", "#arena#" },
        { 31614, "INV_Gauntlets_29", "=q4=鬥士的裝飾手套", "=ds=#a4#, #s9#", "", "978", "#arena#" },
        { 31618, "INV_Pants_Plate_17", "=q4=鬥士的裝飾腿鎧", "=ds=#a4#, #s11#", "", "1630", "#arena#" },
        };

    ArenaPriest = {
        { 0, "Spell_Holy_PowerWordShield", "=q6=#arenas5_1#", "" },
        { 27708, "INV_Helmet_30", "=q4=鬥士的緞面頭巾", "=ds=#a1#, #s1#", "", "1630", "#arena#" },
        { 27710, "INV_Shoulder_02", "=q4=鬥士的緞面襯肩", "=ds=#a1#, #s3#", "", "1304", "#arena#" },
        { 27711, "INV_Chest_Cloth_43", "=q4=鬥士的緞面長袍", "=ds=#a1#, #s5#", "", "1630", "#arena#" },
        { 27707, "INV_Gauntlets_15", "=q4=鬥士的緞面手套", "=ds=#a1#, #s9#", "", "978", "#arena#" },
        { 27709, "INV_Pants_Cloth_05", "=q4=鬥士的緞面護腿", "=ds=#a1#, #s11#", "", "1630", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_Holy_PowerWordShield", "=q6=#arenas5_2#", "" },
        { 31410, "INV_Helmet_30", "=q4=鬥士的月布頭巾", "=ds=#a1#, #s1#", "", "1630", "#arena#" },
        { 31412, "INV_Shoulder_02", "=q4=鬥士的月布襯肩", "=ds=#a1#, #s3#", "", "1304", "#arena#" },
        { 31413, "INV_Chest_Cloth_43", "=q4=鬥士的月布長袍", "=ds=#a1#, #s5#", "", "1630", "#arena#" },
        { 31409, "INV_Gauntlets_15", "=q4=鬥士的月布手套", "=ds=#a1#, #s9#", "", "978", "#arena#" },
        { 31411, "INV_Pants_Cloth_05", "=q4=鬥士的月布護腿", "=ds=#a1#, #s11#", "", "1630", "#arena#" },
        };

    ArenaRogue = {
        { 0, "Ability_BackStab", "=q6=#arenas6#", "" },
        { 25830, "INV_Helmet_30", "=q4=鬥士的皮頭盔", "=ds=#a2#, #s1#", "", "1630", "#arena#" },
        { 25832, "INV_Shoulder_12", "=q4=鬥士的皮護肩", "=ds=#a2#, #s3#", "", "1304", "#arena#" },
        { 25831, "INV_Chest_Leather_03", "=q4=鬥士的皮外衣", "=ds=#a2#, #s5#", "", "1630", "#arena#" },
        { 25834, "INV_Gauntlets_28", "=q4=鬥士的皮手套", "=ds=#a2#, #s9#", "", "978", "#arena#" },
        { 25833, "INV_Pants_Cloth_05", "=q4=鬥士的皮護腿", "=ds=#a2#, #s11#", "", "1630", "#arena#" },
        };

    ArenaShaman = {
        { 0, "Spell_FireResistanceTotem_01", "=q6=#arenas7_1#", "" },
        { 25998, "INV_Helmet_09", "=q4=鬥士的連結頭盔", "=ds=#a3#, #s1#", "", "1630", "#arena#" },
        { 25999, "INV_Shoulder_29", "=q4=鬥士的連結護肩", "=ds=#a3#, #s3#", "", "1304", "#arena#" },
        { 25997, "INV_Chest_Chain_11", "=q4=鬥士的連結護甲", "=ds=#a3#, #s5#", "", "1630", "#arena#" },
        { 26000, "INV_Gauntlets_11", "=q4=鬥士的連結手套", "=ds=#a3#, #s9#", "", "978", "#arena#" },
        { 26001, "INV_Pants_Mail_15", "=q4=鬥士的連結護腿", "=ds=#a3#, #s11#", "", "1630", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_FireResistanceTotem_01", "=q6=#arenas7_2#", "" },
        { 27471, "INV_Helmet_09", "=q4=鬥士的鎖甲頭盔", "=ds=#a3#, #s1#", "", "1630", "#arena#" },
        { 27473, "INV_Shoulder_29", "=q4=鬥士的鎖甲護肩", "=ds=#a3#, #s3#", "", "1304", "#arena#" },
        { 27469, "INV_Chest_Chain_11", "=q4=鬥士的鎖甲", "=ds=#a3#, #s5#", "", "1630", "#arena#" },
        { 27470, "INV_Gauntlets_11", "=q4=鬥士的鎖甲手套", "=ds=#a3#, #s9#", "", "978", "#arena#" },
        { 27472, "INV_Pants_Mail_15", "=q4=鬥士的鎖甲護腿", "=ds=#a3#, #s11#", "", "1630", "#arena#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_FireResistanceTotem_01", "=q6=#arenas7_3#", "" },
        { 31400, "INV_Helmet_09", "=q4=鬥士的環型鎖甲頭盔", "=ds=#a3#, #s1#", "", "1630", "#arena#" },
        { 31407, "INV_Shoulder_29", "=q4=鬥士的環型鎖甲護肩", "=ds=#a3#, #s3#", "", "1304", "#arena#" },
        { 31396, "INV_Chest_Chain_11", "=q4=鬥士的環型鎖甲", "=ds=#a3#, #s5#", "", "1630", "#arena#" },
        { 31397, "INV_Gauntlets_11", "=q4=鬥士的環型鎖甲手套", "=ds=#a3#, #s9#", "", "978", "#arena#" },
        { 31406, "INV_Pants_Mail_15", "=q4=鬥士的環型鎖甲護腿", "=ds=#a3#, #s11#", "", "1630", "#arena#" },
        };

    ArenaWarlock = {
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#arenas8_1#", "" },
        { 24553, "INV_Helmet_30", "=q4=鬥士的鬼紋頭巾", "=ds=#a1#, #s1#", "", "1630", "#arena#" },
        { 24554, "INV_Shoulder_02", "=q4=鬥士的鬼紋襯肩", "=ds=#a1#, #s3#", "", "1304", "#arena#" },
        { 24552, "INV_Chest_Cloth_43", "=q4=鬥士的鬼紋長袍", "=ds=#a1#, #s5#", "", "1630", "#arena#" },
        { 24556, "INV_Gauntlets_15", "=q4=鬥士的鬼紋手套", "=ds=#a1#, #s9#", "", "978", "#arena#" },
        { 24555, "INV_Pants_Cloth_05", "=q4=鬥士的鬼紋護腿", "=ds=#a1#, #s11#", "", "1630", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#arenas8_2#", "" },
        { 30187, "INV_Helmet_08", "=q4=鬥士的地獄編織斗篷", "=ds=#a1#, #s1#", "", "1630", "#arena#" },
        { 30186, "INV_Shoulder_19", "=q4=鬥士的地獄編織護肩", "=ds=#a1#, #s3#", "", "1304", "#arena#" },
        { 30200, "INV_Chest_Leather_01", "=q4=鬥士的地獄編織外衣", "=ds=#a1#, #s5#", "", "1630", "#arena#" },
        { 30188, "INV_Gauntlets_19", "=q4=鬥士的地獄編織護手", "=ds=#a1#, #s9#", "", "978", "#arena#" },
        { 30201, "INV_Pants_07", "=q4=鬥士的地獄編織長褲", "=ds=#a1#, #s11#", "", "1630", "#arena#" },
        };
                
    ArenaWarrior = {
        { 0, "INV_Shield_05", "=q6=#arenas9#", "" },
        { 24545, "INV_Helmet_07", "=q4=鬥士的鎧甲頭盔", "=ds=#a4#, #s1#", "", "1630", "#arena#" },
        { 24546, "INV_Shoulder_22", "=q4=鬥士的鎧甲護肩", "=ds=#a4#, #s3#", "", "1304", "#arena#" },
        { 24544, "INV_Chest_Plate05", "=q4=鬥士的鎧甲胸甲", "=ds=#a4#, #s5#", "", "1630", "#arena#" },
        { 24549, "INV_Gauntlets_29", "=q4=鬥士的鎧甲手套", "=ds=#a4#, #s9#", "", "978", "#arena#" },
        { 24547, "INV_Pants_Plate_17", "=q4=鬥士的鎧甲護腿", "=ds=#a4#, #s11#", "", "1630", "#arena#" },
        };

-- Arena Season 2 Sets
        
    Arena2Druid = {
        { 0, "Spell_Nature_Regeneration", "=q6=#arena2s1_1#", "" },
        { 31968, "INV_Helmet_30", "=q4=殘忍鬥士的龍皮頭盔", "=ds=#a2#, #s1#", "", "1875", "#arena#" },
        { 31971, "INV_Shoulder_12", "=q4=殘忍鬥士的龍皮護肩", "=ds=#a2#, #s3#", "", "1500", "#arena#" },
        { 31972, "INV_Chest_Leather_03", "=q4=殘忍鬥士的龍皮大衣", "=ds=#a2#, #s5#", "", "1875", "#arena#" },
        { 31967, "INV_Gauntlets_28", "=q4=殘忍鬥士的龍皮手套", "=ds=#a2#, #s9#", "", "1125", "#arena#" },
        { 31969, "INV_Pants_Cloth_05", "=q4=殘忍鬥士的龍皮護腿", "=ds=#a2#, #s11#", "", "1875", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_Nature_Regeneration", "=q6=#arena2s1_2#", "" },
        { 32057, "INV_Helmet_30", "=q4=殘忍鬥士的火龍皮頭盔", "=ds=#a2#, #s1#", "", "1875", "#arena#" },
        { 32059, "INV_Shoulder_12", "=q4=殘忍鬥士的火龍皮護肩", "=ds=#a2#, #s3#", "", "1500", "#arena#" },
        { 32060, "INV_Chest_Leather_03", "=q4=殘忍鬥士的火龍皮外套", "=ds=#a2#, #s5#", "", "1875", "#arena#" },
        { 32056, "INV_Gauntlets_28", "=q4=殘忍鬥士的火龍皮手套", "=ds=#a2#, #s9#", "", "1125", "#arena#" },
        { 32058, "INV_Pants_Cloth_05", "=q4=殘忍鬥士的火龍皮護腿", "=ds=#a2#, #s11#", "", "1875", "#arena#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Nature_Regeneration", "=q6=#arena2s1_3#", "" },
        { 31988, "INV_Helmet_30", "=q4=殘忍鬥士的科多獸皮頭盔", "=ds=#a2#, #s1#", "", "1875", "#arena#" },
        { 31990, "INV_Shoulder_12", "=q4=殘忍鬥士的科多獸皮護肩", "=ds=#a2#, #s3#", "", "1500", "#arena#" },
        { 31991, "INV_Chest_Leather_03", "=q4=殘忍鬥士的科多獸皮上衣", "=ds=#a2#, #s5#", "", "1875", "#arena#" },
        { 31987, "INV_Gauntlets_28", "=q4=殘忍鬥士的科多獸皮手套", "=ds=#a2#, #s9#", "", "1125", "#arena#" },
        { 31989, "INV_Pants_Cloth_05", "=q4=殘忍鬥士的科多獸皮護腿", "=ds=#a2#, #s11#", "", "1875", "#arena#" },
        };
       
    Arena2Hunter = {
        { 0, "Ability_Hunter_RunningShot", "=q6=#arena2s2#", "" },
        { 31962, "INV_Helmet_09", "=q4=殘忍鬥士的鍊甲頭盔", "=ds=#a3#, #s1#", "", "1875", "#arena#" },
        { 31964, "INV_Shoulder_29", "=q4=殘忍鬥士的鍊甲護肩", "=ds=#a3#, #s3#", "", "1500", "#arena#" },
        { 31960, "INV_Chest_Chain_11", "=q4=殘忍鬥士的鍊甲護甲", "=ds=#a3#, #s5#", "", "1875", "#arena#" },
        { 31961, "INV_Gauntlets_11", "=q4=殘忍鬥士的鍊甲護手", "=ds=#a3#, #s9#", "", "1125", "#arena#" },
        { 31963, "INV_Pants_Mail_15", "=q4=殘忍鬥士的鍊甲護腿", "=ds=#a3#, #s11#", "", "1875", "#arena#" },
        };

    Arena2Mage = {
        { 0, "Spell_Frost_IceStorm", "=q6=#arena2s3#", "" },
        { 32048, "INV_Helmet_08", "=q4=殘忍鬥士的絲質罩帽", "=ds=#a1#, #s1#", "", "1875", "#arena#" },
        { 32047, "INV_Shoulder_19", "=q4=殘忍鬥士的絲質披肩", "=ds=#a1#, #s3#", "", "1500", "#arena#" },
        { 32050, "INV_Chest_Leather_01", "=q4=殘忍鬥士的絲質外衣", "=ds=#a1#, #s5#", "", "1875", "#arena#" },
        { 32049, "INV_Gauntlets_19", "=q4=殘忍鬥士的絲質護手", "=ds=#a1#, #s9#", "", "1125", "#arena#" },
        { 32051, "INV_Pants_07", "=q4=殘忍鬥士的絲質長褲", "=ds=#a1#, #s11#", "", "1875", "#arena#" },
        };

    Arena2Paladin = {
        { 0, "Spell_Holy_SealOfMight", "=q6=#arena2s4_1#", "" },
        { 31997, "INV_Helmet_22", "=q4=殘忍鬥士的片甲頭盔", "=ds=#a4#, #s1#", "", "1875", "#arena#" },
        { 31996, "INV_Shoulder_22", "=q4=殘忍鬥士的片甲護肩", "=ds=#a4#, #s3#", "", "1500", "#arena#" },
        { 31992, "INV_Chest_Plate05", "=q4=殘忍鬥士的片甲胸鎧", "=ds=#a4#, #s5#", "", "1875", "#arena#" },
        { 31993, "INV_Gauntlets_29", "=q4=殘忍鬥士的片甲護手", "=ds=#a4#, #s9#", "", "1125", "#arena#" },
        { 31995, "INV_Pants_Plate_17", "=q4=殘忍鬥士的片甲護腿", "=ds=#a4#, #s11#", "", "1875", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_Holy_SealOfMight", "=q6=#arena2s4_2#", "" },
        { 32041, "INV_Helmet_22", "=q4=殘忍鬥士的綴鱗頭盔", "=ds=#a4#, #s1#", "", "1875", "#arena#" },
        { 32043, "INV_Shoulder_22", "=q4=殘忍鬥士的綴鱗護肩", "=ds=#a4#, #s3#", "", "1500", "#arena#" },
        { 32039, "INV_Chest_Plate05", "=q4=殘忍鬥士的綴鱗胸甲", "=ds=#a4#, #s5#", "", "1875", "#arena#" },
        { 32040, "INV_Gauntlets_29", "=q4=殘忍鬥士的綴鱗手套", "=ds=#a4#, #s9#", "", "1125", "#arena#" },
        { 32042, "INV_Pants_Plate_17", "=q4=殘忍鬥士的綴鱗護腿", "=ds=#a4#, #s11#", "", "1875", "#arena#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Holy_SealOfMight", "=q6=#arena2s4_3#", "" },
        { 32022, "INV_Helmet_22", "=q4=殘忍鬥士的裝飾頭罩", "=ds=#a4#, #s1#", "", "1875", "#arena#" },
        { 32024, "INV_Shoulder_22", "=q4=殘忍鬥士的裝飾護肩", "=ds=#a4#, #s3#", "", "1500", "#arena#" },
        { 32020, "INV_Chest_Plate05", "=q4=殘忍鬥士的裝飾胸甲", "=ds=#a4#, #s5#", "", "1875", "#arena#" },
        { 32021, "INV_Gauntlets_29", "=q4=殘忍鬥士的裝飾手套", "=ds=#a4#, #s9#", "", "1125", "#arena#" },
        { 32023, "INV_Pants_Plate_17", "=q4=殘忍鬥士的裝飾護腿", "=ds=#a4#, #s11#", "", "1875", "#arena#" },
        };

    Arena2Priest = {
        { 0, "Spell_Holy_PowerWordShield", "=q6=#arena2s5_1#", "" },
        { 32035, "INV_Helmet_30", "=q4=殘忍鬥士的緞面頭巾", "=ds=#a1#, #s1#", "", "1875", "#arena#" },
        { 32037, "INV_Shoulder_02", "=q4=殘忍鬥士的緞面襯肩", "=ds=#a1#, #s3#", "", "1500", "#arena#" },
        { 32038, "INV_Chest_Cloth_43", "=q4=殘忍鬥士的緞面長袍", "=ds=#a1#, #s5#", "", "1875", "#arena#" },
        { 32034, "INV_Gauntlets_15", "=q4=殘忍鬥士的緞面手套", "=ds=#a1#, #s9#", "", "1125", "#arena#" },
        { 32036, "INV_Pants_Cloth_05", "=q4=殘忍鬥士的緞面護腿", "=ds=#a1#, #s11#", "", "1875", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_Holy_PowerWordShield", "=q6=#arena2s5_2#", "" },
        { 32016, "INV_Helmet_30", "=q4=殘忍鬥士的月布兜帽", "=ds=#a1#, #s1#", "", "1875", "#arena#" },
        { 32018, "INV_Shoulder_02", "=q4=殘忍鬥士的月布襯肩", "=ds=#a1#, #s3#", "", "1500", "#arena#" },
        { 32019, "INV_Chest_Cloth_43", "=q4=殘忍鬥士的月布長袍", "=ds=#a1#, #s5#", "", "1875", "#arena#" },
        { 32015, "INV_Gauntlets_15", "=q4=殘忍鬥士的月布手套", "=ds=#a1#, #s9#", "", "1125", "#arena#" },
        { 32017, "INV_Pants_Cloth_05", "=q4=殘忍鬥士的月布護腿", "=ds=#a1#, #s11#", "", "1875", "#arena#" },
        };

    Arena2Rogue = {
        { 0, "Ability_BackStab", "=q6=#arena2s6#", "" },
        { 31999, "INV_Helmet_30", "=q4=殘忍鬥士的皮質頭盔", "=ds=#a2#, #s1#", "", "1875", "#arena#" },
        { 32001, "INV_Shoulder_12", "=q4=殘忍鬥士的皮質護肩", "=ds=#a2#, #s3#", "", "1500", "#arena#" },
        { 32002, "INV_Chest_Leather_03", "=q4=殘忍鬥士的皮質上衣", "=ds=#a2#, #s5#", "", "1875", "#arena#" },
        { 31998, "INV_Gauntlets_28", "=q4=殘忍鬥士的皮質手套", "=ds=#a2#, #s9#", "", "1125", "#arena#" },
        { 32000, "INV_Pants_Cloth_05", "=q4=殘忍鬥士的皮質護腿", "=ds=#a2#, #s11#", "", "1875", "#arena#" },
        };

    Arena2Shaman = {
        { 0, "Spell_FireResistanceTotem_01", "=q6=#arena2s7_1#", "" },
        { 32006, "INV_Helmet_09", "=q4=殘忍鬥士的鎖鏈頭盔", "=ds=#a3#, #s1#", "", "1875", "#arena#" },
        { 32008, "INV_Shoulder_29", "=q4=殘忍鬥士的鎖鏈護肩", "=ds=#a3#, #s3#", "", "1500", "#arena#" },
        { 32004, "INV_Chest_Chain_11", "=q4=殘忍鬥士的鎖鏈護甲", "=ds=#a3#, #s5#", "", "1875", "#arena#" },
        { 32005, "INV_Gauntlets_11", "=q4=殘忍鬥士的鎖鏈護手", "=ds=#a3#, #s9#", "", "1125", "#arena#" },
        { 32007, "INV_Pants_Mail_15", "=q4=殘忍鬥士的鎖鏈護腿", "=ds=#a3#, #s11#", "", "1875", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_FireResistanceTotem_01", "=q6=#arena2s7_2#", "" },
        { 32011, "INV_Helmet_09", "=q4=殘忍鬥士的鎖甲頭盔", "=ds=#a3#, #s1#", "", "1875", "#arena#" },
        { 32013, "INV_Shoulder_29", "=q4=殘忍鬥士的鎖甲護肩", "=ds=#a3#, #s3#", "", "1500", "#arena#" },
        { 32009, "INV_Chest_Chain_11", "=q4=殘忍鬥士的鎖甲護甲", "=ds=#a3#, #s5#", "", "1875", "#arena#" },
        { 32010, "INV_Gauntlets_11", "=q4=殘忍鬥士的鎖甲護手", "=ds=#a3#, #s9#", "", "1125", "#arena#" },
        { 32012, "INV_Pants_Mail_15", "=q4=殘忍鬥士的鎖甲護腿", "=ds=#a3#, #s11#", "", "1875", "#arena#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_FireResistanceTotem_01", "=q6=#arena2s7_3#", "" },
        { 32031, "INV_Helmet_09", "=q4=殘忍鬥士的環型鎖甲頭盔", "=ds=#a3#, #s1#", "", "1875", "#arena#" },
        { 32033, "INV_Shoulder_29", "=q4=殘忍鬥士的環型鎖甲護肩", "=ds=#a3#, #s3#", "", "1500", "#arena#" },
        { 32029, "INV_Chest_Chain_11", "=q4=殘忍鬥士的環型鎖甲", "=ds=#a3#, #s5#", "", "1875", "#arena#" },
        { 32030, "INV_Gauntlets_11", "=q4=殘忍鬥士的環型鎖甲手套", "=ds=#a3#, #s9#", "", "1125", "#arena#" },
        { 32032, "INV_Pants_Mail_15", "=q4=殘忍鬥士的環型鎖甲護腿", "=ds=#a3#, #s11#", "", "1875", "#arena#" },
        };

    Arena2Warlock = {
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#arena2s8_1#", "" },
        { 31974, "INV_Helmet_30", "=q4=殘忍鬥士的鬼紋兜帽", "=ds=#a1#, #s1#", "", "1875", "#arena#" },
        { 31976, "INV_Shoulder_02", "=q4=殘忍鬥士的鬼紋襯肩", "=ds=#a1#, #s3#", "", "1500", "#arena#" },
        { 31977, "INV_Chest_Cloth_43", "=q4=殘忍鬥士的鬼紋長袍", "=ds=#a1#, #s5#", "", "1875", "#arena#" },
        { 31973, "INV_Gauntlets_15", "=q4=殘忍鬥士的鬼紋手套", "=ds=#a1#, #s9#", "", "1125", "#arena#" },
        { 31975, "INV_Pants_Cloth_05", "=q4=殘忍鬥士的鬼紋護腿", "=ds=#a1#, #s11#", "", "1875", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#arena2s8_2#", "" },
        { 31980, "INV_Helmet_08", "=q4=殘忍鬥士的地獄編織兜帽", "=ds=#a1#, #s1#", "", "1875", "#arena#" },
        { 31979, "INV_Shoulder_19", "=q4=殘忍鬥士的地獄編織披肩", "=ds=#a1#, #s3#", "", "1500", "#arena#" },
        { 31982, "INV_Chest_Leather_01", "=q4=殘忍鬥士的地獄編織上衣", "=ds=#a1#, #s5#", "", "1875", "#arena#" },
        { 31981, "INV_Gauntlets_19", "=q4=殘忍鬥士的地獄編織護手", "=ds=#a1#, #s9#", "", "1125", "#arena#" },
        { 31983, "INV_Pants_07", "=q4=殘忍鬥士的地獄編織長褲", "=ds=#a1#, #s11#", "", "1875", "#arena#" },
        };

    Arena2Warrior = {
        { 0, "INV_Shield_05", "=q6=#arena2s9#", "" },
        { 30488, "INV_Helmet_22", "=q4=殘忍鬥士的鎧甲頭盔", "=ds=#a4#, #s1#", "", "1875", "#arena#" },
        { 30490, "INV_Shoulder_22", "=q4=殘忍鬥士的鎧甲護肩", "=ds=#a4#, #s3#", "", "1500", "#arena#" },
        { 30486, "INV_Chest_Plate05", "=q4=殘忍鬥士的鎧甲胸甲", "=ds=#a4#, #s5#", "", "1875", "#arena#" },
        { 30487, "INV_Gauntlets_29", "=q4=殘忍鬥士的鎧甲手套", "=ds=#a4#, #s9#", "", "1125", "#arena#" },
        { 30489, "INV_Pants_Plate_17", "=q4=殘忍鬥士的鎧甲護腿", "=ds=#a4#, #s11#", "", "1875", "#arena#" },
        };

-- Tier 6 Sets (T6)

    T6Druid = {
        { 0,"Spell_Nature_Regeneration","=q6=#t6s1_1#","" },
        { 31039, "INV_Helmet_94", "=q4=雷霆之心頭巾", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31048, "INV_Shoulder_58", "=q4=雷霆之心肩甲", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31042, "INV_Chest_Leather_15", "=q4=雷霆之心胸甲", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31034, "INV_Gauntlets_58", "=q4=雷霆之心護手", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31044, "INV_Pants_Leather_26", "=q4=雷霆之心護腿", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        { 0,"","","" },
        { 0,"Spell_Nature_Regeneration","=q6=#t6s1_2#","" },
        { 31037, "INV_Helmet_94", "=q4=雷霆之心頭盔", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31047, "INV_Shoulder_58", "=q4=雷霆之心肩甲", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31041, "INV_Chest_Leather_15", "=q4=雷霆之心外套", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31032, "INV_Gauntlets_58", "=q4=雷霆之心手套", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31045, "INV_Pants_Leather_26", "=q4=雷霆之心護腿", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_Nature_Regeneration","=q6=#t6s1_3#","" },
        { 31040, "INV_Helmet_94", "=q4=雷霆之心頭盔", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31049, "INV_Shoulder_58", "=q4=雷霆之心護肩", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31043, "INV_Chest_Leather_15", "=q4=雷霆之心外衣", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31035, "INV_Gauntlets_58", "=q4=雷霆之心護手", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31046, "INV_Pants_Leather_26", "=q4=雷霆之心短褲", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

    T6Hunter = {
        { 0,"Ability_Hunter_RunningShot","=q6=#t6s2#","" },
        { 31003, "INV_Helmet_95", "=q4=古羅行者的頭盔", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31006, "INV_Shoulder_59", "=q4=古羅行者的的護肩", "=ds="..AtlasLootBossNames["BlackTemple"][7] }, 
        { 31004, "INV_Chest_Mail_03", "=q4=古羅行者的胸甲", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31001, "INV_Gauntlets_59", "=q4=古羅行者的手套", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31005, "INV_Pants_Mail_24", "=q4=古羅行者的護腿", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

    T6Mage = {
        { 0,"Spell_Frost_IceStorm","=q6=#t6s3#","" },
        { 31056, "Inv_Helmet_101", "=q4=風暴兜帽", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31059, "Inv_Shoulder_64", "=q4=風暴襯肩", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31057, "Inv_Chest_Cloth_67", "=q4=風暴長袍", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31055, "Inv_Gauntlets_64", "=q4=風暴手套", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31058, "Inv_Pants_Cloth_28", "=q4=風暴護腿", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

    T6Paladin = {
        { 0,"Spell_Holy_SealOfMight","=q6=#t6s4_1#","" },
        { 30987, "INV_Helmet_96", "=q4=光明使者面罩", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 30998, "INV_Shoulder_60", "=q4=光明使者護肩", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 30991, "INV_Chest_Plate_22", "=q4=光明使者護胸", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 30985, "INV_Gauntlets_60", "=q4=光明使者護手", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 30995, "INV_Pants_Plate_26", "=q4=光明使者腿甲", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        { 0,"","","" },
        { 0,"Spell_Holy_SealOfMight","=q6=#t6s4_2#","" },
        { 30989, "INV_Helmet_96", "=q4=光明使者戰爭頭盔", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 30997, "INV_Shoulder_60", "=q4=光明使者肩甲", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 30990, "INV_Chest_Plate_22", "=q4=光明使者胸鎧", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 30982, "INV_Gauntlets_60", "=q4=光明使者臂鎧", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 30993, "INV_Pants_Plate_26", "=q4=光明使者護脛", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_Holy_SealOfMight","=q6=#t6s4_3#","" },
        { 30988, "INV_Helmet_96", "=q4=光明使者巨型頭盔", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 30996, "INV_Shoulder_60", "=q4=光明使者護肩", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 30992, "INV_Chest_Plate_22", "=q4=光明使者上衣", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 30983, "INV_Gauntlets_60", "=q4=光明使者手套", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 30994, "INV_Pants_Plate_26", "=q4=光明使者護腿", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

    T6Priest = {
        { 0,"Spell_Holy_PowerWordShield","=q6=#t6s5_1#","" },
        { 31064, "INV_Helmet_99", "=q4=赦免頭巾", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31070, "INV_Shoulder_63", "=q4=赦免護肩", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31065, "INV_Chest_Cloth_66", "=q4=赦免裹布", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31061, "INV_Gauntlets_63", "=q4=赦免護手", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31067, "INV_Pants_Cloth_27", "=q4=赦免護腿", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        { 0,"","","" },
        { 0,"Spell_Holy_PowerWordShield","=q6=#t6s5_2#","" },
        { 31063, "INV_Helmet_99", "=q4=赦免兜帽", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31069, "INV_Shoulder_63", "=q4=赦免襯肩", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31066, "INV_Chest_Cloth_66", "=q4=赦免外套", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31060, "INV_Gauntlets_63", "=q4=赦免手套", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31068, "INV_Pants_Cloth_27", "=q4=赦免長褲", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

    T6Rogue = {
        { 0,"Ability_BackStab","=q6=#t6s6#","" },
        { 31027, "Inv_Helmet_102", "=q4=屠殺者頭盔", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31030, "Inv_Shoulder_67", "=q4=屠殺者肩甲", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31028, "Inv_Chest_Leather_16", "=q4=屠殺者胸甲", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31026, "Inv_Gauntlets_65", "=q4=屠殺者護手", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31029, "Inv_Pants_Leather_27", "=q4=屠殺者護腿", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

    T6Shaman = {
        { 0,"Spell_FireResistanceTotem_01","=q6=#t6s7_1#","" },
        { 31015, "INV_Helmet_97", "=q4=天擊頭巾", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31024, "INV_Shoulder_61", "=q4=天擊肩甲", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31018, "INV_Chest_Mail_04", "=q4=天擊外衣", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31011, "INV_Gauntlets_61", "=q4=天擊手套", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31021, "INV_Pants_Mail_25", "=q4=天擊短褲", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        { 0,"","","" },
        { 0,"Spell_FireResistanceTotem_01","=q6=#t6s7_2#","" },
        { 31012, "INV_Helmet_97", "=q4=天擊頭盔", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31022, "INV_Shoulder_61", "=q4=天擊護肩", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31016, "INV_Chest_Mail_04", "=q4=天擊護甲", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31007, "INV_Gauntlets_61", "=q4=天擊手套", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31019, "INV_Pants_Mail_25", "=q4=天擊護腿", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_FireResistanceTotem_01","=q6=#t6s7_3#","" },
        { 31014, "INV_Helmet_97", "=q4=天擊頭盔", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31023, "INV_Shoulder_61", "=q4=天擊襯肩", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31017, "INV_Chest_Mail_04", "=q4=天擊胸甲", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31008, "INV_Gauntlets_61", "=q4=天擊護手", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31020, "INV_Pants_Mail_25", "=q4=天擊腿甲", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

    T6Warlock = {
        { 0,"Spell_Shadow_CurseOfTounges","=q6=#t6s8#","" },
        { 31051, "INV_Helmet_103", "=q4=邪惡頭罩", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31054, "INV_Shoulder_68", "=q4=邪惡襯肩", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31052, "INV_Chest_Cloth_68", "=q4=邪惡長袍", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31050, "INV_Gauntlets_66", "=q4=邪惡手套", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31053, "INV_Pants_Cloth_29", "=q4=邪惡護腿", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

    T6Warrior = {
        { 0,"INV_Shield_05","=q6=#t6s9_1#","" },
        { 30974, "INV_Helmet_98", "=q4=猛擊頭甲", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 30980, "INV_Shoulder_62", "=q4=猛擊肩甲", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 30976, "INV_Chest_Plate_23", "=q4=猛擊胸甲", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 30970, "INV_Gauntlets_62", "=q4=猛擊護手", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 30978, "INV_Pants_Plate_27", "=q4=猛擊腿甲", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        { 0,"","","" },
        { 0,"INV_Shield_05","=q6=#t6s9_2#","" },
        { 30972, "INV_Helmet_98", "=q4=猛擊戰爭頭盔", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 30979, "INV_Shoulder_62", "=q4=猛擊護肩", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 30975, "INV_Chest_Plate_23", "=q4=猛擊胸鎧", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 30969, "INV_Gauntlets_62", "=q4=猛擊護手", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 30977, "INV_Pants_Plate_27", "=q4=猛擊護脛", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

-- Tier 5 Sets (T5)

    T5Druid = {
        { 0,"Spell_Nature_Regeneration","=q6=#t5s1_1#","" },
        { 30228, "INV_Helmet_15", "=q4=諾達希爾頭飾", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30230, "INV_Shoulder_14", "=q4=諾達希爾野獸護肩", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30222, "INV_Chest_Chain_15", "=q4=諾達希爾胸甲", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30223, "INV_Gauntlets_25", "=q4=諾達希爾裹手", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30229, "INV_Pants_Mail_15", "=q4=諾達希爾野獸褶裙", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        { 0,"","","" },
        { 0,"Spell_Nature_Regeneration","=q6=#t5s1_2#","" },
        { 30219, "INV_Helmet_15", "=q4=諾達希爾頭盔", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30221, "INV_Shoulder_14", "=q4=諾達希爾生命護肩", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30216, "INV_Chest_Chain_15", "=q4=諾達希爾護甲", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30217, "INV_Gauntlets_25", "=q4=諾達希爾手套", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30220, "INV_Pants_Mail_15", "=q4=諾達希爾生命褶裙", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_Nature_Regeneration","=q6=#t5s1_3#","" },
        { 30233, "INV_Helmet_15", "=q4=諾達希爾頭飾", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30235, "INV_Shoulder_14", "=q4=諾達希爾怒氣襯肩", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30231, "INV_Chest_Chain_15", "=q4=諾達希爾護胸", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30232, "INV_Gauntlets_25", "=q4=諾達希爾護手", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30234, "INV_Pants_Mail_15", "=q4=諾達希爾怒氣褶裙", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };

    T5Hunter = {
        { 0,"Ability_Hunter_RunningShot","=q6=#t5s2#","" },
        { 30141, "INV_Helmet_15", "=q4=裂縫行者頭盔", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30143, "INV_Shoulder_14", "=q4=裂縫行者櫬肩", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30139, "INV_Chest_Chain_15", "=q4=裂縫行者鎖甲", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30140, "INV_Gauntlets_25", "=q4=裂縫行者護手", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30142, "INV_Pants_Mail_15", "=q4=裂縫行者護腿", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };
        
    T5Mage = {
        { 0,"Spell_Frost_IceStorm","=q6=#t5s3#","" },
        { 30206, "INV_Crown_01", "=q4=提里斯法兜帽", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30210, "INV_Shoulder_25", "=q4=提里斯法襯肩", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30196, "INV_Chest_Cloth_43", "=q4=提里斯法長袍", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30205, "INV_Gauntlets_17", "=q4=提里斯法手套", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30207, "INV_Pants_Cloth_05", "=q4=提里斯法護腿", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };
        
    T5Paladin = {
        { 0,"Spell_Holy_SealOfMight","=q6=#t5s4_1#","" },
        { 30125, "INV_Helmet_15", "=q4=晶鑄面罩", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30127, "INV_Shoulder_14", "=q4=晶鑄護肩", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30123, "INV_Chest_Chain_15", "=q4=晶鑄護胸", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30124, "INV_Gauntlets_25", "=q4=晶鑄護手", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30126, "INV_Pants_Mail_15", "=q4=晶鑄護腿", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        { 0,"","","" },
        { 0,"Spell_Holy_SealOfMight","=q6=#t5s4_2#","" },
        { 30131, "INV_Helmet_15", "=q4=晶鑄戰爭頭盔", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30133, "INV_Shoulder_14", "=q4=晶鑄肩甲", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30129, "INV_Chest_Chain_15", "=q4=晶鑄胸甲", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30130, "INV_Gauntlets_25", "=q4=晶鑄護手", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30132, "INV_Pants_Mail_15", "=q4=晶鑄護脛", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_Holy_SealOfMight","=q6=#t5s4_3#","" },
        { 30136, "INV_Helmet_15", "=q4=晶鑄頭盔", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30138, "INV_Shoulder_14", "=q4=晶鑄護肩", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30134, "INV_Chest_Chain_15", "=q4=晶鑄胸甲", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30135, "INV_Gauntlets_25", "=q4=晶鑄手套", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30137, "INV_Pants_Mail_15", "=q4=晶鑄腿甲", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };

    T5Priest = {
        { 0,"Spell_Holy_PowerWordShield","=q6=#t5s5_1#","" },
        { 30152, "INV_Crown_01", "=q4=幻化兜帽", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30154, "INV_Shoulder_25", "=q4=幻化襯肩", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30150, "INV_Chest_Cloth_43", "=q4=幻化外套", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30151, "INV_Gauntlets_17", "=q4=幻化手套", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30153, "INV_Pants_Cloth_05", "=q4=幻化長褲", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        { 0,"","","" },
        { 0,"Spell_Holy_PowerWordShield","=q6=#t5s5_2#","" },
        { 30161, "INV_Crown_01", "=q4=幻身頭飾", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30163, "INV_Shoulder_25", "=q4=幻身翼肩", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30159, "INV_Chest_Cloth_43", "=q4=幻身裹布", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30160, "INV_Gauntlets_17", "=q4=幻身護手", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30162, "INV_Pants_Cloth_05", "=q4=幻身護腿", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };

    T5Rogue = {
        { 0,"Ability_BackStab","=q6=#t5s6#","" },
        { 30146, "INV_Helmet_58", "=q4=死神傳承頭盔", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30149, "INV_Shoulder_29", "=q4=死神傳承肩甲", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30144, "INV_Chest_Plate02", "=q4=死神傳承胸甲", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30145, "INV_Gauntlets_28", "=q4=死神傳承護手", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30148, "INV_Pants_Plate_05", "=q4=死神傳承護腿", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };

    T5Shaman = {
        { 0,"Spell_FireResistanceTotem_01","=q6=#t5s7_1#","" },
        { 30190, "INV_Helmet_15", "=q4=裂地頭盔", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30194, "INV_Shoulder_14", "=q4=裂地護肩", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30185, "INV_Chest_Plate08", "=q4=裂地板層甲", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30189, "INV_Gauntlets_25", "=q4=裂地護手", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30192, "INV_Pants_Mail_15", "=q4=裂地腿甲", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        { 0,"","","" },
        { 0,"Spell_FireResistanceTotem_01","=q6=#t5s7_2#","" },
        { 30166, "INV_Helmet_15", "=q4=裂地頭罩", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30168, "INV_Shoulder_14", "=q4=裂地護肩", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30164, "INV_Chest_Plate08", "=q4=裂地胸甲", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30165, "INV_Gauntlets_25", "=q4=裂地手套", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30167, "INV_Pants_Mail_15", "=q4=裂地腿甲", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_FireResistanceTotem_01","=q6=#t5s7_3#","" },
        { 30171, "INV_Helmet_15", "=q4=裂地頭甲", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30173, "INV_Shoulder_14", "=q4=裂地肩甲", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30169, "INV_Chest_Plate08", "=q4=裂地護胸", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30170, "INV_Gauntlets_25", "=q4=裂地裹手", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30172, "INV_Pants_Mail_15", "=q4=裂地護腿", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };

    T5Warlock = {
        { 0,"Spell_Shadow_CurseOfTounges","=q6=#t5s8#","" },
        { 30212, "INV_Crown_01", "=q4=墮落兜帽", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30215, "INV_Shoulder_25", "=q4=墮落襯肩", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30214, "INV_Chest_Cloth_43", "=q4=墮落長袍", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30211, "INV_Gauntlets_17", "=q4=墮落手套", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30213, "INV_Pants_Cloth_05", "=q4=墮落護腿", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };
                
    T5Warrior = {
        { 0,"INV_Shield_05","=q6=#t5s9_1#","" },
        { 30115, "INV_Helmet_58", "=q4=摧毀者頭盔", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30117, "INV_Shoulder_29", "=q4=摧毀者肩甲", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30113, "INV_Chest_Plate02", "=q4=摧毀者護胸", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30114, "INV_Gauntlets_28", "=q4=摧毀者裹手", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30116, "INV_Pants_Plate_05", "=q4=摧毀者腿甲", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        { 0,"","","" },
        { 0,"INV_Shield_05","=q6=#t5s9_2#","" },
        { 30120, "INV_Helmet_58", "=q4=摧毀者戰鬥頭盔", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30122, "INV_Shoulder_29", "=q4=摧毀者護肩", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30118, "INV_Chest_Plate02", "=q4=摧毀者胸甲", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30119, "INV_Gauntlets_28", "=q4=摧毀者護手", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30121, "INV_Pants_Plate_05", "=q4=摧毀者護脛", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };

-- Tier 4 Sets (T4)
        
    T4Druid = {
        { 0,"Spell_Nature_Regeneration","=q6=#t4s1_1#","" },
        { 29098, "INV_Helmet_15", "=q4=瑪洛尼之熊鹿頭盔", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29100, "INV_Shoulder_14", "=q4=瑪洛尼襯肩", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29096, "INV_Chest_Chain_15", "=q4=瑪洛尼胸甲", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29097, "INV_Gauntlets_25", "=q4=瑪洛尼護手", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29099, "INV_Pants_Mail_15", "=q4=瑪洛尼護脛", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        { 0,"","","" },
        { 0,"Spell_Nature_Regeneration","=q6=#t4s1_2#","" },
        { 29086, "INV_Helmet_15", "=q4=瑪洛尼王冠", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29089, "INV_Shoulder_14", "=q4=瑪洛尼護肩", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29087, "INV_Chest_Chain_15", "=q4=瑪洛尼胸甲", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29090, "INV_Gauntlets_25", "=q4=瑪洛尼手套", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29088, "INV_Pants_Mail_15", "=q4=瑪洛尼護腿", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_Nature_Regeneration","=q6=#t4s1_3#","" },
        { 29093, "INV_Helmet_15", "=q4=瑪洛尼鹿角", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29095, "INV_Shoulder_14", "=q4=瑪洛尼肩甲", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29091, "INV_Chest_Chain_15", "=q4=瑪洛尼胸甲", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29092, "INV_Gauntlets_25", "=q4=瑪洛尼手套", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29094, "INV_Pants_Mail_15", "=q4=瑪洛尼馬褲", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };
            
    T4Hunter = {
        { 0,"Ability_Hunter_RunningShot","=q6=#t4s2#","" },
        { 29081, "INV_Helmet_15", "=q4=惡魔獵者頭甲", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29084, "INV_Shoulder_14", "=q4=惡魔獵者肩甲", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29082, "INV_Chest_Chain_15", "=q4=惡魔獵者背心", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29085, "INV_Gauntlets_25", "=q4=惡魔獵者護手", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29083, "INV_Pants_Mail_15", "=q4=惡魔獵者護脛", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };
    
    T4Mage = {
        { 0,"Spell_Frost_IceStorm","=q6=#t4s3#","" },
        { 29076, "INV_Crown_01", "=q4=奧多爾頭盔", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29079, "INV_Shoulder_25", "=q4=奧多爾肩甲", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29077, "INV_Chest_Cloth_43", "=q4=奧多爾外套", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29080, "INV_Gauntlets_17", "=q4=奧多爾手套", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29078, "INV_Pants_Cloth_05", "=q4=奧多爾裹腿", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };
        
    T4Paladin = {
        { 0,"Spell_Holy_SealOfMight","=q6=#t4s4_1#","" },
        { 29068, "INV_Helmet_15", "=q4=審判者頭盔", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29070, "INV_Shoulder_14", "=q4=審判者護肩", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29066, "INV_Chest_Chain_15", "=q4=審判者胸甲", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29067, "INV_Gauntlets_25", "=q4=審判者護手", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29069, "INV_Pants_Mail_15", "=q4=審判者腿甲", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        { 0,"","","" },
        { 0,"Spell_Holy_SealOfMight","=q6=#t4s4_2#","" },
        { 29073, "INV_Helmet_15", "=q4=審判者之冠", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29075, "INV_Shoulder_14", "=q4=審判者肩鎧", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29071, "INV_Chest_Chain_15", "=q4=審判者胸鎧", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29072, "INV_Gauntlets_25", "=q4=審判者臂鎧", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29074, "INV_Pants_Mail_15", "=q4=審判者脛甲", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_Holy_SealOfMight","=q6=#t4s4_3#","" },
        { 29061, "INV_Helmet_15", "=q4=審判者王冠", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29064, "INV_Shoulder_14", "=q4=審判者肩甲", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29062, "INV_Chest_Chain_15", "=q4=審判者護胸", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29065, "INV_Gauntlets_25", "=q4=審判者手套", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29063, "INV_Pants_Mail_15", "=q4=審判者護腿", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };

    T4Priest = {
        { 0,"Spell_Holy_PowerWordShield","=q6=#t4s5_1#","" },
        { 29049, "INV_Crown_01", "=q4=虛形聖光項圈", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29054, "INV_Shoulder_25", "=q4=虛形聖光披風", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29050, "INV_Chest_Cloth_43", "=q4=虛形長袍", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29055, "INV_Gauntlets_17", "=q4=虛形裹手", AtlasLootBossNames["Karazhan"][1] },
        { 29053, "INV_Pants_Cloth_05", "=q4=虛形長褲", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        { 0,"","","" },
        { 0,"Spell_Holy_PowerWordShield","=q6=#t4s5_2#","" },
        { 29058, "INV_Crown_01", "=q4=虛形靈魂頭冠", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29060, "INV_Shoulder_25", "=q4=虛形靈魂襯肩", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29056, "INV_Chest_Cloth_43", "=q4=虛形裹布", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29057, "INV_Gauntlets_17", "=q4=虛形手套", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29059, "INV_Pants_Cloth_05", "=q4=虛形護腿", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };

    T4Rogue = {
        { 0,"Ability_BackStab","=q6=#t4s6#","" },
        { 29044, "INV_Helmet_58", "=q4=地獄之刃面罩", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29047, "INV_Shoulder_29", "=q4=地獄之刃肩甲", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29045, "INV_Chest_Plate02", "=q4=地獄之刃胸甲", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29048, "INV_Gauntlets_28", "=q4=地獄之刃手套", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29046, "INV_Pants_Plate_05", "=q4=地獄之刃長褲", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };

    T4Shaman = {
        { 0,"Spell_FireResistanceTotem_01","=q6=#t4s7_1#","" },
        { 29040, "INV_Helmet_15", "=q4=暴風頭罩", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29043, "INV_Shoulder_14", "=q4=暴風肩鎧", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29038, "INV_Chest_Chain_15", "=q4=暴風胸甲", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29039, "INV_Gauntlets_25", "=q4=暴風護手", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29042, "INV_Pants_Mail_15", "=q4=暴風戰爭短裙", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        { 0,"","","" },
        { 0,"Spell_FireResistanceTotem_01","=q6=#t4s7_2#","" },
        { 29028, "INV_Helmet_15", "=q4=暴風頭盔", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29031, "INV_Shoulder_14", "=q4=暴風護肩", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29029, "INV_Chest_Chain_15", "=q4=暴風護甲", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29032, "INV_Gauntlets_25", "=q4=暴風手套", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29030, "INV_Pants_Mail_15", "=q4=暴風短裙", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_FireResistanceTotem_01","=q6=#t4s7_3#","" },
        { 29035, "INV_Helmet_15", "=q4=暴風面罩", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29037, "INV_Shoulder_14", "=q4=暴風肩甲", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29033, "INV_Chest_Chain_15", "=q4=暴風護胸", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29034, "INV_Gauntlets_25", "=q4=暴風裹手", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29036, "INV_Pants_Mail_15", "=q4=暴風護腿", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };

    T4Warlock = {
        { 0,"Spell_Shadow_CurseOfTounges","=q6=#t4s8#","" },
        { 28963, "INV_Crown_01", "=q4=虛空之心王冠", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 28967, "INV_Shoulder_25", "=q4=虛空之心襯肩", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 28964, "INV_Chest_Cloth_43", "=q4=虛空之心長袍", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 28968, "INV_Gauntlets_17", "=q4=虛空之心手套", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 28966, "INV_Pants_Cloth_05", "=q4=虛空之心護腿", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };
     
    T4Warrior = {
        { 0,"INV_Shield_05","=q6=#t4s9_1#","" },
        { 29011, "INV_Helmet_58", "=q4=戰爭使者巨型頭盔", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29016, "INV_Shoulder_29", "=q4=戰爭使者肩胄", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29012, "INV_Chest_Plate02", "=q4=戰爭使者胸甲", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29017, "INV_Gauntlets_28", "=q4=戰爭使者護手", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29015, "INV_Pants_Plate_05", "=q4=戰爭使者腿甲", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        { 0,"","","" },
        { 0,"INV_Shield_05","=q6=#t4s9_2#","" },
        { 29021, "INV_Helmet_58", "=q4=戰爭使者戰鬥頭盔", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29023, "INV_Shoulder_29", "=q4=戰爭使者肩甲", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29019, "INV_Chest_Plate02", "=q4=戰爭使者胸甲", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29020, "INV_Gauntlets_28", "=q4=戰爭使者護手", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29022, "INV_Pants_Plate_05", "=q4=戰爭使者脛甲", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };

-- Tier 3 Sets (T3)
        
    T3Druid = {
        { 0,"Spell_Nature_Regeneration","=q6=#t3s1#","" },
        { 22490, "INV_Helmet_15", "=q4=夢行者頭盔", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22491, "INV_Shoulder_14", "=q4=夢行者肩甲", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2] },
        { 22488, "INV_Chest_Chain_15", "=q4=夢行者外套", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22495, "INV_Bracer_02", "=q4=夢行者護腕", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22493, "INV_Gauntlets_25", "=q4=夢行者護手", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22494, "INV_Belt_22", "=q4=夢行者束腰", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22489, "INV_Pants_Mail_15", "=q4=夢行者護腿", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22492, "INV_Boots_Chain_05", "=q4=夢行者長靴", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9] },
        { 23064, "INV_Jewelry_Ring_51Naxxramas", "=q4=夢行者戒指", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

    T3Hunter = {
        { 0,"Ability_Hunter_RunningShot","=q6=#t3s2#","" },
        { 22438, "INV_Helmet_15", "=q4=地穴行者頭盔", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22439, "INV_Shoulder_14", "=q4=地穴行者肩甲", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2] },
        { 22436, "INV_Chest_Chain_15", "=q4=地穴行者外套", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22443, "INV_Bracer_02", "=q4=地穴行者護腕", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22441, "INV_Gauntlets_25", "=q4=地穴行者護手", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22442, "INV_Belt_22", "=q4=地穴行者束腰", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22437, "INV_Pants_Mail_15", "=q4=地穴行者護腿", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22440, "INV_Boots_Chain_05", "=q4=地穴行者長靴", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9] },
        { 23067, "INV_Jewelry_Ring_51Naxxramas", "=q4=地室戒指", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

    T3Mage = {
        { 0,"Spell_Frost_IceStorm","=q6=#t3s3#", ""},
        { 22498, "INV_Crown_01", "=q4=霜火頭環", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22499, "INV_Shoulder_25", "=q4=霜火護肩", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2] },
        { 22496, "INV_Chest_Cloth_43", "=q4=霜火長袍", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22503, "INV_Bracer_13", "=q4=霜火護腕", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22501, "INV_Gauntlets_17", "=q4=霜火手套", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22502, "INV_Belt_03", "=q4=霜火腰帶", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22497, "INV_Pants_Cloth_05", "=q4=霜火護腿", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22500, "INV_Boots_Fabric_01", "=q4=霜火便鞋", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9]  },
        { 23062, "INV_Jewelry_Ring_51Naxxramas", "=q4=冰火戒指", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

    T3Paladin = {
        { 0,"Spell_Holy_SealOfMight","=q6=#t3s4#","" },
        { 22428, "INV_Helmet_15", "=q4=救贖頭盔", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22429, "INV_Shoulder_14", "=q4=救贖肩甲", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2] },
        { 22425, "INV_Chest_Chain_15", "=q4=救贖外套", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22424, "INV_Bracer_02", "=q4=救贖護腕", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22426, "INV_Gauntlets_25", "=q4=救贖護手", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22431, "INV_Belt_22", "=q4=救贖腰帶", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22427, "INV_Pants_Mail_15", "=q4=救贖護腿", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22430, "INV_Boots_Chain_05", "=q4=救贖長靴", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9] },
        { 23066, "INV_Jewelry_Ring_51Naxxramas", "=q4=救贖戒指", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

    T3Priest = {
        { 0,"Spell_Holy_PowerWordShield","=q6=#t3s5#","" },
        { 22514, "INV_Crown_01", "=q4=信仰頭環", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22515, "INV_Shoulder_25", "=q4=信仰護肩", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2] },
        { 22512, "INV_Chest_Cloth_43", "=q4=信仰長袍", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22519, "INV_Bracer_13", "=q4=信仰束腕", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22517, "INV_Gauntlets_17", "=q4=信仰手套", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22518, "INV_Belt_08", "=q4=信仰腰帶", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22513, "INV_Pants_Cloth_05", "=q4=信仰護腿", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22516, "INV_Boots_Fabric_01", "=q4=信仰便鞋", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9] },
        { 23061, "INV_Jewelry_Ring_51Naxxramas", "=q4=信仰戒指", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

    T3Rogue = {
        { 0,"Ability_BackStab","=q6=#t3s6#","" },
        { 22478, "INV_Helmet_58", "=q4=骨鐮頭盔", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22479, "INV_Shoulder_29", "=q4=骨鐮肩鎧", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2] },
        { 22476, "INV_Chest_Plate02", "=q4=骨鐮胸甲", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22483, "INV_Bracer_15", "=q4=骨鐮護腕", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22481, "INV_Gauntlets_28", "=q4=骨鐮護手", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22482, "INV_Belt_27", "=q4=骨鐮腰帶", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22477, "INV_Pants_Plate_05", "=q4=骨鐮腿甲", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22480, "INV_Boots_Plate_06", "=q4=骨鐮重靴", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9] },
        { 23060, "INV_Jewelry_Ring_51Naxxramas", "=q4=鐮骨之戒", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

    T3Shaman = {
        { 0,"Spell_FireResistanceTotem_01","=q6=#t3s7#","" },
        { 22466, "INV_Helmet_15", "=q4=粉碎大地頭盔", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22467, "INV_Shoulder_14", "=q4=粉碎大地肩甲", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2] },
        { 22464, "INV_Chest_Chain_15", "=q4=粉碎大地外套", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22471, "INV_Bracer_02", "=q4=粉碎大地護腕", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22469, "INV_Gauntlets_25", "=q4=粉碎大地護手", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22470, "INV_Belt_22", "=q4=粉碎大地束腰", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22465, "INV_Pants_Mail_15", "=q4=粉碎大地護腿", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22468, "INV_Boots_Chain_05", "=q4=粉碎大地長靴", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9] },
        { 23065, "INV_Jewelry_Ring_51Naxxramas", "=q4=粉碎大地戒指", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

    T3Warlock = {
        { 0,"Spell_Shadow_CurseOfTounges","=q6=#t3s8#","" },
        { 22506, "INV_Crown_01", "=q4=瘟疫之心頭環", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22507, "INV_Shoulder_25", "=q4=瘟疫之心護肩", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2]},
        { 22504, "INV_Chest_Cloth_43", "=q4=瘟疫之心長袍", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22511, "INV_Bracer_13", "=q4=瘟疫之心束腕", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22509, "INV_Gauntlets_17", "=q4=瘟疫之心手套", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22510, "INV_Belt_03", "=q4=瘟疫之心腰帶", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22505, "INV_Pants_Cloth_05", "=q4=瘟疫之心護腿", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22508, "INV_Boots_Fabric_01", "=q4=瘟疫之心便鞋", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9] },
        { 23063, "INV_Jewelry_Ring_51Naxxramas", "=q4=瘟疫之心戒指", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

    T3Warrior = {
        { 0, "INV_Shield_05", "=q6=#t3s9#", "" },
        { 22418, "INV_Helmet_58", "=q4=無畏頭盔", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22419, "INV_Shoulder_29", "=q4=無畏肩鎧", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2] },
        { 22416, "INV_Chest_Plate02", "=q4=無畏胸甲", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22423, "INV_Bracer_15", "=q4=無畏護腕", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22421, "INV_Gauntlets_28", "=q4=無畏護手", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22422, "INV_Belt_27", "=q4=無畏腰帶", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22417, "INV_Pants_Plate_05", "=q4=無畏腿鎧", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22420, "INV_Boots_Plate_06", "=q4=無畏馬靴", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9] },
        { 23059, "INV_Jewelry_Ring_51Naxxramas", "=q4=無畏戒指", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

-- Tier 2 Sets (T2)
        
    T2Druid = {
        { 0, "Spell_Nature_Regeneration", "=q6=#t2s1#", "" },        
        { 16900, "INV_Helmet_09", "=q4=怒風頭巾", "=ds="..AtlasLootBossNames["OnyxiasLair"][1], "13.08%" },
	{ 16902, "INV_Shoulder_07", "=q4=怒風肩甲", "=ds="..AtlasLootBossNames["BlackwingLair"][7], "14.63%" },
	{ 16897, "INV_Chest_Chain_16", "=q4=怒風胸甲", "=ds="..AtlasLootBossNames["BlackwingLair"][8], "11.89%" },
   	{ 16904, "INV_Bracer_03", "=q4=怒風護腕", "=ds="..AtlasLootBossNames["BlackwingLair"][1], "17.38%" },
        { 16899, "INV_Gauntlets_25", "=q4=怒風護手", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "5.34%" },
	{ 16903, "INV_Belt_06", "=q4=怒風腰帶", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "16.90%" },
        { 16901, "INV_Pants_06", "=q4=怒風腿甲", "=ds="..AtlasLootBossNames["MoltenCore"][10], "15.49%" },
	{ 16898, "INV_Boots_08", "=q4=怒風長靴", "=ds="..AtlasLootBossNames["BlackwingLair"][3], "13.79%" },
	};

    T2Hunter = {
	{ 0, "Ability_Hunter_RunningShot", "=q6=#t2s2#", "" },
        { 16939, "INV_Helmet_05", "=q4=馭龍者頭盔", "=ds="..AtlasLootBossNames["OnyxiasLair"][1], "13.91%" },
	{ 16937, "INV_Shoulder_10", "=q4=馭龍者肩甲", "=ds="..AtlasLootBossNames["BlackwingLair"][7],   "16.20%" },
	{ 16942, "INV_Chest_Chain_03", "=q4=馭龍者胸甲", "=ds="..AtlasLootBossNames["BlackwingLair"][8],   "13.30%" },
        { 16935, "INV_Bracer_17", "=q4=馭龍者護腕", "=ds="..AtlasLootBossNames["BlackwingLair"][1],       "19.13%" },
        { 16940, "INV_Gauntlets_10", "=q4=馭龍者護手", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "6.13%" },
	{ 16936, "INV_Belt_28", "=q4=馭龍者腰帶", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "20.17%" },
        { 16938, "INV_Pants_03", "=q4=馭龍者腿甲", "=ds="..AtlasLootBossNames["MoltenCore"][10], "16.02%" },
	{ 16941, "INV_Boots_Plate_07", "=q4=馭龍者脛甲", "=ds="..AtlasLootBossNames["BlackwingLair"][3],     "17.78%" },
	};

    T2Mage = {
        { 0, "Spell_Frost_IceStorm", "=q6=#t2s3#", "" },
        { 16914, "INV_Helmet_70", "=q4=靈風頭冠", "=ds="..AtlasLootBossNames["OnyxiasLair"][1] , "14.09%" },
        { 16917, "INV_Shoulder_32", "=q4=靈風襯肩", "=ds="..AtlasLootBossNames["BlackwingLair"][7], "18.09%" },
        { 16916, "INV_Chest_Cloth_03", "=q4=靈風長袍", "=ds="..AtlasLootBossNames["BlackwingLair"][8], "14.03%" },
        { 16918, "INV_Bracer_09", "=q4=靈風束腕", "=ds="..AtlasLootBossNames["BlackwingLair"][1], "20.41%" },
        { 16913, "INV_Gauntlets_14", "=q4=靈風手套", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "7.37%" },
        { 16818, "INV_Belt_22", "=q4=靈風腰帶", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "19.94%" },
        { 16915, "INV_Pants_08", "=q4=靈風短褲", "=ds="..AtlasLootBossNames["MoltenCore"][10], "17.37%" },
        { 16912, "INV_Boots_07", "=q4=靈風長靴", "=ds="..AtlasLootBossNames["BlackwingLair"][3], "17.17%" },
        };

    T2Paladin = {
	{ 0, "Spell_Holy_SealOfMight", "=q6=#t2s4#", "" },
        { 16955, "INV_Helmet_74", "=q4=審判頭冠", "=ds="..AtlasLootBossNames["OnyxiasLair"][1], "8.64%" },
	{ 16953, "INV_Shoulder_37", "=q4=審判肩鎧", "=ds="..AtlasLootBossNames["BlackwingLair"][7], "10.97%" },
	{ 16958, "INV_Chest_Plate03", "=q4=審判胸甲", "=ds="..AtlasLootBossNames["BlackwingLair"][8], "9.24%" },
	{ 16951, "INV_Bracer_18", "=q4=審判束腕", "=ds="..AtlasLootBossNames["BlackwingLair"][1], "13.61%" },
        { 16956, "INV_Gauntlets_29", "=q4=審判護手", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "3.58%" },
	{ 16952, "INV_Belt_27", "=q4=審判腰帶", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "12.23%" },
        { 16954, "INV_Pants_04", "=q4=審判腿鎧", "=ds="..AtlasLootBossNames["MoltenCore"][10], "10.81%" },
	{ 16957, "INV_Boots_Plate_09", "=q4=審判馬靴", "=ds="..AtlasLootBossNames["BlackwingLair"][3], "11.28%" },
        };

    T2Priest = {
        { 0, "Spell_Holy_PowerWordShield", "=q6=#t2s5#", "" },
        { 16921, "INV_Helmet_24", "=q4=卓越之環",  "=ds="..AtlasLootBossNames["OnyxiasLair"][1], "13.39%" },
        { 16924, "INV_Shoulder_02", "=q4=卓越肩鎧", "=ds="..AtlasLootBossNames["BlackwingLair"][7], "17.83%" },
        { 16923, "INV_Chest_Cloth_03", "=q4=卓越法袍", "=ds="..AtlasLootBossNames["BlackwingLair"][8], "14.83%" },
        { 16926, "INV_Bracer_09", "=q4=卓越束腕", "=ds="..AtlasLootBossNames["BlackwingLair"][1], "20.37%" },
        { 16920, "INV_Gauntlets_14", "=q4=卓越護手", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "6.01%" },
        { 16925, "INV_Belt_22", "=q4=卓越腰帶", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "18.76%" },
        { 16922, "INV_Pants_08", "=q4=卓越護腿", "=ds="..AtlasLootBossNames["MoltenCore"][10], "17.30%" },
        { 16919, "INV_Boots_07", "=q4=卓越長靴", "=ds="..AtlasLootBossNames["BlackwingLair"][3], "14.61%" },
        };

    T2Rogue = {
        { 0, "Ability_BackStab", "=q6=#t2s6#", "" },
        { 16908, "INV_Helmet_41", "=q4=血牙頭巾", "=ds="..AtlasLootBossNames["OnyxiasLair"][1], "13.21%" },
        { 16832, "INV_Shoulder_23", "=q4=血牙肩甲", "=ds="..AtlasLootBossNames["BlackwingLair"][7], "17.03%" },
        { 16905, "INV_Chest_Cloth_07", "=q4=血牙胸甲", "=ds="..AtlasLootBossNames["BlackwingLair"][8], "14.21%" },
        { 16911, "INV_Bracer_02", "=q4=血牙護腕", "=ds="..AtlasLootBossNames["BlackwingLair"][1], "20.69%" },
        { 16907, "INV_Gauntlets_21", "=q4=血牙手套", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "6.84%" },
        { 16910, "INV_Belt_23", "=q4=血牙腰帶", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "19.69%" },
        { 16909, "INV_Pants_06", "=q4=血牙短褲", "=ds="..AtlasLootBossNames["MoltenCore"][10], "17.18%" },
        { 16906, "INV_Boots_08", "=q4=血牙長靴", "=ds="..AtlasLootBossNames["BlackwingLair"][3], "15.66%" },
        };

    T2Shaman = {
        { 0, "Spell_FireResistanceTotem_01", "=q6=#t2s7#", "" },
        { 16947, "INV_Helmet_69", "=q4=無盡風暴頭盔", "=ds="..AtlasLootBossNames["OnyxiasLair"][1], "4.86%" },
        { 16945, "INV_Shoulder_33", "=q4=無盡風暴肩飾", "=ds="..AtlasLootBossNames["BlackwingLair"][7], "6.73%" },
        { 16950, "INV_Chest_Chain_11", "=q4=無盡風暴胸甲", "=ds="..AtlasLootBossNames["BlackwingLair"][8], "5.65%" },
        { 16943, "INV_Bracer_16", "=q4=無盡風暴護腕", "=ds="..AtlasLootBossNames["BlackwingLair"][1], "7.54%" },
        { 16948, "INV_Gauntlets_11", "=q4=無盡風暴護手", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "2.13%" },
        { 16944, "INV_Belt_14", "=q4=無盡風暴腰帶", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "6.93%" },
        { 16946, "INV_Pants_03", "=q4=無盡風暴護腿", "=ds="..AtlasLootBossNames["MoltenCore"][10], "5.97%" },
        { 16949, "INV_Boots_Plate_06", "=q4=無盡風暴脛甲", "=ds="..AtlasLootBossNames["BlackwingLair"][3], "5.57%" },
        };

    T2Warlock = {
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#t2s8#", "" },
        { 16929, "INV_Helmet_08", "=q4=復仇骨帽","=ds="..AtlasLootBossNames["OnyxiasLair"][1], "13.54%" },
        { 16932, "INV_Shoulder_19", "=q4=復仇肩鎧", "=ds="..AtlasLootBossNames["BlackwingLair"][7], "16.26%" },
        { 16931, "INV_Chest_Leather_01", "=q4=復仇法袍", "=ds="..AtlasLootBossNames["BlackwingLair"][8], "12.46%" },
        { 16934, "INV_Bracer_07", "=q4=復仇護腕", "=ds="..AtlasLootBossNames["BlackwingLair"][1], "18.11%" },
        { 16928, "INV_Gauntlets_19", "=q4=復仇手套", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "5.28%" },
        { 16933, "INV_Belt_13", "=q4=復仇腰帶", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "18.42%" },
        { 16930, "INV_Pants_07", "=q4=復仇護腿", "=ds="..AtlasLootBossNames["MoltenCore"][10], "16.87%" },
        { 16927, "INV_Boots_05", "=q4=復仇戰靴", "=ds="..AtlasLootBossNames["BlackwingLair"][3], "15.32%" },
        };

    T2Warrior = {
        { 0, "INV_Shield_05", "=q6=#t2s9#", "" },
        { 16963, "INV_Helmet_71", "=q4=憤怒頭盔", "=ds="..AtlasLootBossNames["OnyxiasLair"][1], "13.65%" },
        { 16961, "INV_Shoulder_34", "=q4=憤怒肩鎧", "=ds="..AtlasLootBossNames["BlackwingLair"][7], "16.83%" },
        { 16966, "INV_Chest_Plate16", "=q4=憤怒胸甲", "=ds="..AtlasLootBossNames["BlackwingLair"][8], "15.06%" },
        { 16959, "INV_Bracer_19", "=q4=憤怒護腕", "=ds="..AtlasLootBossNames["BlackwingLair"][1], "20.29%" },
        { 16964, "INV_Gauntlets_10", "=q4=憤怒護手", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "5.93%" },
        { 16960, "INV_Belt_09", "=q4=憤怒腰帶", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "20.03%" },
        { 16962, "INV_Pants_04", "=q4=憤怒腿鎧", "=ds="..AtlasLootBossNames["MoltenCore"][10], "17.23%" },
        { 16965, "INV_Boots_Plate_04", "=q4=憤怒馬靴", "=ds="..AtlasLootBossNames["BlackwingLair"][3], "16.84%" },
        };

-- Tier 1 Sets (T1)


    T1Druid = {
        { 0, "Spell_Nature_Regeneration", "=q6=#t1s1#", "" },
	{ 16834, "INV_Helmet_09", "=q4=塞納里奧頭盔", "=ds="..AtlasLootBossNames["MoltenCore"][4], "11.51%" },
	{ 16836, "INV_Shoulder_07", "=q4=塞納里奧肩甲", "=ds="..AtlasLootBossNames["MoltenCore"][6], "19.52%" },
        { 16833, "INV_Chest_Cloth_06", "=q4=塞納里奧胸甲", "=ds="..AtlasLootBossNames["MoltenCore"][7], "15.21%" },
        { 16830, "INV_Bracer_03", "=q4=塞納里奧護腕", "=ds="..AtlasLootBossNames["Common"][1], "0.17%" },
        { 16831, "INV_Gauntlets_07", "=q4=塞納里奧手套", "=ds="..AtlasLootBossNames["MoltenCore"][5], "19.53%" },
	{ 16828, "INV_Belt_06", "=q4=塞納里奧腰帶", "=ds="..AtlasLootBossNames["Common"][1], "0.16%" },
        { 16835, "INV_Pants_06", "=q4=塞納里奧護腿", "=ds="..AtlasLootBossNames["MoltenCore"][2], "12.90%" },
        { 16829, "INV_Boots_08", "=q4=塞納里奧長靴", "=ds="..AtlasLootBossNames["MoltenCore"][1], "10.72%" },
	};
        
    T1Hunter = {
	{ 0, "Ability_Hunter_RunningShot", "=q6=#t1s2#", "" },
	{ 16846, "INV_Helmet_05", "=q4=巨獸之王頭盔", "=ds="..AtlasLootBossNames["MoltenCore"][4], "11.57%" },
	{ 16848, "INV_Shoulder_10", "=q4=巨獸之王肩飾", "=ds="..AtlasLootBossNames["MoltenCore"][8], "19.64%" },
        { 16845, "INV_Chest_Chain_03", "=q4=巨獸之王胸甲", "=ds="..AtlasLootBossNames["MoltenCore"][7], "15.83%" },
	{ 16850, "INV_Bracer_17", "=q4=巨獸之王護腕", "=ds="..AtlasLootBossNames["Common"][1], "0.18%" },
        { 16852, "INV_Gauntlets_10", "=q4=巨獸之王手套", "=ds="..AtlasLootBossNames["MoltenCore"][5], "18.58%" },
        { 16851, "INV_Belt_28", "=q4=巨獸之王腰帶", "=ds="..AtlasLootBossNames["Common"][1], "0.17%" },
        { 16847, "INV_Pants_Mail_03", "=q4=巨獸之王護腿", "=ds="..AtlasLootBossNames["MoltenCore"][2], "13.28%" },
	{ 16849, "INV_Boots_Chain_13", "=q4=巨獸之王長靴", "=ds="..AtlasLootBossNames["MoltenCore"][3], "14.54%" },
	};

    T1Mage = {
        { 0, "Spell_Frost_IceStorm", "=q6=#t1s3#", "" },
        { 16795, "INV_Helmet_53", "=q4=祕法師頭冠", "=ds="..AtlasLootBossNames["MoltenCore"][4], "11.31%" },
        { 16797, "INV_Shoulder_02", "=q4=祕法師襯肩", "=ds="..AtlasLootBossNames["MoltenCore"][6], "19.92%" },
        { 16798, "INV_Chest_Cloth_03", "=q4=祕法師長袍", "=ds="..AtlasLootBossNames["MoltenCore"][7], "16.51%" },
        { 16799, "INV_Belt_29", "=q4=祕法師護腕", "=ds="..AtlasLootBossNames["Common"][1], "0.16%" },
        { 16801, "INV_Gauntlets_14", "=q4=祕法師手套", "=ds="..AtlasLootBossNames["MoltenCore"][5], "19.59%" },
        { 16802, "INV_Belt_30", "=q4=祕法師腰帶", "=ds="..AtlasLootBossNames["Common"][1], "0.16%"  },
        { 16796, "INV_Pants_08", "=q4=祕法師護腿", "=ds="..AtlasLootBossNames["MoltenCore"][2], "14.57%" },
        { 16800, "INV_Boots_07", "=q4=祕法師便鞋",  "=ds="..AtlasLootBossNames["MoltenCore"][1], "12.06%" },
        };

    T1Paladin = {
	{ 0, "Spell_Holy_SealOfMight", "=q6=#t1s4#", "" },
	{ 16854, "INV_Helmet_05", "=q4=秩序之源頭盔", "=ds="..AtlasLootBossNames["MoltenCore"][4], "7.23%" },
	{ 16856, "INV_Shoulder_20", "=q4=秩序之源肩鎧", "=ds="..AtlasLootBossNames["MoltenCore"][6], "12.62%" },
	{ 16853, "INV_Chest_Plate03", "=q4=秩序之源胸甲", "=ds="..AtlasLootBossNames["MoltenCore"][7], "9.53%" },
	{ 16857, "INV_Bracer_18", "=q4=秩序之源護腕", "=ds="..AtlasLootBossNames["Common"][1], "0.11%" },
        { 16860, "INV_Gauntlets_29", "=q4=秩序之源護手", "=ds="..AtlasLootBossNames["MoltenCore"][3], "11.77%" },
        { 16858, "INV_Belt_27", "=q4=秩序之源腰帶", "=ds="..AtlasLootBossNames["Common"][1], "0.10%" },
        { 16855, "INV_Pants_04", "=q4=秩序之源腿鎧", "=ds="..AtlasLootBossNames["MoltenCore"][2], "8.54%" },
        { 16859, "INV_Boots_Plate_09", "=q4=秩序之源戰靴", "=ds="..AtlasLootBossNames["MoltenCore"][1], "7.20%" },
	};

    T1Priest = {
        { 0, "Spell_Holy_PowerWordShield", "=q6=#t1s5#", "" },
        { 16813, "INV_Helmet_34", "=q4=預言頭飾", "=ds="..AtlasLootBossNames["MoltenCore"][4], "11.36%" },
        { 16816, "INV_Shoulder_02", "=q4=預言襯肩", "=ds="..AtlasLootBossNames["MoltenCore"][8], "21.06%" },
        { 16815, "INV_Chest_Cloth_03", "=q4=預言法袍", "=ds="..AtlasLootBossNames["MoltenCore"][7], "15.65%" },
        { 16819, "INV_Bracer_09", "=q4=預言臂甲",   "=ds="..AtlasLootBossNames["Common"][1], "0.16%" },
        { 16812, "INV_Gauntlets_14", "=q4=預言手套", "=ds="..AtlasLootBossNames["MoltenCore"][3], "18.65%" },
        { 16817, "INV_Belt_22", "=q4=預言腰帶", "=ds="..AtlasLootBossNames["Common"][1], "0.18%" },
        { 16814, "INV_Pants_08", "=q4=預言短褲", "=ds="..AtlasLootBossNames["MoltenCore"][2], "14.33%" },
        { 16811, "INV_Gauntlets_07", "=q4=預言之靴", "=ds="..AtlasLootBossNames["MoltenCore"][5], "14.90%" },
        };

    T1Rogue = {
        { 0, "Ability_BackStab", "=q6=#t1s6#", "" },
        { 16821, "INV_Helmet_41", "=q4=夜幕殺手頭巾", "=ds="..AtlasLootBossNames["MoltenCore"][4], "10.38%" },
        { 16823, "INV_Shoulder_25", "=q4=夜幕殺手護肩", "=ds="..AtlasLootBossNames["MoltenCore"][8], "20.66%" },
        { 16820, "INV_Chest_Cloth_07", "=q4=夜幕殺手胸甲", "=ds="..AtlasLootBossNames["MoltenCore"][7], "16.76%" },
        { 16825, "INV_Bracer_02", "=q4=夜幕殺手護腕", "=ds="..AtlasLootBossNames["Common"][1], "0.17%" },
        { 16826, "INV_Gauntlets_21", "=q4=夜幕殺手手套", "=ds="..AtlasLootBossNames["MoltenCore"][3], "19.47%" },
        { 16827, "INV_Belt_23", "=q4=夜幕殺手腰帶", "=ds="..AtlasLootBossNames["Common"][1], "0.15%" },
        { 16822, "INV_Pants_06", "=q4=夜幕殺手短褲", "=ds="..AtlasLootBossNames["MoltenCore"][2], "13.83%" },
        { 16824, "INV_Gauntlets_08", "=q4=夜幕殺手長靴", "=ds="..AtlasLootBossNames["MoltenCore"][5], "15.58%" },
        };

    T1Shaman = {
        { 0, "Spell_FireResistanceTotem_01", "=q6=#t1s7#", "" },
        { 16842, "INV_Helmet_09", "=q4=大地之怒頭盔", "=ds="..AtlasLootBossNames["MoltenCore"][4], "3.91%" },
        { 16844, "INV_Shoulder_29", "=q4=大地之怒肩飾", "=ds="..AtlasLootBossNames["MoltenCore"][6], "7.29%" },
        { 16841, "INV_Chest_Chain_11", "=q4=大地之怒胸甲", "=ds="..AtlasLootBossNames["MoltenCore"][7], "6.08%" },
        { 16840, "INV_Bracer_16", "=q4=大地之怒護腕", "=ds="..AtlasLootBossNames["Common"][1], "0.06%" },
        { 16839, "INV_Gauntlets_11", "=q4=大地之怒護手", "=ds="..AtlasLootBossNames["MoltenCore"][3], "7.38%" },
        { 16838, "INV_Belt_14", "=q4=大地之怒腰帶", "=ds="..AtlasLootBossNames["Common"][1], "0.07%" },
        { 16843, "INV_Pants_03", "=q4=大地之怒腿甲", "=ds="..AtlasLootBossNames["MoltenCore"][2], "4.73%" },
        { 16837, "INV_Boots_Plate_06", "=q4=大地之怒長靴", "=ds="..AtlasLootBossNames["MoltenCore"][1], "4.16%" },
        };

    T1Warlock = {
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#t1s8#", "" },
        { 16808, "INV_Helmet_08", "=q4=惡魔之心軟帽", "=ds="..AtlasLootBossNames["MoltenCore"][4], "10.62%" },
        { 16807, "INV_Shoulder_23", "=q4=惡魔之心護肩", "=ds="..AtlasLootBossNames["MoltenCore"][6], "19.78%" },
        { 16809, "INV_Chest_Cloth_09", "=q4=惡魔之心長袍", "=ds="..AtlasLootBossNames["MoltenCore"][7], "15.66%" },
        { 16804, "INV_Bracer_07", "=q4=惡魔之心護腕", "=ds="..AtlasLootBossNames["Common"][1], "0.16%" },
        { 16805, "INV_Gauntlets_19", "=q4=惡魔之心手套", "=ds="..AtlasLootBossNames["MoltenCore"][1],  "14.89%" },
        { 16806, "INV_Belt_13", "=q4=惡魔之心腰帶", "=ds="..AtlasLootBossNames["Common"][1], "0.19%" },
        { 16810, "INV_Pants_Cloth_14", "=q4=惡魔之心短褲", "=ds="..AtlasLootBossNames["MoltenCore"][2], "13.75%" },
        { 16803, "INV_Boots_Cloth_05", "=q4=惡魔之心便鞋", "=ds="..AtlasLootBossNames["MoltenCore"][5], "15.28%" },
        };

    T1Warrior = {
        { 0, "INV_Shield_05", "=q6=#t1s9#", "" },
        { 16866, "INV_Helmet_09", "=q4=力量頭盔", "=ds="..AtlasLootBossNames["MoltenCore"][4], "11.39%" },
        { 16868, "INV_Shoulder_15", "=q4=力量肩鎧", "=ds="..AtlasLootBossNames["MoltenCore"][8], "21.14%" },
        { 16865, "INV_Chest_Plate16", "=q4=力量胸甲", "=ds="..AtlasLootBossNames["MoltenCore"][7], "15.28%" },
        { 16861, "INV_Bracer_19", "=q4=力量護腕", "=ds="..AtlasLootBossNames["Common"][1], "0.16%" },
        { 16863, "INV_Gauntlets_10", "=q4=力量護手", "=ds="..AtlasLootBossNames["MoltenCore"][1],  "16.40%" },
        { 16864, "INV_Belt_09", "=q4=力量腰帶", "=ds="..AtlasLootBossNames["Common"][1], "0.16%" },
        { 16867, "INV_Pants_04", "=q4=力量腿鎧", "=ds="..AtlasLootBossNames["MoltenCore"][2], "13.97%" },
        { 16862, "INV_Boots_Plate_04", "=q4=力量馬靴", "=ds="..AtlasLootBossNames["MoltenCore"][3], "14.48%" },
        };

-- Dungeon 1 and 2 Sets (D1/D2)

    T0Druid = {
	{ 0, "Spell_Nature_Regeneration", "=q6=#t0s1#", "=ec1=#j6#" },
        { 16720, "INV_Helmet_27", "=q3=野性之心兜帽", "=ds="..AtlasLootBossNames["Scholomance"][16], "7.09%" },
        { 16718, "INV_Shoulder_01", "=q3=野性之心肩甲",  "=ds="..AtlasLootBossNames["BlackrockSpireLower"][10], "11.04%" },
        { 16706,"INV_Chest_Plate06","=q3=野性之心外衣", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10], "7.36%" },
        { 16714, "INV_Bracer_09", "=q3=野性之心護腕", "=ds="..AtlasLootBossNames["Stratholme"][19], "1.85%" },
	{ 16717, "INV_Gauntlets_17", "=q3=野性之心手套", "=ds="..AtlasLootBossNames["Stratholme"][5], "12.61%" },
        { 16716, "INV_Belt_15", "=q3=野性之心腰帶", "=ds="..AtlasLootBossNames["Scholomance"][17], "2.60%" },
	{ 16719, "INV_Pants_08", "=q3=野性之心褶裙", "=ds="..AtlasLootBossNames["Stratholme"][18], "6.58%" },
        { 16715, "INV_Boots_08", "=q3=野性之心長靴", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][6], "13.03%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Nature_Regeneration", "=q6=#t05s1#", "=ec1=#j7#" },
        { 22109, "INV_Helmet_27", "=q4=野獸之心兜帽", "=ds=#a2#, #s1#" },
	{ 22112, "INV_Shoulder_01", "=q3=野獸之心護肩",  "=ds=#a2#, #s3#" },
	{ 22113,"INV_Chest_Plate06","=q4=野獸之心外套", "=ds=#a2#, #s5#" },
        { 22108, "INV_Bracer_09", "=q3=野獸之心護腕", "=ds=#a2#, #s8#" },
	{ 22110, "INV_Gauntlets_17", "=q4=野獸之心手套", "=ds=#a2#, #s9#" },
        { 22106, "INV_Belt_15", "=q3=野獸之心腰帶", "=ds=#a2#, #s10#" },
	{ 22111, "INV_Pants_08", "=q3=野獸之心褶裙", "=ds=#a2#, #s11#" },
        { 22107, "INV_Boots_08", "=q4=野獸之心長靴", "=ds=#a2#, #s12#" },
	};

    T0Hunter = {
	{ 0, "Ability_Hunter_RunningShot", "=q6=#t0s2#", "=ec1=#j6#" },
        { 16677, "INV_Helmet_24", "=q3=馭獸者之帽", "=ds="..AtlasLootBossNames["Scholomance"][16], "7.00%" },
	{ 16679, "INV_Shoulder_10", "=q3=馭獸者襯肩", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][12], "9.89%" },
	{ 16674, "INV_Chest_Chain_03","=q3=馭獸者外套", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10],   "6.81%" },
	{ 16681, "INV_Bracer_17", "=q3=馭獸者護腕", "=ds="..AtlasLootBossNames["Stratholme"][19], "1.64%" },
        { 16676, "INV_Gauntlets_10", "=q3=馭獸者手套", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][4], "9.15%" },
        { 16680, "INV_Belt_28", "=q3=馭獸者腰帶", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "1.36%" },
        { 16678, "INV_Pants_03", "=q3=馭獸者短褲", "=ds="..AtlasLootBossNames["Stratholme"][18], "6.16%" },
        { 16675, "INV_Boots_Plate_07", "=q3=馭獸者長靴", "=ds="..AtlasLootBossNames["Stratholme"][14], "13.62%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Ability_Hunter_RunningShot", "=q6=#t05s2#", "=ec1=#j7#" },
        { 22013, "INV_Helmet_24", "=q4=獸王帽子", "=ds=#a3#, #s1#" },
	{ 22016, "INV_Shoulder_10", "=q3=獸王襯肩", "=ds=#a3#, #s3#" },
	{ 22060, "INV_Chest_Chain_03","=q4=獸王外套", "=ds=#a3#, #s5#" },
	{ 22011, "INV_Bracer_17", "=q3=獸王護腕", "=ds=#a3#, #s8#" },
        { 22015, "INV_Gauntlets_10", "=q4=獸王手套", "=ds=#a3#, #s9#" },
        { 22010, "INV_Belt_28", "=q3=獸王腰帶", "=ds=#a3#, #s10#" },
        { 22017, "INV_Pants_03", "=q3=獸王褲裝", "=ds=#a3#, #s11#" },
        { 22061, "INV_Boots_Plate_07", "=q4=獸王長靴", "=ds=#a3#, #s12#" },
	};
        
    T0Mage = {
        { 0, "Spell_Frost_IceStorm", "=q6=#t0s3#", "=ec1=#j6#" },
        { 16686, "INV_Crown_02", "=q3=博學者頭冠", "=ds="..AtlasLootBossNames["Scholomance"][16], "8.60%" },
        { 16689, "INV_Shoulder_23", "=q3=博學者襯肩", "=ds="..AtlasLootBossNames["Scholomance"][8], "11.93%" },
        { 16688,"INV_Chest_Cloth_25","=q3=博學者長袍", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10], "7.24%" },
        { 16683, "INV_Jewelry_Ring_23", "=q3=博學者腕輪", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "1.19%" },
        { 16684, "INV_Gauntlets_17", "=q3=博學者手套", "=ds="..AtlasLootBossNames["Scholomance"][11], "9.75%" },
        { 16685, "INV_Belt_08", "=q3=博學者腰帶", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "1.32%" },
        { 16687, "INV_Pants_06", "=q3=博學者護腿", "=ds="..AtlasLootBossNames["Stratholme"][18], "6.79%" },
        { 16682, "INV_Boots_02", "=q3=博學者長靴", "=ds="..AtlasLootBossNames["Stratholme"][4], "10.86%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Frost_IceStorm", "=q6=#t05s3#", "=ec1=#j7#" },
        { 22065, "INV_Crown_02", "=q4=巫師王冠", "=ds=#a1#, #s1#" },
        { 22068, "INV_Shoulder_23", "=q3=巫師襯肩", "=ds=#a1#, #s3#" },
        { 22069, "INV_Chest_Cloth_25","=q4=巫師長袍", "=ds=#a1#, #s5#" },
        { 22063, "INV_Jewelry_Ring_23", "=q3=巫師腕輪", "=ds=#a1#, #s8#" },
        { 22066, "INV_Gauntlets_17", "=q4=巫師手套", "=ds=#a1#, #s9#" },
        { 22062, "INV_Belt_08", "=q3=巫師腰帶", "=ds=#a1#, #s10#" },
        { 22067, "INV_Pants_06", "=q3=巫師護腿", "=ds=#a1#, #s11#" },
        { 22064, "INV_Boots_02", "=q4=巫師長靴", "=ds=#a1#, #s12#" },
        };

    T0Paladin = {
	{ 0, "Spell_Holy_SealOfMight", "=q6=#t0s4#", "=ec1=#j6#" },
        { 16727, "INV_Helmet_08", "=q3=光鑄頭盔", "=ds="..AtlasLootBossNames["Scholomance"][16], "5.32%" },
	{ 16729,"INV_Shoulder_10","=q3=光鑄肩鎧", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][8], "13.62%" },
        { 16726,"INV_Chest_Plate03","=q3=光鑄胸甲", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10], "3.76%" },
        { 16722, "INV_Bracer_14", "=q3=光鑄護腕", "=ds="..AtlasLootBossNames["Scholomance"][17], "3.37%" },
        { 16724, "INV_Gauntlets_19", "=q3=光鑄護手", "=ds="..AtlasLootBossNames["Stratholme"][6], "10.42%" },
        { 16723, "INV_Belt_11", "=q3=光鑄腰帶", "=ds="..AtlasLootBossNames["Stratholme"][19], "1.93%" },
        { 16728, "INV_Pants_04", "=q3=光鑄腿鎧", "=ds="..AtlasLootBossNames["Stratholme"][18], "4.20%" },
	{ 16725, "INV_Boots_Plate_03", "=q3=光鑄戰靴", "=ds="..AtlasLootBossNames["Stratholme"][9], "11.11%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Holy_SealOfMight", "=q6=#t05s4#", "=ec1=#j7#" },
        { 22091, "INV_Helmet_08", "=q4=靈鑄頭盔", "=ds=#a4#, #s1#" },
	{ 22093, "INV_Shoulder_10","=q3=靈鑄護肩", "=ds=#a4#, #s3#" },
        { 22089, "INV_Chest_Plate03","=q4=靈鑄胸甲", "=ds=#a4#, #s5#" },
	{ 22088, "INV_Bracer_14", "=q3=靈鑄護腕", "=ds=#a4#, #s8#" },
        { 22090, "INV_Gauntlets_19", "=q4=靈鑄護手", "=ds=#a4#, #s9#" },
        { 22086, "INV_Belt_11", "=q3=靈鑄腰帶", "=ds=#a4#, #s10#" },
        { 22092, "INV_Pants_04", "=q3=靈鑄腿甲", "=ds=#a4#, #s11#" },
	{ 22087, "INV_Boots_Plate_03", "=q4=靈鑄長靴", "=ds=#a4#, #s12#" },
	};

    T0Priest = {
        { 0, "Spell_Holy_PowerWordShield", "=q6=#t0s5#", "=ec1=#j6#" },
        { 16693, "INV_Crown_01", "=q3=虔誠頭冠", "=ds="..AtlasLootBossNames["Scholomance"][16], "7.89%" },
        { 16695, "INV_Shoulder_02", "=q3=虔誠襯肩", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][2], "12.84%" },
        { 16690,"INV_Chest_Cloth_11","=q3=虔誠長袍", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10], "6.20%" },
        { 16697, "INV_Belt_31", "=q3=虔誠護腕", "=ds="..AtlasLootBossNames["Stratholme"][19], "1.13%" },
        { 16692, "INV_Gauntlets_14", "=q3=虔誠手套", "=ds="..AtlasLootBossNames["Stratholme"][8], "12.46%" },
        { 16696, "INV_Belt_10", "=q3=虔誠腰帶", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "2.07%" },
        { 16694, "INV_Pants_08", "=q3=虔誠長裙", "=ds="..AtlasLootBossNames["Stratholme"][18], "7.42%" },
        { 16691, "INV_Boots_05", "=q3=虔誠軟鞋", "=ds="..AtlasLootBossNames["Stratholme"][15], "13.64%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Holy_PowerWordShield", "=q6=#t05s5#", "=ec1=#j7#" },
        { 22080, "INV_Crown_01", "=q4=正義王冠", "=ds=#a1#, #s1#" },
        { 22082, "INV_Shoulder_02", "=q3=正義襯肩", "=ds=#a1#, #s3#" },
        { 22083,"INV_Chest_Cloth_11","=q4=正義長袍", "=ds=#a1#, #s5#" },
        { 22079, "INV_Belt_31", "=q3=正義護腕", "=ds=#a1#, #s8#" },
        { 22081, "INV_Gauntlets_14", "=q4=正義手套", "=ds=#a1#, #s9#" },
        { 22078, "INV_Belt_10", "=q3=正義腰帶", "=ds=#a1#, #s10#" },
        { 22085, "INV_Pants_08", "=q3=正義褶裙", "=ds=#a1#, #s11#" },
        { 22084, "INV_Boots_05", "=q4=正義便鞋", "=ds=#a1#, #s12#" },
        };

    T0Rogue = {
        { 0, "Ability_BackStab", "=q6=#t0s6#", "=ec1=#j6#" },
        { 16707, "INV_Helmet_41", "=q3=迅影罩帽", "=ds="..AtlasLootBossNames["Scholomance"][16], "6.65%" },
        { 16708, "INV_Shoulder_07", "=q3=迅影肩甲", "=ds="..AtlasLootBossNames["Stratholme"][7], "10.68%" },
        { 16721,"INV_Chest_Leather_07","=q3=迅影外套",  "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10], "6.09%" },
        { 16710, "INV_Bracer_07", "=q3=迅影護腕", "=ds="..AtlasLootBossNames["Scholomance"][17], "3.51%" },
        { 16712, "INV_Gauntlets_24", "=q3=迅影手套", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][3], "11.89%" },
        { 16713, "INV_Belt_03", "=q3=迅影腰帶", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "1.05%" },
        { 16709, "INV_Pants_02", "=q3=迅影短褲", "=ds="..AtlasLootBossNames["Stratholme"][18], "7.76%" },
        { 16711, "INV_Boots_08", "=q3=迅影長靴", "=ds="..AtlasLootBossNames["Scholomance"][4], "14.32%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Ability_BackStab", "=q6=#t05s6#", "=ec1=#j7#" },
        { 22005, "INV_Helmet_41", "=q4=闇影軍帽", "=ds=#a2#, #s1#" },
        { 22008, "INV_Shoulder_07", "=q3=闇影護肩", "=ds=#a2#, #s3#" },
        { 22009,"INV_Chest_Leather_07","=q4=闇影外套",  "=ds=#a2#, #s5#" },
        { 22004, "INV_Bracer_07", "=q3=闇影護腕", "=ds=#a2#, #s8#" },
        { 22006, "INV_Gauntlets_24", "=q4=闇影手套", "=ds=#a2#, #s9#" },
        { 22002, "INV_Belt_03", "=q3=闇影腰帶", "=ds=#a2#, #s10#" },
        { 22007, "INV_Pants_02", "=q3=闇影短褲", "=ds=#a2#, #s11#" },
        { 22003, "INV_Boots_08", "=q4=闇影長靴", "=ds=#a2#, #s12#" },
        };

    T0Shaman = {
        { 0, "Spell_FireResistanceTotem_01", "=q6=#t0s7#", "=ec1=#j6#" },
        { 16667, "INV_Helmet_04", "=q3=元素罩帽", "=ds="..AtlasLootBossNames["Scholomance"][16], "2.86%" },
        { 16669,"INV_Shoulder_29","=q3=元素護肩","=ds="..AtlasLootBossNames["BlackrockSpireUpper"][7], "14.77%" },
        { 16666,"INV_Chest_Chain_11","=q3=元素外衣", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10], "3.03%" },
        { 16671, "INV_Bracer_02", "=q3=元素腕輪", "=ds="..AtlasLootBossNames["Stratholme"][19], "1.59%" },
        { 16672,"INV_Gauntlets_11","=q3=元素護手", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][1], "14.23%" },
        { 16673, "INV_Belt_16", "=q3=元素束腰", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "1.06%" },
        { 16668, "INV_Pants_03", "=q3=元素護腿", "=ds="..AtlasLootBossNames["Stratholme"][18], "3.02%" },
        { 16670, "INV_Boots_Wolf", "=q3=元素長靴", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][1], "9.35%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_FireResistanceTotem_01", "=q6=#t05s7#", "=ec1=#j7#" },
        { 22097, "INV_Helmet_04", "=q4=五雷罩帽", "=ds=#a3#, #s1#" },
        { 22101,"INV_Shoulder_29","=q3=五雷肩甲","=ds=#a3#, #s3#" },
        { 22102,"INV_Chest_Chain_11","=q4=五雷外套", "=ds=#a3#, #s5#" },
        { 22095, "INV_Bracer_02", "=q3=五雷護腕", "=ds=#a3#, #s8#" },
        { 22099,"INV_Gauntlets_11","=q4=五雷護手", "=ds=#a3#, #s9#" },
        { 22098, "INV_Belt_16", "=q3=五雷腰帶", "=ds=#a3#, #s10#" },
        { 22100, "INV_Pants_03", "=q3=五雷褶裙", "=ds=#a3#, #s11#" },
        { 22096, "INV_Boots_Wolf", "=q4=五雷長靴", "=ds=#a3#, #s12#" },
        };

    T0Warlock = {
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#t0s8#", "=ec1=#j6#" },
        { 16698, "INV_Helmet_29", "=q3=鬼霧面具", "=ds="..AtlasLootBossNames["Scholomance"][16], "8.78%" },
        { 16701, "INV_Misc_Bone_TaurenSkull_01", "=q3=鬼霧襯肩", "=ds="..AtlasLootBossNames["Scholomance"][3], "12.20%" },
        { 16700, "INV_Chest_Cloth_49","=q3=鬼霧長袍", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10], "8.04%" },
        { 16703, "INV_Bracer_13", "=q3=鬼霧護腕", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "1.68%" },
        { 16705, "INV_Gauntlets_32", "=q3=鬼霧手套", "=ds="..AtlasLootBossNames["Scholomance"][12], "14.54%" },
        { 16702, "INV_Belt_12", "=q3=鬼霧腰帶", "=ds="..AtlasLootBossNames["Stratholme"][19], "1.03%" },
        { 16699, "INV_Pants_08", "=q3=鬼霧護腿", "=ds="..AtlasLootBossNames["Stratholme"][18], "7.31%" },
        { 16704, "INV_Boots_05", "=q3=鬼霧便鞋", "=ds="..AtlasLootBossNames["Stratholme"][13], "13.16%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#t05s8#", "=ec1=#j7#" },
        { 22074, "INV_Helmet_29", "=q4=亡霧面具", "=ds=#a1#, #s1#" },
        { 22073, "INV_Misc_Bone_TaurenSkull_01", "=q3=亡霧襯肩", "=ds=#a1#, #s5#" },
        { 22075, "INV_Chest_Cloth_49","=q4=亡霧長袍", "=ds=#a1#, #s3#" },
        { 22071, "INV_Bracer_13", "=q3=亡霧護腕", "=ds=#a1#, #s8#" },
        { 22077, "INV_Gauntlets_32", "=q4=亡霧手套", "=ds=#a1#, #s9#" },
        { 22070, "INV_Belt_12", "=q3=亡霧腰帶", "=ds=#a1#, #s10#" },
        { 22072, "INV_Pants_08", "=q3=亡霧護腿", "=ds=#a1#, #s11#" },
        { 22076, "INV_Boots_05", "=q4=亡霧便鞋", "=ds=#a1#, #s12#" },
        };

    T0Warrior = {
        { 0, "INV_Shield_05", "=q6=#t0s9#", "=ec1=#j6#" },
        { 16731, "INV_Helmet_02", "=q3=勇氣頭盔", "=ds="..AtlasLootBossNames["Scholomance"][16], "6.54%" },
        { 16733,"INV_Shoulder_30","=q3=勇氣肩甲","=ds="..AtlasLootBossNames["BlackrockSpireUpper"][6], "13.39%" },
        { 16730,"INV_Chest_Plate03","=q3=勇氣胸甲", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10], "5.83%" },
        { 16735, "INV_Bracer_18", "=q3=勇氣護腕", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "1.49%" },
        { 16737, "INV_Gauntlets_26", "=q3=勇氣護手", "=ds="..AtlasLootBossNames["Stratholme"][17], "9.58%" },
        { 16736, "INV_Belt_34", "=q3=勇氣腰帶", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "1.96%" },
        { 16732, "INV_Pants_04", "=q3=勇氣腿鎧", "=ds="..AtlasLootBossNames["Stratholme"][18], "5.74%" },
        { 16734, "INV_Boots_Plate_03", "=q3=勇氣戰靴", "=ds="..AtlasLootBossNames["Scholomance"][2], "11.12%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Shield_05", "=q6=#t05s9#", "=ec1=#j7#" },
        { 21999, "INV_Helmet_02", "=q4=英雄頭盔", "=ds=#a4#, #s1#" },
        { 22001,"INV_Shoulder_30","=q3=英雄護肩","=ds=#a4#, #s3#" },
        { 21997,"INV_Chest_Plate03","=q4=英雄胸甲", "=ds=#a4#, #s5#" },
        { 21996, "INV_Bracer_18", "=q3=英雄護腕", "=ds=#a4#, #s8#" },
        { 21998, "INV_Gauntlets_26", "=q4=英雄護手", "=ds=#a4#, #s9#" },
        { 21994, "INV_Belt_34", "=q3=英雄腰帶", "=ds=#a4#, #s10#" },
        { 22000, "INV_Pants_04", "=q3=英雄腿鎧", "=ds=#a4#, #s11#" },
        { 21995, "INV_Boots_Plate_03", "=q4=英雄戰靴", "=ds=#a4#, #s12#" },
        };

-- Dungeon 3 Sets (D3)

    DS3Hallowed = {
        { 28413, "INV_Jewelry_Ring_62", "=q3=神聖王冠", "=ds="..AtlasLootBossNames["TKTheArcatraz"][4] },
        { 27775, "INV_Shoulder_22", "=q3=神聖護肩", "=ds="..AtlasLootBossNames["AuchShadowLabyrinth"][3] },
        { 28230, "INV_Chest_Cloth_39", "=q3=神聖服飾", "=ds="..AtlasLootBossNames["AuchShadowLabyrinth"][4] },
        { 27536, "INV_Gauntlets_27", "=q3=神聖裹手", "=ds="..AtlasLootBossNames["HCShatteredHalls"][3] },
        { 27875, "INV_Pants_Cloth_18", "=q3=神聖長褲", "=ds="..AtlasLootBossNames["AuchSethekkHalls"][2] },
        };

    DS3Incanter = {
        { 28278, "INV_Helmet_34", "=q3=魔法使的兜帽", "=ds="..AtlasLootBossNames["TKMechanar"][5] },
        { 27738, "INV_Shoulder_02", "=q3=魔法使的護肩", "=ds="..AtlasLootBossNames["CFRTheSteamvault"][3] },
        { 28229, "INV_Chest_Cloth_25", "=q3=魔法使的長袍", "=ds="..AtlasLootBossNames["TKTheBotanica"][5] },
        { 27508, "INV_Gauntlets_17", "=q3=魔法使的手套", "=ds="..AtlasLootBossNames["CFRTheSteamvault"][1] },
        { 27838, "INV_Pants_Cloth_20", "=q3=魔法使的長褲", "=ds="..AtlasLootBossNames["AuchSethekkHalls"][2] },
        };
    
    DS3Mana = {
        { 28193, "INV_Jewelry_Ring_56", "=q3=法力蝕刻頭冠", "=ds="..AtlasLootBossNames["CoTTheBlackMorass"][3] },
        { 27796, "INV_Shoulder_22", "=q3=法力蝕刻肩甲", "=ds="..AtlasLootBossNames["CFRTheSlavePens"][3].." (#j3#)" },
        { 28191, "INV_Chest_Cloth_42", "=q3=法力蝕刻祭袍", "=ds="..AtlasLootBossNames["CoTOldHillsbradFoothills"][3].." (#j3#)" },
        { 27465, "INV_Gauntlets_15", "=q3=法力蝕刻手套", "=ds="..AtlasLootBossNames["HCRamparts"][2].." (#j3#)" },
        { 27907, "INV_Pants_Cloth_17", "=q3=法力蝕刻馬褲", "=ds="..AtlasLootBossNames["CFRTheUnderbog"][4].." (#j3#)" },
        };
        
    DS3Oblivion = {
        { 28415, "INV_Helmet_30", "=q3=遺忘兜帽", "=ds="..AtlasLootBossNames["TKTheArcatraz"][4] },
        { 27778, "INV_Shoulder_18", "=q3=遺忘護肩", "=ds="..AtlasLootBossNames["AuchShadowLabyrinth"][4] },
        { 28232, "INV_Chest_Cloth_29", "=q3=赦免長袍", "=ds="..AtlasLootBossNames["AuchShadowLabyrinth"][4] },
        { 27537, "INV_Gauntlets_16", "=q3=赦免手套", "=ds="..AtlasLootBossNames["HCShatteredHalls"][3] },
        { 27948, "INV_Pants_08", "=q3=遺忘長褲", "=ds="..AtlasLootBossNames["AuchSethekkHalls"][2] },
        };
        
    DS3Assassin = {
        { 28414, "INV_Helmet_15", "=q3=刺殺頭盔", "=ds="..AtlasLootBossNames["TKTheArcatraz"][4] },
        { 27776, "INV_Shoulder_24", "=q3=暗殺護肩", "=ds="..AtlasLootBossNames["AuchSethekkHalls"][2] },
        { 28204, "INV_Chest_Chain_17", "=q3=暗殺外衣", "=ds="..AtlasLootBossNames["TKMechanar"][5] },
        { 27509, "INV_Gauntlets_01", "=q3=刺客手套", "=ds="..AtlasLootBossNames["CoTTheBlackMorass"][3] },
        { 27908, "INV_Pants_Leather_03", "=q3=刺殺護腿", "=ds="..AtlasLootBossNames["AuchShadowLabyrinth"][4] },
        };
        
    DS3Moonglade = {
        { 28348, "INV_Helmet_15", "=q3=月林斗篷", "=ds="..AtlasLootBossNames["TKTheBotanica"][5] },
        { 27737, "INV_Shoulder_24", "=q3=月林護肩", "=ds="..AtlasLootBossNames["CFRTheSteamvault"][3] },
        { 28202, "INV_Chest_Cloth_07", "=q3=月林長袍", "=ds="..AtlasLootBossNames["TKMechanar"][5] },
        { 27468, "INV_Gauntlets_13", "=q3=月林裹手", "=ds="..AtlasLootBossNames["AuchShadowLabyrinth"][2] },
        { 27873, "INV_Pants_14", "=q3=月林長褲", "=ds="..AtlasLootBossNames["CoTTheBlackMorass"][3] },
        };
        
    DS3Wastewalker = {
        { 28224, "INV_Helmet_15", "=q3=荒行頭盔", "=ds="..AtlasLootBossNames["CoTOldHillsbradFoothills"][3].." (#j3#)" },
        { 27797, "INV_Shoulder_15", "=q3=荒行護肩", "=ds="..AtlasLootBossNames["AuchAuchenaiCrypts"][3].." (#j3#)" },
        { 28264, "INV_Chest_Chain_17", "=q3=荒行外衣", "=ds="..AtlasLootBossNames["HCBloodFurnace"][3].." (#j3#)" },
        { 27531, "INV_Gauntlets_25", "=q3=荒行手套", "=ds="..AtlasLootBossNames["HCShatteredHalls"][3] },
        { 27837, "INV_Pants_Mail_04", "=q3=荒行護腿", "=ds="..AtlasLootBossNames["AuchManaTombs"][3].." (#j3#)" },
        };
        
    DS3Beast = {
        { 28275, "INV_Helmet_19", "=q3=野獸領主頭盔", "=ds="..AtlasLootBossNames["TKMechanar"][5] },
        { 27801, "INV_Shoulder_23", "=q3=野獸領主襯肩", "=ds="..AtlasLootBossNames["CFRTheSteamvault"][3] },
        { 28228, "INV_Chest_Chain_03", "=q3=野獸領主胸甲", "=ds="..AtlasLootBossNames["TKTheBotanica"][5] },
        { 27474, "INV_Gauntlets_10", "=q3=野獸領主護手", "=ds="..AtlasLootBossNames["HCShatteredHalls"][3] },
        { 27874, "INV_Pants_03", "=q3=野獸領主護腿", "=ds="..AtlasLootBossNames["CFRTheSteamvault"][3] },
        };
        
    DS3Desolation = {
        { 28192, "INV_Helmet_18", "=q3=哀傷之鏈頭盔", "=ds="..AtlasLootBossNames["CoTTheBlackMorass"][3] },
        { 27713, "INV_Shoulder_20", "=q3=荒漠肩甲", "=ds="..AtlasLootBossNames["CFRTheSlavePens"][3].." (#j3#)" },
        { 28401, "INV_Chest_Chain_03", "=q3=哀傷之鏈鎖甲", "=ds="..AtlasLootBossNames["CoTOldHillsbradFoothills"][3].." (#j3#)" },
        { 27528, "INV_Gauntlets_10", "=q3=哀傷之鏈護手", "=ds="..AtlasLootBossNames["HCShatteredHalls"][3] },
        { 27936, "INV_Pants_Cloth_20", "=q3=哀傷之鏈護脛", "=ds="..AtlasLootBossNames["AuchSethekkHalls"][2] },
        };
        
    DS3Tidefury = {
        { 28349, "INV_Helmet_19", "=q3=惡潮頭盔", "=ds="..AtlasLootBossNames["TKTheBotanica"][5] },
        { 27802, "INV_Shoulder_31", "=q3=惡潮護肩", "=ds="..AtlasLootBossNames["HCShatteredHalls"][3] },
        { 28231, "INV_Chest_Chain_03", "=q3=惡潮護胸", "=ds="..AtlasLootBossNames["TKTheArcatraz"][4] },
        { 27510, "INV_Gauntlets_10", "=q3=惡潮護手", "=ds="..AtlasLootBossNames["CFRTheSteamvault"][3] },
        { 27909, "INV_Pants_Mail_06", "=q3=惡潮褶裙", "=ds="..AtlasLootBossNames["AuchShadowLabyrinth"][4] },
        };
        
    DS3Bold = {
        { 28350, "INV_Helmet_20", "=q3=勇猛頭盔", "=ds="..AtlasLootBossNames["TKTheBotanica"][5] },
        { 27803, "INV_Shoulder_26", "=q3=勇猛護肩", "=ds="..AtlasLootBossNames["AuchShadowLabyrinth"][4] },
        { 28205, "INV_Chest_Chain_15", "=q3=勇猛胸甲", "=ds="..AtlasLootBossNames["TKTheArcatraz"][4] },
        { 27475, "INV_Gauntlets_28", "=q3=勇猛護手", "=ds="..AtlasLootBossNames["CFRTheSteamvault"][3] },
        { 27977, "INV_Pants_Plate_06", "=q3=勇猛腿甲", "=ds="..AtlasLootBossNames["CoTTheBlackMorass"][3] },
        };
        
    DS3Doom = {
        { 28225, "INV_Helmet_20", "=q3=末日戰甲頭盔", "=ds="..AtlasLootBossNames["CoTOldHillsbradFoothills"][3].." (#j3#)" },
        { 27771, "INV_Shoulder_26", "=q3=末日戰甲護肩", "=ds="..AtlasLootBossNames["CFRTheUnderbog"][4].." (#j3#)" },
        { 28403, "INV_Chest_Chain_15", "=q3=末日戰甲護胸", "=ds="..AtlasLootBossNames["TKTheArcatraz"][4] },
        { 27497, "INV_Gauntlets_29", "=q3=末日戰甲護手", "=ds="..AtlasLootBossNames["HCBloodFurnace"][3].." (#j3#)" },
        { 27870, "INV_Pants_Plate_12", "=q3=厄運鎧甲護腿", "=ds="..AtlasLootBossNames["AuchAuchenaiCrypts"][2].." (#j3#)" },
        };
        
    DS3Right = {
        { 28285, "INV_Helmet_25", "=q3=正義頭盔", "=ds="..AtlasLootBossNames["TKMechanar"][5] },
        { 27739, "INV_Shoulder_10", "=q3=正直肩甲", "=ds="..AtlasLootBossNames["TKTheBotanica"][4] },
        { 28203, "INV_Chest_Chain_15", "=q3=公正胸甲", "=ds="..AtlasLootBossNames["CFRTheSteamvault"][3] },
        { 27535, "INV_Gauntlets_29", "=q3=正直護手", "=ds="..AtlasLootBossNames["HCShatteredHalls"][2] },
        { 27839, "INV_Pants_04", "=q3=正義腿甲", "=ds="..AtlasLootBossNames["CoTTheBlackMorass"][3] },
        };

-- ZG Sets

    ZGDruid = {
        { 0, "Spell_Nature_Regeneration", "=q6=#zgs1#", "" },
        { 19955, "INV_Jewelry_Necklace_19", "=q4=烏蘇雷的自然護符", "" },
        { 19613, "INV_Jewelry_Necklace_26", "=q4=原始南海魔化海藻", "=ds=#r5#" },
        { 19838, "INV_Chest_Leather_06", "=q4=贊達拉占卜師外套", "=q4=#zgt9#=ds=, #r4#" },
        { 19839, "INV_Belt_01", "=q4=贊達拉占卜師腰帶","=q4=#zgt4#=ds=, #r3#" },
        { 19840, "INV_Bracer_08", "=q4=贊達拉占卜師護腕", "=q4=#zgt5#=ds=, #r2#" },
        };

    ZGHunter = {
        { 0, "Ability_Hunter_RunningShot", "=q6=#zgs2#", "" },
        { 19953, "INV_Jewelry_Necklace_19", "=q4=雷納塔基的野獸護符", "" },
        { 19621, "INV_Jewelry_Necklace_26", "=q4=漩渦之怒", "=ds=#r5#" },
        { 19831, "INV_Shoulder_22", "=q4=贊達拉捕獵者襯肩", "=q4=#zgt6#=ds=, #r4#" },
        { 19832, "INV_Belt_19", "=q4=贊達拉捕獵者腰帶", "=q4=#zgt2#=ds=, #r3#" },
        { 19833, "INV_Bracer_18", "=q4=贊達拉捕獵者護腕", "=q4=#zgt3#=ds=, #r2#" },
        };

    ZGMage = {
        { 0, "Spell_Frost_IceStorm", "=q6=#zgs3#", "" },
        { 19959, "INV_Jewelry_Necklace_19", "=q4=哈札拉爾的魔法護符", "" },
        { 19601, "INV_Jewelry_Necklace_26", "=q4=卡亞羅的珠寶", "=ds=#r5#" },
        { 20034, "INV_Chest_Cloth_12", "=q4=贊達拉幻術師長袍", "=q4=#zgt1#=ds=, #r4#" },
        { 19845, "INV_Shoulder_17", "=q4=贊達拉幻術師襯肩", "=q4=#zgt2#=ds=, #r3#" },
        { 19846, "INV_Bracer_07", "=q4=贊達拉幻術師裹布", "=q4=#zgt3#=ds=, #r2#" },
        };

    ZGPaladin = {
        { 0, "Spell_Holy_SealOfMight", "=q6=#zgs4#", "" },
        { 19952, "INV_Jewelry_Necklace_19", "=q4=格里雷克的勇氣護符", "" },
        { 19588, "INV_Jewelry_Necklace_26", "=q4=英雄的烙印", "=ds=#r5#" },
        { 19825, "INV_Chest_Plate07", "=q4=贊達拉思考者胸甲", "=q4=#zgt9#=ds=, #r4#" },
        { 19826, "INV_Belt_32", "=q4=贊達拉思考者腰帶", "=q4=#zgt2#=ds=, #r3#" },
        { 19827, "INV_Bracer_14", "=q4=贊達拉思考者護臂", "=q4=#zgt3#=ds=, #r2#" },
        };

    ZGPriest = {
        { 0, "Spell_Holy_PowerWordShield", "=q6=#zgs5#", "" },
        { 19958, "INV_Jewelry_Necklace_19", "=q4=哈札拉爾的治療護符", "" },
        { 19594, "INV_Jewelry_Necklace_26", "=q4=祖達薩的全視之眼", "=ds=#r5#" },
        { 19841, "INV_Shoulder_01", "=q4=贊達拉懺悔者襯肩", "=q4=#zgt6#=ds=, #r4#" },
        { 19842, "INV_Belt_08", "=q4=贊達拉懺悔者腰帶", "=q4=#zgt4#=ds=, #r3#" },
        { 19843, "INV_Bracer_07", "=q4=贊達拉懺悔者裹布", "=q4=#zgt5#=ds=, #r2#" },
        };

    ZGRogue = {
        { 0, "Ability_BackStab", "=q6=#zgs6#", "" },
        { 19954, "INV_Jewelry_Necklace_19", "=q4=雷納塔基的狡詐護符", "" },
        { 19617, "INV_Jewelry_Necklace_26", "=q4=贊達拉暗影大師墜飾", "=ds=#r5#" },
        { 19834, "INV_Chest_Leather_10", "=q4=贊達拉狂妄者外套", "=q4=#zgt6#=ds=, #r4#" },
        { 19835, "INV_Shoulder_29", "=q4=贊達拉狂妄者襯肩", "=q4=#zgt7#=ds=, #r3#" },
        { 19836, "INV_Bracer_14", "=q4=贊達拉狂妄者護腕", "=q4=#zgt8#=ds=, #r2#" },
        };

    ZGShaman = {
        { 0, "Spell_FireResistanceTotem_01", "=q6=#zgs7#", "" },
        { 19956, "INV_Jewelry_Necklace_19", "=q4=烏蘇雷的靈魂護符", "" },
        { 19609, "INV_Jewelry_Necklace_26", "=q4=完美巫毒幻象", "=ds=#r5#" },
        { 19828, "INV_Chest_Fur", "=q4=贊達拉預言者外套", "=q4=#zgt9#=ds=, #r4#" },
        { 19829, "INV_Belt_19", "=q4=贊達拉預言者腰帶", "=q4=#zgt7#=ds=, #r3#" },
        { 19830, "INV_Bracer_15", "=q4=贊達拉預言者護腕", "=q4=#zgt8#=ds=, #r2#" },
        };

    ZGWarlock = {
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#zgs8#", "" },
        { 19957, "INV_Jewelry_Necklace_19", "=q4=哈札拉爾的毀滅護符", "" },
        { 19605, "INV_Jewelry_Necklace_26", "=q4=科贊的強力玷污", "=ds=#r5#" },
        { 20033, "INV_Chest_Cloth_12", "=q4=贊達拉惡魔師長袍", "=q4=#zgt1#=ds=, #r4#" },
        { 19849, "INV_Shoulder_17", "=q4=贊達拉惡魔師襯肩", "=q4=#zgt4#=ds=, #r3#" },
        { 19848, "INV_Bracer_07", "=q4=贊達拉惡魔師裹帶", "=q4=#zgt5#=ds=, #r2#" },
        };

    ZGWarrior = {
        { 0, "INV_Shield_05", "=q6=#zgs9#", "" },
        { 19951, "INV_Jewelry_Necklace_19", "=q4=格里雷克的力量護符", "" },
        { 19577, "INV_Jewelry_Necklace_26", "=q4=穆賈巴之怒", "=ds=#r5#" },
        { 19822, "INV_Chest_Plate07", "=q4=贊達拉辯護者胸甲", "=q4=#zgt1#=ds=, #r4#" },
        { 19823, "INV_Belt_32", "=q4=贊達拉辯護者腰帶", "=q4=#zgt7#=ds=, #r3#" },
        { 19824, "INV_Bracer_14", "=q4=贊達拉辯護者護臂", "=q4=#zgt8#=ds=, #r2#" },
        };

-- AQ20 Sets

    AQ20Druid = {
        { 0, "Spell_Nature_Regeneration", "=q6=#aq20s1#", "" },
        { 21407, "INV_Mace22", "=q4=不滅生命之錘", "=q4=#aq20t1#=ds=, #r5#" },
        { 21409, "INV_Misc_Cape_15", "=q4=不滅生命披風", "=q3=#aq20t5#=ds=, #r4#" },
        { 21408, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=不滅生命之戒", "=q3=#aq20t3#=ds=, #r3#" },
        };

    AQ20Hunter = {
        { 0, "Ability_Hunter_RunningShot", "=q6=#aq20s2#", "" },
        { 21401, "INV_Axe_15", "=q4=隱秘通途之鐮", "=q4=#aq20t6#=ds=, #r5#" },
        { 21403, "INV_Misc_Cape_15", "=q4=隱秘通途披風", "=q3=#aq20t5#=ds=, #r4#" },
        { 21402, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=隱秘通途之戒", "=q3=#aq20t4#=ds=, #r3#" },
        };
        
    AQ20Mage = {
        { 0, "Spell_Frost_IceStorm", "=q6=#aq20s3#", "" },
        { 21413, "INV_Sword_57", "=q4=魔法祕密之刃", "=q4=#aq20t1#=ds=, #r5#" },
        { 21415, "INV_Misc_Cape_19", "=q4=魔法祕密披風", "=q3=#aq20t2#=ds=, #r4#" },
        { 21414, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=魔法祕密之戒", "=q3=#aq20t3#=ds=, #r3#" },
        };

    AQ20Paladin = {
        { 0, "Spell_Holy_SealOfMight", "=q6=#aq20s4#", "" },
        { 21395, "INV_Sword_57", "=q4=永恆公正長劍", "=q4=#aq20t6#=ds=, #r5#" },
        { 21397, "INV_Misc_Cape_14", "=q4=永恆公正斗篷", "=q3=#aq20t5#=ds=, #r4#" },
        { 21396, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=永恆公正之戒", "=q3=#aq20t3#=ds=, #r3#" },
        };

    AQ20Priest = {
        { 0, "Spell_Holy_PowerWordShield", "=q6=#aq20s5#", "" },
        { 21410, "INV_Mace22", "=q4=無盡智慧之槌", "=q4=#aq20t1#=ds=, #r5#" },
        { 21412, "INV_Misc_Cape_16", "=q4=無盡智慧披風", "=q3=#aq20t2#=ds=, #r4#" },
        { 21411, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=無盡智慧之戒", "=q3=#aq20t4#=ds=, #r3#" },
        };

    AQ20Rogue = {
        { 0, "Ability_BackStab", "=q6=#aq20s6#", "" },
        { 21404, "INV_Weapon_ShortBlade_27", "=q4=籠罩陰影匕首", "=q4=#aq20t6#=ds=, #r5#" },
        { 21406, "INV_Misc_Cape_19", "=q4=籠罩陰影披風", "=q3=#aq20t2#=ds=, #r4#" },
        { 21405, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=籠罩陰影之戒", "=q3=#aq20t4#=ds=, #r3#" },
        };

    AQ20Shaman = {
        { 0, "Spell_FireResistanceTotem_01", "=q6=#aq20s7#", "" },
        { 21398, "INV_Mace22", "=q4=聚集風暴之錘", "=q4=#aq20t6#=ds=, #r5#" },
        { 21400, "INV_Misc_Cape_16", "=q4=聚集風暴披風", "=q3=#aq20t5#=ds=, #r4#" },
        { 21399, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=聚集風暴之戒", "=q3=#aq20t3#=ds=, #r3#" },
        };

    AQ20Warlock = {
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#aq20s8#", "" },
        { 21416, "INV_Weapon_ShortBlade_27", "=q4=禁斷邪語短劍", "=q4=#aq20t1#=ds=, #r5#" },
        { 21418, "INV_Misc_Cape_20", "=q4=禁斷邪語披風", "=q3=#aq20t5#=ds=, #r4#" },
        { 21417, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=禁斷邪語之戒", "=q3=#aq20t4#=ds=, #r3#" },
        };

    AQ20Warrior = {
        { 0, "INV_Shield_05", "=q6=#aq20s9#", "" },
        { 21392, "INV_Axe_15", "=q4=堅定力量之鐮", "=q4=#aq20t6#=ds=, #r5#" },
        { 21394, "INV_Misc_Cape_20", "=q4=堅定力量披風", "=q3=#aq20t2#=ds=, #r4#" },
        { 21393, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=堅定力量之戒", "=q3=#aq20t3#=ds=, #r3#" },
        };

-- AQ40 Sets

    AQ40Druid = {
        { 0, "Spell_Nature_Regeneration", "=q6=#aq40s1#", "" },
        { 21357, "INV_Chest_Leather_08", "=q4=起源外套", "=q4=#aq40t4#=ds=, #r3#" },
        { 21353, "INV_Helmet_06", "=q4=起源頭盔", "=q4=#aq40t6#=ds=, #r2#" },
        { 21356, "INV_Pants_Leather_01", "=q4=起源長褲", "=q4=#aq40t7#=ds=, #r2#" },
        { 21354, "INV_Shoulder_03", "=q4=起源護肩", "=q4=#aq40t1#=ds=, #r1#" },
        { 21355, "INV_Boots_Cloth_07", "=q4=起源長靴", "=q4=#aq40t1#=ds=, #r1#" },
        };

    AQ40Hunter = {
        { 0, "Ability_Hunter_RunningShot", "=q6=#aq40s2#", "" },
        { 21370, "INV_Chest_Chain_04", "=q4=攻擊者的護甲", "=q4=#aq40t8#=ds=, #r3#" },
        { 21366, "INV_Helmet_73", "=q4=攻擊者的王冠", "=q4=#aq40t6#=ds=, #r2#" },
        { 21368, "INV_Pants_Mail_11", "=q4=攻擊者的護腿", "=q4=#aq40t7#=ds=, #r2#" },
        { 21367, "INV_Shoulder_36", "=q4=攻擊者的護肩", "=q4=#aq40t5#=ds=, #r1#" },
        { 21365, "INV_Boots_Chain_08", "=q4=攻擊者的足甲", "=q4=#aq40t5#=ds=, #r1#" },
        };
        
    AQ40Mage = {
        { 0, "Spell_Frost_IceStorm", "=q6=#aq40s3#", "" },
        { 21343, "INV_Chest_Cloth_11", "=q4=神秘長袍", "=q4=#aq40t4#=ds=, #r3#" },
        { 21347, "INV_Helmet_06", "=q4=神秘頭飾", "=q4=#aq40t2#=ds=, #r2#" },
        { 21346, "INV_Pants_Cloth_08", "=q4=神秘護腿", "=q4=#aq40t3#=ds=, #r2#" },
        { 21345, "INV_Shoulder_03", "=q4=神秘肩墊", "=q4=#aq40t1#=ds=, #r1#" },
        { 21344, "INV_Boots_Cloth_03", "=q4=神秘長靴", "=q4=#aq40t1#=ds=, #r1#" },
        };

    AQ40Paladin = {
        { 0, "Spell_Holy_SealOfMight", "=q6=#aq40s4#", "" },
        { 21389, "INV_Chest_Plate03", "=q4=復仇者的胸鎧", "=q4=#aq40t8#=ds=, #r3#" },
        { 21387, "INV_Helmet_72", "=q4=復仇者的王冠", "=q4=#aq40t6#=ds=, #r2#" },
        { 21390, "INV_Pants_Plate_02", "=q4=復仇者的護腿", "=q4=#aq40t7#=ds=, #r2#" },
        { 21391, "INV_Shoulder_35", "=q4=復仇者的護肩", "=q4=#aq40t1#=ds=, #r1#" },
        { 21388, "INV_Boots_Chain_07", "=q4=復仇者的脛甲", "=q4=#aq40t1#=ds=, #r1#" },
        };

    AQ40Priest = {
        { 0, "Spell_Holy_PowerWordShield", "=q6=#aq40s5#", "" },
        { 21351, "INV_Chest_Cloth_10", "=q4=神諭者的外套", "=q4=#aq40t4#=ds=, #r3#" },
        { 21348, "INV_Helmet_06", "=q4=神諭者的皇冠", "=q4=#aq40t2#=ds=, #r2#" },
        { 21352, "INV_Pants_Cloth_07", "=q4=神諭者的長褲","=q4=#aq40t3#=ds=, #r2#" },
        { 21350, "INV_Shoulder_03", "=q4=神諭者的襯肩", "=q4=#aq40t5#=ds=, #r1#" },
        { 21349, "INV_Boots_Cloth_07", "=q4=神諭者的裹足", "=q4=#aq40t5#=ds=, #r1#" },
        };

    AQ40Rogue = {
        { 0, "Ability_BackStab", "=q6=#aq40s6#", "" },
        { 21364, "INV_Chest_Leather_08", "=q4=死亡執行者的胸甲", "=q4=#aq40t8#=ds=, #r3#" },
        { 21360, "INV_Helmet_04", "=q4=死亡執行者的頭盔", "=q4=#aq40t6#=ds=, #r2#" },
        { 21362, "INV_Pants_Leather_07", "=q4=死亡執行者的護腿", "=q4=#aq40t3#=ds=, #r2#" },
        { 21361, "INV_Shoulder_03", "=q4=死亡執行者的護肩", "=q4=#aq40t5#=ds=, #r1#" },
        { 21359, "INV_Boots_08", "=q4=死亡執行者的長靴", "=q4=#aq40t5#=ds=, #r1#" },
        };

    AQ40Shaman = {
        { 0, "Spell_FireResistanceTotem_01", "=q6=#aq40s7#", "" },
        { 21374, "INV_Chest_Chain_13", "=q4=風暴召喚者的護甲", "=q4=#aq40t8#=ds=, #r3#" },
        { 21372, "INV_Helmet_73", "=q4=風暴召喚者的王冠", "=q4=#aq40t6#=ds=, #r2#" },
        { 21375, "INV_Pants_Mail_10", "=q4=風暴召喚者的護腿", "=q4=#aq40t7#=ds=, #r2#" },
        { 21376, "INV_Shoulder_03", "=q4=風暴召喚者的肩甲", "=q4=#aq40t1#=ds=, #r1#" },
        { 21373, "INV_Boots_Chain_07", "=q4=風暴召喚者的足甲", "=q4=#aq40t1#=ds=, #r1#" },
        };

    AQ40Warlock = {
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#aq40s8#", "" },
        { 21334, "INV_Chest_Cloth_12", "=q4=厄運召喚者的長袍", "=q4=#aq40t4#=ds=, #r3#" },
        { 21337, "INV_Helmet_06", "=q4=厄運召喚者的頭飾", "=q4=#aq40t2#=ds=, #r2#" },
        { 21336, "INV_Pants_Cloth_02", "=q4=厄運召喚者的長褲", "=q4=#aq40t7#=ds=, #r2#" },
        { 21335, "INV_Shoulder_03", "=q4=厄運召喚者的襯肩", "=q4=#aq40t1#=ds=, #r1#" },
        { 21338, "INV_Boots_Cloth_02", "=q4=厄運召喚者的裹足", "=q4=#aq40t1#=ds=, #r1#" },
        };

    AQ40Warrior = {
        { 0, "INV_Shield_05", "=q6=#aq40s9#", "" },
        { 21331, "INV_Chest_Plate12", "=q4=征服者的胸甲", "=q4=#aq40t8#=ds=, #r3#" },
        { 21329, "INV_Helmet_72", "=q4=征服者的皇冠", "=q4=#aq40t2#=ds=, #r2#" },
        { 21332, "INV_Pants_Plate_03", "=q4=征服者的腿鎧", "=q4=#aq40t3#=ds=, #r2#" },
        { 21330, "INV_Shoulder_35", "=q4=征服者的肩鎧", "=q4=#aq40t5#=ds=, #r1#" },
        { 21333, "INV_Boots_Plate_05", "=q4=征服者的脛甲", "=q4=#aq40t5#=ds=, #r1#" },
        };

-- PvP Level 60 Rare and Epic Sets

    PVPDruid = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea1#", "=q5=#pvps1#" },
        { 16451, "INV_Helmet_41", "=q4=戰場元帥的龍皮頭盔", "", "", "13005", "#alliance#", "30", "#av#" },
        { 16449, "INV_Shoulder_23", "=q4=戰場元帥的龍皮肩甲", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 16452, "INV_Chest_Cloth_07", "=q4=戰場元帥的龍皮胸甲", "", "", "13770", "#alliance#", "30", "#ab#" },
	{ 16448, "INV_Gauntlets_21", "=q4=元帥的龍皮手套", "", "", "8415", "#alliance#", "20", "#av#" },
	{ 16450, "INV_Pants_06", "=q4=元帥的龍皮腿甲", "", "", "13005", "#alliance#", "30", "#wsg#" },
        { 16459, "INV_Boots_08", "=q4=元帥的龍皮戰靴", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
	{ 0, "INV_BannerPVP_02", "=q6=#pvpra1#", "=q5=#pvps2#" },
        { 23308, "INV_Helmet_09", "=q3=少校的龍皮戰盔", "", "", "4335", "#alliance#", "30", "#av#" },
        { 23309, "INV_Shoulder_07", "=q3=少校的龍皮護肩", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 23294, "INV_Chest_Leather_07", "=q3=上尉騎士的龍皮護胸", "", "", "4590", "#alliance#", "30", "#ab#" },
        { 23280, "INV_Gauntlets_25", "=q3=中尉騎士的龍皮裹手", "", "", "2805", "#alliance#", "20", "#av#" },
        { 23295, "INV_Pants_06", "=q3=上尉騎士的龍皮長褲", "", "", "4335", "#alliance#", "30", "#wsg#" },
        { 23281, "INV_Boots_08", "=q3=中尉騎士的龍皮長靴", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh1#", "=q5=#pvps1#" },
        { 16550, "INV_Helmet_09", "=q4=督軍的龍皮頭盔", "", "", "13005", "#horde#", "30", "#av#" },
        { 16551, "INV_Shoulder_07", "=q4=督軍的龍皮肩飾", "", "", "8415", "#horde#", "20", "#ab#" },
        { 16549, "INV_Chest_Chain_16", "=q4=督軍的龍皮鎖甲", "", "", "13770", "#horde#", "30", "#ab#" },
	{ 16555, "INV_Gauntlets_25", "=q4=將軍的龍皮手套", "", "", "8415", "#horde#", "20", "#av#" },
	{ 16552, "INV_Pants_06", "=q4=將軍的龍皮護腿", "", "", "13005", "#horde#", "30", "#wsg#" },
        { 16554, "INV_Boots_08", "=q4=將軍的龍皮戰靴", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
	{ 0, "INV_BannerPVP_01", "=q6=#pvprh1#", "=q5=#pvps2#" },
        { 23253, "INV_Helmet_09", "=q3=勇士的龍皮戰盔", "", "", "4335", "#horde#", "30", "#av#" },
        { 23254, "INV_Shoulder_07", "=q3=勇士的龍皮護肩", "", "", "2805", "#horde#", "20", "#ab#" },
        { 22877, "INV_Chest_Leather_07", "=q3=軍團士兵的龍皮護胸", "", "", "4590", "#horde#", "30", "#ab#" },
        { 22863, "INV_Gauntlets_25", "=q3=血衛士的龍皮手套", "", "", "2805", "#horde#", "20", "#av#" },
        { 22878, "INV_Pants_06", "=q3=軍團士兵的龍皮護褲", "", "", "4335", "#horde#", "30", "#wsg#" },
        { 22852, "INV_Boots_08", "=q3=血衛士的龍皮長靴", "", "", "2805", "#horde#", "20", "#ab#" },
        };
        
    PVPHunter = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea2#", "=q5=#pvps1#" },
        { 16465, "INV_Helmet_05", "=q4=戰場元帥的鍊甲頭盔", "", "", "13005", "#alliance#", "30", "#av#" },
        { 16468, "INV_Shoulder_10", "=q4=戰場元帥的鍊甲護肩", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 16466, "INV_Chest_Chain_03", "=q4=戰場元帥的鍊甲", "", "", "13770", "#alliance#", "30", "#ab#" },
        { 16463, "INV_Gauntlets_10", "=q4=元帥的鍊甲護手", "", "", "8415", "#alliance#", "20", "#av#" },
        { 16467, "INV_Pants_Mail_17", "=q4=元帥的鍊甲護腿", "", "", "13005", "#alliance#", "30", "#wsg#" },
        { 16462, "INV_Boots_Plate_07", "=q4=元帥的鍊甲戰靴", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvpra2#", "=q5=#pvps2#" },
        { 23306, "INV_Helmet_21", "=q3=少校的鍊甲戰盔", "", "", "4335", "#alliance#", "30", "#av#" },
        { 23307, "INV_Shoulder_16", "=q3=少校的鍊甲護肩", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 23292, "INV_Chest_Chain_04", "=q3=上尉騎士的鍊甲護胸", "", "", "4590", "#alliance#", "30", "#ab#" },
        { 23279, "INV_Gauntlets_17", "=q3=中尉騎士的鍊甲手套", "", "", "2805", "#alliance#", "20", "#av#" },
        { 23293, "INV_Pants_03", "=q3=上尉騎士的鍊甲長褲", "", "", "4335", "#alliance#", "30", "#wsg#" },
        { 23278, "INV_Boots_05", "=q3=中尉騎士的鍊甲脛甲", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh2#", "=q5=#pvps1#" },
        { 16566, "INV_Helmet_09", "=q4=督軍的鍊甲頭盔", "", "", "13005", "#horde#", "30", "#av#" },
        { 16568, "INV_Shoulder_29", "=q4=督軍的鍊甲護肩", "", "", "8415", "#horde#", "20", "#ab#" },
        { 16565, "INV_Chest_Chain_11", "=q4=督軍的鍊甲", "", "", "13770", "#horde#", "30", "#ab#" },
        { 16571, "INV_Gauntlets_11", "=q4=將軍的鍊甲手套", "", "", "8415", "#horde#", "20", "#av#" },
        { 16567, "INV_Pants_Mail_16", "=q4=將軍的鍊甲護腿", "", "", "13005", "#horde#", "30", "#wsg#" },
        { 16569, "INV_Boots_Plate_06", "=q4=將軍的鍊甲戰靴", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvprh2#", "=q5=#pvps2#" },
        { 23251, "INV_Helmet_03", "=q3=勇士的鍊甲戰盔", "", "", "4335", "#horde#", "30", "#av#" },
        { 23252, "INV_Shoulder_01", "=q3=勇士的鍊甲肩甲", "", "", "2805", "#horde#", "20", "#ab#" },
        { 22874, "INV_Chest_Chain_04", "=q3=軍團士兵的鍊衣", "", "", "4590", "#horde#", "30", "#ab#" },
        { 22862, "INV_Gauntlets_17", "=q3=血衛士的鍊甲手套", "", "", "2805", "#horde#", "20", "#av#" },
        { 22875, "INV_Pants_03", "=q3=軍團士兵的鍊甲護褲", "", "", "4335", "#horde#", "30", "#wsg#" },
        { 22843, "INV_Boots_05", "=q3=血衛士的鍊甲護腿", "", "", "2805", "#horde#", "20", "#ab#" },
        };
    
    PVPMage = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea3#", "=q5=#pvps1#" },
        { 16441, "INV_Helmet_24", "=q4=戰場元帥的絲質寶冠", "", "", "13005", "#alliance#", "30", "#av#" },
        { 16444, "INV_Shoulder_23", "=q4=戰場元帥的絲質肩甲", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 16443, "INV_Chest_Cloth_12", "=q4=戰場元帥的絲質外衣", "", "", "13770", "#alliance#", "30", "#ab#" },
	{ 16440, "INV_Gauntlets_14", "=q4=元帥的絲質手套", "", "", "8415", "#alliance#", "20", "#av#" },
	{ 16442, "INV_Pants_08", "=q4=元帥的絲質護腿", "", "", "13005", "#alliance#", "30", "#wsg#" },
        { 16437, "INV_Boots_Cloth_03", "=q4=元帥的絲質裹足", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvpra3#", "=q5=#pvps2#" },
        { 23318, "INV_Helmet_06", "=q3=少校的絲質頭環", "", "", "4335", "#alliance#", "30", "#av#" },
        { 23319, "INV_Shoulder_02", "=q3=少校的絲質襯肩", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 23305, "INV_Chest_Cloth_28", "=q3=上尉騎士的絲質長袍", "", "", "4590", "#alliance#", "30", "#ab#" },
	{ 23290, "INV_Gauntlets_06", "=q3=中尉騎士的絲質裹手", "", "", "2805", "#alliance#", "20", "#av#" },
        { 23304, "INV_Pants_11", "=q3=上尉騎士的絲質長褲", "", "", "4335", "#alliance#", "30", "#wsg#" },
	{ 23291, "INV_Boots_05", "=q3=中尉騎士的絲質便鞋", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh3#", "=q5=#pvps1#" },
        { 16533, "INV_Helmet_08", "=q4=督軍的絲質罩帽", "", "", "13005", "#horde#", "30", "#av#" },
        { 16536, "INV_Shoulder_19", "=q4=督軍的絲質披肩", "", "", "8415", "#horde#", "20", "#ab#" },
        { 16535, "INV_Chest_Leather_01", "=q4=督軍的絲質外衣", "", "", "13770", "#horde#", "30", "#ab#" },
	{ 16540, "INV_Gauntlets_19", "=q4=將軍的絲質護手", "", "", "8415", "#horde#", "20", "#av#" },
	{ 16534, "INV_Pants_07", "=q4=將軍的絲質長褲", "", "", "13005", "#horde#", "30", "#wsg#" },
        { 16539, "INV_Boots_05", "=q4=將軍的絲質長靴", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvprh3#", "=q5=#pvps2#" },
        { 23263, "INV_Helmet_06", "=q3=勇士的絲質頭環", "", "", "4335", "#horde#", "30", "#av#" },
        { 23264, "INV_Shoulder_02", "=q3=勇士的絲質襯肩", "", "", "2805", "#horde#", "20", "#ab#" },
        { 22886, "INV_Chest_Cloth_28", "=q3=軍團士兵的絲質外套", "", "", "4590", "#horde#", "30", "#ab#" },
	{ 22870, "INV_Gauntlets_06", "=q3=血衛士的絲質裹手", "", "", "2805", "#horde#", "20", "#av#" },
        { 22883, "INV_Pants_11", "=q3=軍團士兵的絲質護褲", "", "", "4335", "#horde#", "30", "#wsg#" },
	{ 22860, "INV_Boots_05", "=q3=血衛士的絲質便鞋", "", "", "2805", "#horde#", "20", "#ab#" },
	};

    PVPPaladin = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea4#", "=q5=#pvps1#" },
        { 16474, "INV_Helmet_05", "=q4=戰場元帥的板層甲頭盔", "", "", "13005", "#alliance#", "30", "#av#" },
        { 16476, "INV_Shoulder_20", "=q4=戰場元帥的板層甲肩鎧", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 16473, "INV_Chest_Plate03", "=q4=戰場元帥的板層甲", "", "", "13770", "#alliance#", "30", "#ab#" },
        { 16471, "INV_Gauntlets_29", "=q4=元帥的板層甲手套", "", "", "8415", "#alliance#", "20", "#av#" },
        { 16475, "INV_Pants_04", "=q4=元帥的板層甲腿鎧", "", "", "13005", "#alliance#", "30", "#wsg#" },
        { 16472, "INV_Boots_Plate_09", "=q4=元帥的板層甲戰靴", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
	{ 0, "INV_BannerPVP_02", "=q6=#pvpra4#", "=q5=#pvps2#" },
        { 23276, "INV_Helmet_05", "=q3=少校的板層甲戰盔", "", "", "4335", "#alliance#", "30", "#av#" },
        { 23277, "INV_Shoulder_28", "=q3=少校的板層甲護肩", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 23272, "INV_Chest_Plate03", "=q3=上尉騎士的板層甲護胸", "", "", "4590", "#alliance#", "30", "#ab#" },
        { 23274, "INV_Gauntlets_29", "=q3=中尉騎士的板層甲護手", "", "", "2805", "#alliance#", "20", "#av#" },
        { 23273, "INV_Pants_06", "=q3=上尉騎士的板層甲護腿", "", "", "4335", "#alliance#", "30", "#wsg#" },
        { 23275, "INV_Boots_Plate_03", "=q3=中尉騎士的板層甲長靴", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh9#", "=q5=#pvps1#" },
        { 29616, "INV_Helmet_05", "=q4=督軍的片甲頭盔", "", "", "13005", "#horde#", "30", "#av#" },
        { 29617, "INV_Shoulder_20", "=q4=督軍的片甲肩鎧", "", "", "8415", "#horde#", "20", "#ab#" },
        { 29615, "INV_Chest_Plate03", "=q4=督軍的片甲胸鎧", "", "", "13770", "#horde#", "30", "#ab#" },
        { 29613, "INV_Gauntlets_29", "=q4=將軍的片甲手套", "", "", "8415", "#horde#", "20", "#av#" },
        { 29614, "INV_Pants_04", "=q4=將軍的片甲護腿", "", "", "13005", "#horde#", "30", "#wsg#" },
        { 29612, "INV_Boots_Plate_09", "=q4=將軍的片甲之靴", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
	{ 0, "INV_BannerPVP_01", "=q6=#pvprh9#", "=q5=#pvps2#" },
        { 29604, "INV_Helmet_05", "=q3=勇士的片甲頭罩", "", "", "4335", "#horde#", "30", "#av#" },
	{ 29605, "INV_Shoulder_28", "=q3=勇士的片甲護肩", "", "", "2805", "#horde#", "20", "#ab#" },
	{ 29602, "INV_Chest_Plate03", "=q3=軍團士兵的片甲護胸", "", "", "4590", "#horde#", "30", "#ab#" },
        { 29600, "INV_Gauntlets_29", "=q3=血衛士的片甲護手", "", "", "2805", "#horde#", "20", "#av#" },
	{ 29603, "INV_Pants_06", "=q3=軍團士兵的片甲護腿", "", "", "4335", "#horde#", "30", "#wsg#" },
	{ 29601, "INV_Boots_Plate_03", "=q3=血衛士的片甲重靴", "", "", "2805", "#horde#", "20", "#ab#" },
	};
        
    PVPPriest = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea5#", "=q5=#pvps1#" },
        { 17602, "INV_Helmet_24", "=q4=戰場元帥的頭飾", "", "", "13005", "#alliance#", "30", "#av#" },
	{ 17604, "INV_Shoulder_02", "=q4=戰場元帥的綢緞襯肩", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 17605, "INV_Chest_Cloth_02", "=q4=戰場元帥的綢緞外衣", "", "", "13770", "#alliance#", "30", "#ab#" },
        { 17608, "INV_Gauntlets_14", "=q4=元帥的綢緞手套", "", "", "8415", "#alliance#", "20", "#av#" },
        { 17603, "INV_Pants_06", "=q4=元帥的綢緞短褲", "", "", "13005", "#alliance#", "30", "#wsg#" },
	{ 17607, "INV_Boots_07", "=q4=元帥的綢緞便鞋", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
	{ 0, "INV_BannerPVP_02", "=q6=#pvpra5#", "=q5=#pvps2#" },
	{ 23316, "INV_Helmet_17", "=q3=少校的綢緞頭環", "", "", "4335", "#alliance#", "30", "#av#" },
        { 23317, "INV_Shoulder_01", "=q3=少校的綢緞襯肩", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 23303, "INV_Chest_Leather_01", "=q3=上尉騎士的綢緞外衣", "", "", "4590", "#alliance#", "30", "#ab#" },
        { 23288, "INV_Gauntlets_17", "=q3=中尉騎士的綢緞裹手", "", "", "2805", "#alliance#", "20", "#av#" },
        { 23302, "INV_Pants_11", "=q3=上尉騎士的綢緞長褲", "", "", "4335", "#alliance#", "30", "#wsg#" },
        { 23289, "INV_Boots_05", "=q3=中尉騎士的綢緞便鞋", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh4#", "=q5=#pvps1#" },
        { 17623, "INV_Helmet_08", "=q4=督軍的綢緞罩帽", "", "", "13005", "#horde#", "30", "#av#" },
	{ 17622, "INV_Shoulder_19", "=q4=督軍的綢緞襯肩", "", "", "8415", "#horde#", "20", "#ab#" },
        { 17624, "INV_Chest_Leather_01", "=q4=督軍的綢緞長袍", "", "", "13770", "#horde#", "30", "#ab#" },
        { 17620, "INV_Gauntlets_27", "=q4=將軍的綢緞手套", "", "", "8415", "#horde#", "20", "#av#" },
        { 17625, "INV_Pants_07", "=q4=將軍的綢緞護腿", "", "", "13005", "#horde#", "30", "#wsg#" },
	{ 17618, "INV_Boots_05", "=q4=將軍的綢緞長靴", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
	{ 0, "INV_BannerPVP_01", "=q6=#pvprh4#", "=q5=#pvps2#" },
	{ 23261, "INV_Helmet_17", "=q3=勇士的綢緞頭環", "", "", "4335", "#horde#", "30", "#av#" },
        { 23262, "INV_Shoulder_01", "=q3=勇士的綢緞襯肩", "", "", "2805", "#horde#", "20", "#ab#" },
        { 22885, "INV_Chest_Leather_01", "=q3=軍團士兵的綢緞長袍", "", "", "4590", "#horde#", "30", "#ab#" },
        { 22869, "INV_Gauntlets_17", "=q3=血衛士的綢緞裹手", "", "", "2805", "#horde#", "20", "#av#" },
        { 22882, "INV_Pants_11", "=q3=軍團士兵的綢緞護褲", "", "", "4335", "#horde#", "30", "#wsg#" },
        { 22859, "INV_Boots_05", "=q3=血衛士的綢緞便鞋", "", "", "2805", "#horde#", "20", "#ab#" },
        };

    PVPRogue = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea6#", "=q5=#pvps1#" },
        { 16455, "INV_Helmet_41", "=q4=戰場元帥的皮甲面具", "", "", "13005", "#alliance#", "30", "#av#" },
        { 16457, "INV_Shoulder_23", "=q4=戰場元帥的皮甲肩飾", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 16453, "INV_Chest_Cloth_07", "=q4=戰場元帥的皮甲", "", "", "13770", "#alliance#", "30", "#ab#" },
	{ 16454, "INV_Gauntlets_21", "=q4=元帥的皮甲護手", "", "", "8415", "#alliance#", "20", "#av#" },
        { 16456, "INV_Pants_06", "=q4=元帥的皮甲護腿", "", "", "13005", "#alliance#", "30", "#wsg#" },
	{ 16446, "INV_Boots_08", "=q4=元帥的皮甲護足", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvpra6#", "=q5=#pvps2#" },
        { 23312, "INV_Helmet_09", "=q3=少校的皮甲戰盔", "", "", "4335", "#alliance#", "30", "#av#" },
        { 23313, "INV_Shoulder_14", "=q3=少校的皮甲襯肩", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 23298, "INV_Chest_Leather_05", "=q3=上尉騎士的皮甲護胸", "", "", "4590", "#alliance#", "30", "#ab#" },
        { 23284, "INV_Gauntlets_15", "=q3=中尉騎士的皮甲裹手", "", "", "2805", "#alliance#", "20", "#av#" },
        { 23299, "INV_Pants_08", "=q3=上尉騎士的皮甲長褲", "", "", "4335", "#alliance#", "30", "#wsg#" },
        { 23285, "INV_Boots_05", "=q3=中尉騎士的皮甲便鞋", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh5#", "=q5=#pvps1#" },
        { 16561, "INV_Helmet_09", "=q4=督軍的皮甲頭盔", "", "", "13005", "#horde#", "30", "#av#" },
        { 16562, "INV_Shoulder_07", "=q4=督軍的皮甲肩鎧", "", "", "8415", "#horde#", "20", "#ab#" },
        { 16563, "INV_Chest_Chain_16", "=q4=督軍的皮甲", "", "", "13770", "#horde#", "30", "#ab#" },
	{ 16560, "INV_Gauntlets_25", "=q4=將軍的皮甲手套", "", "", "8415", "#horde#", "20", "#av#" },
        { 16564, "INV_Pants_06", "=q4=將軍的皮甲護腿", "", "", "13005", "#horde#", "30", "#wsg#" },
	{ 16558, "INV_Boots_08", "=q4=將軍的皮甲戰靴", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvprh5#", "=q5=#pvps2#" },
        { 23257, "INV_Helmet_09", "=q3=勇士的皮甲戰盔", "", "", "4335", "#horde#", "30", "#av#" },
        { 23258, "INV_Shoulder_14", "=q3=勇士的皮甲肩甲", "", "", "2805", "#horde#", "20", "#ab#" },
        { 22879, "INV_Chest_Leather_05", "=q3=軍團士兵的皮甲胸甲", "", "", "4590", "#horde#", "30", "#ab#" },
        { 22864, "INV_Gauntlets_15", "=q3=血衛士的皮甲手套", "", "", "2805", "#horde#", "20", "#av#" },
        { 22880, "INV_Pants_08", "=q3=軍團士兵的皮甲腿甲", "", "", "4335", "#horde#", "30", "#wsg#" },
        { 22856, "INV_Boots_05", "=q3=血衛士的皮甲便鞋", "", "", "2805", "#horde#", "20", "#ab#" },
	};

    PVPShaman = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea9#", "=q5=#pvps1#" },
        { 29610, "INV_Helmet_09", "=q4=戰場元帥的鎖甲頭盔", "", "", "13005", "#alliance#", "30", "#av#" },
        { 29611, "INV_Shoulder_29", "=q4=戰場元帥的鎖甲肩鎧", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 29609, "INV_Chest_Chain_11", "=q4=戰場元帥的鎖甲", "", "", "13770", "#alliance#", "30", "#ab#" },
	{ 29607, "INV_Gauntlets_11", "=q4=元帥的鎖甲手套", "", "", "8415", "#alliance#", "20", "#av#" },
	{ 29608, "INV_Pants_Mail_15", "=q4=元帥的鎖甲護腿", "", "", "13005", "#alliance#", "30", "#wsg#" },
        { 29606, "INV_Boots_Plate_06", "=q4=元帥的鎖甲長靴", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvpra9#", "=q5=#pvps2#" },
        { 29598, "INV_Helmet_09", "=q3=少校的鎖甲頭盔", "", "", "4335", "#alliance#", "30", "#av#" },
        { 29599, "INV_Shoulder_04", "=q3=少校的鎖甲護肩", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 29596, "INV_Chest_Chain_16", "=q3=上尉騎士的鎖甲", "", "", "4590", "#alliance#", "30", "#ab#" },
        { 29595, "INV_Gauntlets_11", "=q3=中尉騎士的鎖甲護手", "", "", "2805", "#alliance#", "20", "#av#" },
        { 29597, "INV_Pants_09", "=q3=上尉騎士的鎖甲護腿", "", "", "4335", "#alliance#", "30", "#wsg#" },
        { 29594,"INV_Boots_07","=q3=中尉騎士的鎖甲護腿","", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh6#", "=q5=#pvps1#" },
        { 16578, "INV_Helmet_09", "=q4=督軍的鎖甲頭盔", "", "", "13005", "#horde#", "30", "#av#" },
        { 16580, "INV_Shoulder_29", "=q4=督軍的鎖甲肩鎧", "", "", "8415", "#horde#", "20", "#ab#" },
        { 16577, "INV_Chest_Chain_11", "=q4=督軍的鎖甲", "", "", "13770", "#horde#", "30", "#ab#" },
	{ 16574, "INV_Gauntlets_11", "=q4=將軍的鎖甲護手", "", "", "8415", "#horde#", "20", "#av#" },
	{ 16579, "INV_Pants_Mail_15", "=q4=將軍的鎖甲護腿", "", "", "13005", "#horde#", "30", "#wsg#" },
        { 16573, "INV_Boots_Plate_06", "=q4=將軍的鎖甲戰靴", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvprh6#", "=q5=#pvps2#" },
        { 23259, "INV_Helmet_09", "=q3=勇士的鎖甲戰盔", "", "", "4335", "#horde#", "30", "#av#" },
        { 23260, "INV_Shoulder_04", "=q3=勇士的鎖甲肩甲", "", "", "2805", "#horde#", "20", "#ab#" },
        { 22876, "INV_Chest_Chain_16", "=q3=軍團士兵的鎖甲上衣", "", "", "4590", "#horde#", "30", "#ab#" },
        { 22867, "INV_Gauntlets_11", "=q3=血衛士的鎖甲手套", "", "", "2805", "#horde#", "20", "#av#" },
        { 22887, "INV_Pants_09", "=q3=軍團士兵的鎖甲腿甲", "", "", "4335", "#horde#", "30", "#wsg#" },
        { 22857,"INV_Boots_07","=q3=血衛士的鎖甲護腿","", "", "2805", "#horde#", "20", "#ab#" },
        };

    PVPWarlock = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea7#", "=q5=#pvps1#" },
        { 17578, "INV_Helmet_24", "=q4=戰場元帥的頭冠", "", "", "13005", "#alliance#", "30", "#av#" },
        { 17580, "INV_Shoulder_02", "=q4=戰場元帥的鬼紋護肩", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 17581, "INV_Chest_Cloth_09", "=q4=戰場元帥的鬼紋長袍", "", "", "13770", "#alliance#", "30", "#ab#" },
	{ 17584, "INV_Gauntlets_14", "=q4=元帥的鬼紋手套", "", "", "8415", "#alliance#", "20", "#av#" },
	{ 17579, "INV_Pants_Cloth_09", "=q4=元帥的鬼紋護腿", "", "", "13005", "#alliance#", "30", "#wsg#" },
        { 17583, "INV_Boots_07", "=q4=元帥的鬼紋長靴", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
	{ 0, "INV_BannerPVP_02", "=q6=#pvpra7#", "=q5=#pvps2#" },
        { 23310, "INV_Helmet_08", "=q3=少校的鬼紋頭環", "", "", "4335", "#alliance#", "30", "#av#" },
        { 23311, "INV_Shoulder_01", "=q3=少校的鬼紋肩甲", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 23297, "INV_Chest_Leather_01", "=q3=上尉騎士的鬼紋外衣", "", "", "4590", "#alliance#", "30", "#ab#" },
        { 23282, "INV_Gauntlets_19", "=q3=中尉騎士的鬼紋裹手", "", "", "2805", "#alliance#", "20", "#av#" },
        { 23296, "INV_Pants_06", "=q3=上尉騎士的鬼紋長褲", "", "", "4335", "#alliance#", "30", "#wsg#" },
        { 23283, "INV_Boots_05", "=q3=中尉騎士的鬼紋便鞋", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh7#", "=q5=#pvps1#" },
        { 17591, "INV_Helmet_08", "=q4=督軍的鬼紋罩帽", "", "", "13005", "#horde#", "30", "#av#" },
        { 17590, "INV_Shoulder_19", "=q4=督軍的鬼紋襯肩", "", "", "8415", "#horde#", "20", "#ab#" },
        { 17592, "INV_Chest_Leather_01", "=q4=督軍的鬼紋長袍", "", "", "13770", "#horde#", "30", "#ab#" },
	{ 17588, "INV_Gauntlets_19", "=q4=將軍的鬼紋手套", "", "", "8415", "#horde#", "20", "#av#" },
	{ 17593, "INV_Pants_07", "=q4=將軍的鬼紋短褲", "", "", "13005", "#horde#", "30", "#wsg#" },
        { 17586, "INV_Boots_05", "=q4=將軍的鬼紋長靴", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
	{ 0, "INV_BannerPVP_01", "=q6=#pvprh7#", "=q5=#pvps2#" },
        { 23255, "INV_Helmet_08", "=q3=勇士的鬼紋頭環", "", "", "4335", "#horde#", "30", "#av#" },
        { 23256, "INV_Shoulder_01", "=q3=勇士的鬼紋襯肩", "", "", "2805", "#horde#", "20", "#ab#" },
        { 22884, "INV_Chest_Leather_01", "=q3=軍團士兵的鬼紋外套", "", "", "4590", "#horde#", "30", "#ab#" },
        { 22865, "INV_Gauntlets_19", "=q3=血衛士的鬼紋裹手", "", "", "2805", "#horde#", "20", "#av#" },
        { 22881, "INV_Pants_06", "=q3=軍團士兵的鬼紋護褲", "", "", "4335", "#horde#", "30", "#wsg#" },
        { 22855, "INV_Boots_05", "=q3=血衛士的鬼紋便鞋", "", "", "2805", "#horde#", "20", "#ab#" },
        };
        
    PVPWarrior = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea8#", "=q5=#pvps1#" },
        { 16478, "INV_Helmet_05", "=q4=戰場元帥的鎧甲頭盔", "", "", "13005", "#alliance#", "30", "#av#" },
        { 16480, "INV_Shoulder_20", "=q4=戰場元帥的鎧甲護肩", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 16477, "INV_Chest_Plate03", "=q4=戰場元帥的鎧甲", "", "", "13770", "#alliance#", "30", "#ab#" },
	{ 16484, "INV_Gauntlets_29", "=q4=元帥的鎧甲護手", "", "", "8415", "#alliance#", "20", "#av#" },
	{ 16479, "INV_Pants_04", "=q4=元帥的鎧甲護腿", "", "", "13005", "#alliance#", "30", "#wsg#" },
        { 16483, "INV_Boots_Plate_09", "=q4=元帥的鎧甲戰靴", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvpra8#", "=q5=#pvps2#" },
        { 23314, "INV_Helmet_09", "=q3=少校的鎧甲戰盔", "", "", "4335", "#alliance#", "30", "#av#" },
        { 23315, "INV_Shoulder_11", "=q3=少校的鎧甲護肩", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 23300, "INV_Chest_Plate16", "=q3=上尉騎士的鎧甲護胸", "", "", "4590", "#alliance#", "30", "#ab#" },
        { 23286, "INV_Gauntlets_26", "=q3=上尉騎士的鎧甲護手", "", "", "2805", "#alliance#", "20", "#av#" },
        { 23301, "INV_Pants_06", "=q3=上尉騎士的鎧甲護腿", "", "", "4335", "#alliance#", "30", "#wsg#" },
        { 23287, "INV_Boots_Plate_09", "=q3=上尉騎士的鎧甲脛甲", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh8#", "=q5=#pvps1#" },
        { 16542, "INV_Helmet_09", "=q4=督軍的鎧甲頭盔", "", "", "13005", "#horde#", "30", "#av#" },
        { 16544, "INV_Shoulder_11", "=q4=督軍的鎧甲護肩", "", "", "8415", "#horde#", "20", "#ab#" },
        { 16541, "INV_Chest_Plate16", "=q4=督軍的鎧甲", "", "", "13770", "#horde#", "30", "#ab#" },
	{ 16548, "INV_Gauntlets_10", "=q4=將軍的鎧甲護手", "", "", "8415", "#horde#", "20", "#av#" },
	{ 16543, "INV_Pants_04", "=q4=將軍的鎧甲護腿", "", "", "13005", "#horde#", "30", "#wsg#" },
        { 16545, "INV_Boots_Plate_04", "=q4=將軍的鎧甲戰靴", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvprh8#", "=q5=#pvps2#" },
        { 23244, "INV_Helmet_09", "=q3=勇士的鎧甲戰盔", "", "", "4335", "#horde#", "30", "#av#" },
        { 23243, "INV_Shoulder_11", "=q3=勇士的鎧甲護肩", "", "", "2805", "#horde#", "20", "#ab#" },
        { 22872, "INV_Chest_Plate16", "=q3=軍團士兵的胸鎧", "", "", "4590", "#horde#", "30", "#ab#" },
        { 22868, "INV_Gauntlets_26", "=q3=血衛士的鎧甲護手", "", "", "2805", "#horde#", "20", "#av#" },
        { 22873, "INV_Pants_06", "=q3=軍團士兵的腿鎧", "", "", "4335", "#horde#", "30", "#wsg#" },
        { 22858, "INV_Boots_Plate_09", "=q3=血衛士的鎧甲護腿", "", "", "2805", "#horde#", "20", "#ab#" },
	  };

-- PvP Level 70 Rare Sets

    PVP70Druid1 = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp701_1_a#", "" },
        { 28619, "INV_Helmet_30", "=q3=總元帥的龍皮頭盔", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28622, "INV_Shoulder_12", "=q3=總元帥的龍皮護肩", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28623, "INV_Chest_Leather_03", "=q3=總元帥的龍皮外衣", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28618, "INV_Gauntlets_28", "=q3=總元帥的龍皮手套", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28620, "INV_Pants_Cloth_05", "=q3=總元帥的龍皮護腿", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvp701_2_a#", "" },
        { 28720, "INV_Helmet_30", "=q3=總元帥的火龍皮頭盔", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28722, "INV_Shoulder_12", "=q3=總元帥的火龍皮護肩", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28723, "INV_Chest_Leather_03", "=q3=總元帥的火龍皮外衣", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28719, "INV_Gauntlets_28", "=q3=總元帥的火龍皮手套", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28721, "INV_Pants_Cloth_05", "=q3=總元帥的火龍皮護腿", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp701_1_h#", "" },
        { 28812, "INV_Helmet_30", "=q3=高階督軍的龍皮頭盔", "", "", "16065", "#horde#", "30", "#av#" },
        { 28814, "INV_Shoulder_12", "=q3=高階督軍的龍皮護肩", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28815, "INV_Chest_Leather_03", "=q3=高階督軍的龍皮外衣", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28811, "INV_Gauntlets_28", "=q3=高階督軍的龍皮手套", "", "", "10098", "#horde#", "20", "#av#" },
        { 28813, "INV_Pants_Cloth_05", "=q3=高階督軍的龍皮護腿", "", "", "16065", "#horde#", "30", "#wsg#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp701_2_h#", "" },
        { 28872, "INV_Helmet_30", "=q3=高階督軍的火龍皮頭盔", "", "", "16065", "#horde#", "30", "#av#" },
        { 28874, "INV_Shoulder_12", "=q3=高階督軍的火龍皮護肩", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28875, "INV_Chest_Leather_03", "=q3=高階督軍的火龍皮外衣", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28871, "INV_Gauntlets_28", "=q3=高階督軍的火龍皮手套", "", "", "10098", "#horde#", "20", "#av#" },
        { 28873, "INV_Pants_Cloth_05", "=q3=高階督軍的火龍皮護腿", "", "", "16065", "#horde#", "30", "#wsg#" },
        };

    PVP70Druid2 = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp701_3_a#", "" },
        { 31590, "INV_Helmet_30", "=q3=總元帥的科多獸皮頭盔", "", "", "16065", "#alliance#", "30", "#av#" },
        { 31592, "INV_Shoulder_12", "=q3=總元帥的科多獸皮護肩", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 31593, "INV_Chest_Leather_03", "=q3=總元帥的科多獸皮外衣", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 31589, "INV_Gauntlets_28", "=q3=總元帥的科多獸皮手套", "", "", "10098", "#alliance#", "20", "#av#" },
        { 31591, "INV_Pants_Cloth_05", "=q3=總元帥的科多獸皮護腿", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp701_3_h#", "" },
        { 31585, "INV_Helmet_30", "=q3=高階督軍的科多獸皮頭盔", "", "", "16065", "#horde#", "30", "#av#" },
        { 31587, "INV_Shoulder_12", "=q3=高階督軍的科多獸皮護肩", "", "", "10098", "#horde#", "20", "#ab#" },
        { 31588, "INV_Chest_Leather_03", "=q3=高階督軍的科多獸皮外衣", "", "", "16524", "#horde#", "30", "#ab#" },
        { 31584, "INV_Gauntlets_28", "=q3=高階督軍的科多獸皮手套", "", "", "10098", "#horde#", "20", "#av#" },
        { 31586, "INV_Pants_Cloth_05", "=q3=高階督軍的科多獸皮護腿", "", "", "16065", "#horde#", "30", "#wsg#" },
        };
        
    PVP70Hunter = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp702_a#", "" },
        { 28615, "INV_Helmet_09", "=q3=總元帥的鍊甲頭盔", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28617, "INV_Shoulder_29", "=q3=總元帥的鍊甲護肩", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28613, "INV_Chest_Chain_11", "=q3=總元帥的鍊甲護甲", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28614, "INV_Gauntlets_11", "=q3=總元帥的鍊甲護手", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28616, "INV_Pants_Mail_15", "=q3=總元帥的鍊甲護腿", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp702_h#", "" },
        { 28807, "INV_Helmet_09", "=q3=高階督軍的鍊甲頭盔", "", "", "16065", "#horde#", "30", "#av#" },
        { 28809, "INV_Shoulder_29", "=q3=高階督軍的鍊甲護肩", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28805, "INV_Chest_Chain_11", "=q3=高階督軍的鍊甲護甲", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28806, "INV_Gauntlets_11", "=q3=高階督軍的鍊甲護手", "", "", "10098", "#horde#", "20", "#av#" },
        { 28808, "INV_Pants_Mail_15", "=q3=高階督軍的鍊甲護腿", "", "", "16065", "#horde#", "30", "#wsg#" },
        };
    
    PVP70Mage = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp703_a#", "" },
        { 28715, "INV_Helmet_08", "=q3=總元帥的絲質兜帽", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28714, "INV_Shoulder_19", "=q3=總元帥的絲質披肩", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28717, "INV_Chest_Leather_01", "=q3=總元帥的絲質衣飾", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28716, "INV_Gauntlets_19", "=q3=總元帥的絲質護手", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28718, "INV_Pants_07", "=q3=總元帥的絲質長褲", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp703_h#", "" },
        { 28867, "INV_Helmet_08", "=q3=高階督軍的絲質兜帽", "", "", "16065", "#horde#", "30", "#av#" },
        { 28866, "INV_Shoulder_19", "=q3=高階督軍的絲質披肩", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28869, "INV_Chest_Leather_01", "=q3=高階督軍的絲質衣飾", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28868, "INV_Gauntlets_19", "=q3=高階督軍的絲質護手", "", "", "10098", "#horde#", "20", "#av#" },
        { 28870, "INV_Pants_07", "=q3=高階督軍的絲質長褲", "", "", "16065", "#horde#", "30", "#wsg#" },
       	};

    PVP70Paladin1 = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp704_1_a#", "" },
        { 28681, "INV_Helmet_22", "=q3=總元帥的片甲頭盔", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28683, "INV_Shoulder_22", "=q3=總元帥的片甲護肩", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28679, "INV_Chest_Plate05", "=q3=總元帥的片甲護胸", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28680, "INV_Gauntlets_29", "=q3=總元帥的片甲護手", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28724, "INV_Pants_Plate_17", "=q3=總元帥的片甲護腿", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvp704_2_a#", "" },
        { 28711, "INV_Helmet_22", "=q3=總元帥的鱗片頭盔", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28713, "INV_Shoulder_22", "=q3=總元帥的鱗片護肩", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28709, "INV_Chest_Plate05", "=q3=總元帥的鱗片護胸", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28710, "INV_Gauntlets_29", "=q3=總元帥的鱗片護手", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28712, "INV_Pants_Plate_17", "=q3=總元帥的鱗片護腿", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp704_1_h#", "" },
        { 28833, "INV_Helmet_22", "=q3=高階督軍的片甲頭盔", "", "", "16065", "#horde#", "30", "#av#" },
        { 28835, "INV_Shoulder_22", "=q3=高階督軍的片甲護肩", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28831, "INV_Chest_Plate05", "=q3=高階督軍的片甲護胸", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28832, "INV_Gauntlets_29", "=q3=高階督軍的片甲護手", "", "", "10098", "#horde#", "20", "#av#" },
        { 28834, "INV_Pants_Plate_17", "=q3=高階督軍的片甲護腿", "", "", "16065", "#horde#", "30", "#wsg#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp704_2_h#", "" },
        { 28863, "INV_Helmet_22", "=q3=高階督軍的鱗片頭盔", "", "", "16065", "#horde#", "30", "#av#" },
        { 28865, "INV_Shoulder_22", "=q3=高階督軍的鱗片護肩", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28861, "INV_Chest_Plate05", "=q3=高階督軍的鱗片護胸", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28862, "INV_Gauntlets_29", "=q3=高階督軍的鱗片護手", "", "", "10098", "#horde#", "20", "#av#" },
        { 28864, "INV_Pants_Plate_17", "=q3=高階督軍的鱗片護腿", "", "", "16065", "#horde#", "30", "#wsg#" },
        };

    PVP70Paladin2 = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp704_3_a#", "" },
        { 31632, "INV_Helmet_22", "=q3=總元帥的裝飾頭盔", "", "", "16065", "#alliance#", "30", "#av#" },
        { 31634, "INV_Shoulder_22", "=q3=總元帥的裝飾護肩", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 31630, "INV_Chest_Plate05", "=q3=總元帥的裝飾胸甲", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 31631, "INV_Gauntlets_29", "=q3=總元帥的裝飾手套", "", "", "10098", "#alliance#", "20", "#av#" },
        { 31633, "INV_Pants_Plate_17", "=q3=總元帥的裝飾護腿", "", "", "16065", "#alliance#", "30", "#wsg#" },     
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp704_3_h#", "" },
        { 31637, "INV_Helmet_22", "=q3=高階督軍的裝飾護頭", "", "", "16065", "#horde#", "30", "#av#" },
        { 31639, "INV_Shoulder_22", "=q3=高階督軍的裝飾護肩", "", "", "10098", "#horde#", "20", "#ab#" },
        { 31635, "INV_Chest_Plate05", "=q3=高階督軍的裝飾胸甲", "", "", "16524", "#horde#", "30", "#ab#" },
        { 31636, "INV_Gauntlets_29", "=q3=高階督軍的裝飾手套", "", "", "10098", "#horde#", "20", "#av#" },
        { 31638, "INV_Pants_Plate_17", "=q3=高階督軍的裝飾護腿", "", "", "16065", "#horde#", "30", "#wsg#" },         };

    PVP70Priest = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp705_1_a#", "" },
        { 28705, "INV_Helmet_30", "=q3=總元帥的緞子兜帽", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28707, "INV_Shoulder_02", "=q3=總元帥的緞子披風", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28708, "INV_Chest_Cloth_43", "=q3=總元帥的緞子長袍", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28704, "INV_Gauntlets_15", "=q3=總元帥的緞子手套", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28706, "INV_Pants_Cloth_05", "=q3=總元帥的緞子護腿", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvp705_2_a#", "" },
        { 31622, "INV_Helmet_30", "=q3=總元帥的月布斗篷", "", "", "16065", "#alliance#", "30", "#av#" },
        { 31624, "INV_Shoulder_02", "=q3=總元帥的月布肩甲", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 31625, "INV_Chest_Cloth_43", "=q3=總元帥的月布法衣", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 31620, "INV_Gauntlets_15", "=q3=總元帥的月布手套", "", "", "10098", "#alliance#", "20", "#av#" },
        { 31623, "INV_Pants_Cloth_05", "=q3=總元帥的月布護腿", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp705_1_h#", "" },
        { 28857, "INV_Helmet_30", "=q3=高階督軍的緞子兜帽", "", "", "16065", "#horde#", "30", "#av#" },
        { 28859, "INV_Shoulder_02", "=q3=高階督軍的緞子披風", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28860, "INV_Chest_Cloth_43", "=q3=高階督軍的緞子長袍", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28856, "INV_Gauntlets_15", "=q3=高階督軍的緞子手套", "", "", "10098", "#horde#", "20", "#av#" },
        { 28858, "INV_Pants_Cloth_05", "=q3=高階督軍的緞子護腿", "", "", "16065", "#horde#", "30", "#wsg#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp705_2_h#", "" },
        { 31626, "INV_Helmet_30", "=q3=高階督軍的月布兜帽", "", "", "16065", "#horde#", "30", "#av#" },
        { 31628, "INV_Shoulder_02", "=q3=高階督軍的月布護肩", "", "", "10098", "#horde#", "20", "#ab#" },
        { 31629, "INV_Chest_Cloth_43", "=q3=高階督軍的月布法衣", "", "", "16524", "#horde#", "30", "#ab#" },
        { 31621, "INV_Gauntlets_15", "=q3=高階督軍的月布手套", "", "", "10098", "#horde#", "20", "#av#" },
        { 31627, "INV_Pants_Cloth_05", "=q3=高階督軍的月布護腿", "", "", "16065", "#horde#", "30", "#wsg#" },
        };

    PVP70Rogue = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp706_a#", "" },
        { 28685, "INV_Helmet_30", "=q3=總元帥的皮頭盔", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28687, "INV_Shoulder_12", "=q3=總元帥的皮護肩", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28688, "INV_Chest_Leather_03", "=q3=總元帥的皮外衣", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28684, "INV_Gauntlets_28", "=q3=總元帥的皮手套", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28686, "INV_Pants_Cloth_05", "=q3=總元帥的皮護腿", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp706_h#", "" },
        { 28837, "INV_Helmet_30", "=q3=高階督軍的皮甲頭盔", "", "", "16065", "#horde#", "30", "#av#" },
        { 28839, "INV_Shoulder_12", "=q3=高階督軍的皮甲護肩", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28840, "INV_Chest_Leather_03", "=q3=高階督軍的皮甲外衣", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28836, "INV_Gauntlets_28", "=q3=高階督軍的皮甲手套", "", "", "10098", "#horde#", "20", "#av#" },
        { 28838, "INV_Pants_Cloth_05", "=q3=高階督軍的皮甲護腿", "", "", "16065", "#horde#", "30", "#wsg#" },
        };

    PVP70Shaman1 = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp707_1_a#", "" },
        { 28691, "INV_Helmet_09", "=q3=總元帥的鎖鏈頭盔", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28693, "INV_Shoulder_29", "=q3=總元帥的鎖鏈護肩", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28689, "INV_Chest_Chain_11", "=q3=總元帥的鎖鏈護甲", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28690, "INV_Gauntlets_11", "=q3=總元帥的鎖鏈護手", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28692, "INV_Pants_Mail_15", "=q3=總元帥的鎖鏈護腿", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvp707_2_a#", "" },
        { 28696, "INV_Helmet_09", "=q3=總元帥的鎖甲頭盔", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28698, "INV_Shoulder_29", "=q3=總元帥的鎖甲護肩", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28694, "INV_Chest_Chain_11", "=q3=總元帥的鎖甲護甲", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28695, "INV_Gauntlets_11", "=q3=總元帥的鎖甲護手", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28697, "INV_Pants_Mail_15", "=q3=總元帥的鎖甲護腿", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp707_1_h#", "" },
        { 28843, "INV_Helmet_09", "=q3=高階督軍的鎖鏈頭盔", "", "", "16065", "#horde#", "30", "#av#" },
        { 28845, "INV_Shoulder_29", "=q3=高階督軍的鎖鏈護肩", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28841, "INV_Chest_Chain_11", "=q3=高階督軍的鎖鏈護甲", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28842, "INV_Gauntlets_11", "=q3=高階督軍的鎖鏈護手", "", "", "10098", "#horde#", "20", "#av#" },
        { 28844, "INV_Pants_Mail_15", "=q3=高階督軍的鎖鏈護腿", "", "", "16065", "#horde#", "30", "#wsg#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp707_2_h#", "" },
        { 28848, "INV_Helmet_09", "=q3=高階督軍的鎖甲頭盔", "", "", "16065", "#horde#", "30", "#av#" },
        { 28850, "INV_Shoulder_29", "=q3=高階督軍的鎖甲護肩", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28846, "INV_Chest_Chain_11", "=q3=高階督軍的鎖甲護甲", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28847, "INV_Gauntlets_11", "=q3=高階督軍的鎖甲護手", "", "", "10098", "#horde#", "20", "#av#" },
        { 28849, "INV_Pants_Mail_15", "=q3=高階督軍的鎖甲護腿", "", "", "16065", "#horde#", "30", "#wsg#" },
        };
        
    PVP70Shaman2 = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp707_3_a#", "" },
        { 31642, "INV_Helmet_09", "=q3=總元帥的環型鎖甲護頭", "", "", "16065", "#alliance#", "30", "#av#" },
        { 31644, "INV_Shoulder_29", "=q3=總元帥的環型鎖甲護肩", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 31640, "INV_Chest_Chain_11", "=q3=總元帥的環型鎖甲護胸", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 31641, "INV_Gauntlets_11", "=q3=總元帥的環型鎖甲手套", "", "", "10098", "#alliance#", "20", "#av#" },
        { 31643, "INV_Pants_Mail_15", "=q3=總元帥的環型鎖甲護腿", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp707_3_h#", "" },
        { 31648, "INV_Helmet_09", "=q3=高階督軍的環型鎖甲護頭", "", "", "16065", "#horde#", "30", "#av#" },
        { 31650, "INV_Shoulder_29", "=q3=高階督軍的環型鎖甲護肩", "", "", "10098", "#horde#", "20", "#ab#" },
        { 31646, "INV_Chest_Chain_11", "=q3=高階督軍的環型鎖甲護胸", "", "", "16524", "#horde#", "30", "#ab#" },
        { 31647, "INV_Gauntlets_11", "=q3=高階督軍的環型鎖甲手套", "", "", "10098", "#horde#", "20", "#av#" },
        { 31649, "INV_Pants_Mail_15", "=q3=高階督軍的環型鎖甲護腿", "", "", "16065", "#horde#", "30", "#wsg#" },
        };

    PVP70Warlock = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp708_a#", "" },
        { 28625, "INV_Helmet_30", "=q3=總元帥的恐織兜帽", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28627, "INV_Shoulder_02", "=q3=總元帥的恐織披風", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28628, "INV_Chest_Cloth_43", "=q3=總元帥的恐織長袍", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28624, "INV_Gauntlets_15", "=q3=總元帥的恐織手套", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28626, "INV_Pants_Cloth_05", "=q3=總元帥的恐織護腿", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
	{ 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp708_h#", "" },
        { 28818, "INV_Helmet_30", "=q3=高階督軍的恐織兜帽", "", "", "16065", "#horde#", "30", "#av#" },
        { 28820, "INV_Shoulder_02", "=q3=高階督軍的恐織披風", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28821, "INV_Chest_Cloth_43", "=q3=高階督軍的恐織長袍", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28817, "INV_Gauntlets_15", "=q3=高階督軍的恐織手套", "", "", "10098", "#horde#", "20", "#av#" },
        { 28819, "INV_Pants_Cloth_05", "=q3=高階督軍的恐織護腿", "", "", "16065", "#horde#", "30", "#wsg#" },
        };

    PVP70Warrior = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp709_a#", "" },
        { 28701, "INV_Helmet_22", "=q3=總元帥的鎧甲頭盔", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28703, "INV_Shoulder_22", "=q3=總元帥的鎧甲護肩", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28699, "INV_Chest_Plate05", "=q3=總元帥的鎧甲護胸", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28700, "INV_Gauntlets_29", "=q3=總元帥的鎧甲護手", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28702, "INV_Pants_Plate_17", "=q3=總元帥的鎧甲護腿", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp709_h#", "" },
        { 28853, "INV_Helmet_22", "=q3=高階督軍的鎧甲頭盔", "", "", "16065", "#horde#", "30", "#av#" },
        { 28855, "INV_Shoulder_22", "=q3=高階督軍的鎧甲護肩", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28851, "INV_Chest_Plate05", "=q3=高階督軍的鎧甲護胸", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28852, "INV_Gauntlets_29", "=q3=高階督軍的鎧甲護手", "", "", "10098", "#horde#", "20", "#av#" },
        { 28854, "INV_Pants_Plate_17", "=q3=高階督軍的鎧甲護腿", "", "", "16065", "#horde#", "30", "#wsg#" },
        };

-- Legendary Items

    Legendaries = {
        { 22736, "INV_Sword_61", "=q5=安多尼蘇斯 ,靈魂切割者", "=q1=#m26#: =ds=#h3#, #w10#" },
        { 19019, "INV_Sword_39", "=q5=雷霆之怒，逐風者的祝福之劍", "=ds=#h1#, #w10#" },
        { 17182, "INV_Hammer_Unique_Sulfuras", "=q5=薩弗拉斯，炎魔拉格納羅斯之手", "=ds=#h2#, #w6#" },
        { 21176, "INV_Misc_QirajiCrystal_05", "=q5=黑色其拉共鳴水晶", "=ds=#e12#" },
        { 0,"","","" },
        { 22632, "INV_Staff_Medivh", "=q5=阿泰絲,守護者之杖", "=ds=#w9#, =q1=#m1# =ds=#c1#"},
        { 22589, "INV_Staff_Medivh", "=q5=阿泰絲,守護者之杖", "=ds=#w9#, =q1=#m1# =ds=#c3#"},
        { 22631, "INV_Staff_Medivh", "=q5=阿泰絲,守護者之杖", "=ds=#w9#, =q1=#m1# =ds=#c5#"},
        { 22630, "INV_Staff_Medivh", "=q5=阿泰絲,守護者之杖", "=ds=#w9#, =q1=#m1# =ds=#c8#"},
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 32837, "INV_Weapon_Glave_01", "=q5=埃辛諾斯戰刃", "=ds=#h3#, #w10#, =q1=#m1# =ds=#c9#, #c6#" },
        { 32838, "INV_Weapon_Glave_01", "=q5=埃辛諾斯戰刃", "=ds=#h4#, #w10#, =q1=#m1# =ds=#c9#, #c6#" },
        { 0,"","","" },
        { 30312, "INV_Weapon_Shortblade_47", "=q5=無窮之劍", "=q1=#m26#: =ds=#h1#, #w4#" },
        { 30311, "INV_Sword_69", "=q5=偏斜切割者", "=q1=#m26#: =ds=#h1#, #w10#" },
        { 30317, "INV_Mace_48", "=q5=宇宙灌溉者", "=q1=#m26#: =ds=#h3#, #w6#" },
        { 30316, "INV_Axe_68", "=q5=毀滅", "=q1=#m26#: =ds=#h2#, #w1#" },
        { 30313, "INV_Staff_52", "=q5=瓦解之杖", "=q1=#m26#: =ds=#w9#" },
        { 30318, "INV_Weapon_Bow_19", "=q5=虛空之絃長弓", "=q1=#m26#: =ds=#w2#, =q1=#m1# =ds=#c2#" },
        { 30314, "INV_Shield_31", "=q5=相位堡壘", "=q1=#m26#: =ds=#w8#" },
        { 30319, "Spell_Arcane_Starfire", "=q5=地獄之刺", "=q1=#m26#: =ds=#w17#" },
        };

-- Heroic Mode Token Rewards
        
    HardModeToken = {
        { 29368, "INV_Jewelry_Necklace_30Naxxramas", "=q4=法力奔騰墜飾", "=ds=#s2#", "", "25", "#heroic#" },
        { 29374, "INV_Jewelry_Necklace_31", "=q4=永恆希望之鍊", "=ds=#s2#", "", "25", "#heroic#" },
        { 29381, "INV_Jewelry_Necklace_04", "=q4=邪惡意圖項圈", "=ds=#s2#", "", "25", "#heroic#" },
        { 29386, "INV_Jewelry_Necklace_AhnQiraj_03", "=q4=狂熱項鏈", "=ds=#s2#", "", "25", "#heroic#" },
        { 0,"","","" },
        { 29367, "INV_Jewelry_Ring_56", "=q4=隱秘夢境之戒", "=ds=#s13#", "", "25", "#heroic#" },
        { 29373, "INV_Jewelry_Ring_53Naxxramas", "=q4=光圈指環", "=ds=#s13#", "", "25", "#heroic#" },
        { 29379, "INV_jewelry_ring_AhnQiraj_01", "=q4=阿拉希督軍之戒", "=ds=#s13#", "", "25", "#heroic#" },
        { 29384, "INV_Jewelry_Ring_46", "=q4=堅固之力指環", "=ds=#s13#", "", "25", "#heroic#" },
        { 0,"","","" },
        { 29370, "INV_Weapon_ShortBlade_23", "=q4=銀色弦月塑像", "=ds=#s14#", "", "41", "#heroic#" },
        { 29376, "INV_ValentinePerfumeBottle", "=q4=烈士精華", "=ds=#s14#", "", "41", "#heroic#" },
        { 29383, "INV_Misc_MonsterScales_15", "=q4=嗜血胸針", "=ds=#s14#", "", "41", "#heroic#" },
        { 29387, "INV_Battery_02", "=q4=諾姆瑞根自動阻擋機器人 600", "=ds=#s14#", "", "41", "#heroic#" },
        { 0,"","","" },
        { 29273, "INV_Misc_Bag_10_Green", "=q4=卡德加的背包", "=ds=#s15#", "", "25", "#heroic#" },
        { 29271, "INV_Offhand_OutlandRaid_02", "=q4=卡雷苟斯護符", "=ds=#s15#", "", "25", "#heroic#" },
        { 29270, "Spell_Fire_SealOfFire", "=q4=火舌封印", "=ds=#s15#", "", "25", "#heroic#" },
        { 29269, "INV_Misc_Bone_01", "=q4=薩菲隆之翼骨", "=ds=#s15#", "", "25", "#heroic#" },
        { 29274, "INV_Potion_75", "=q4=天堂之淚", "=ds=#s15#", "", "25", "#heroic#" },
        { 29272, "INV_Misc_Orb_04", "=q4=嗜魂者寶珠", "=ds=#s15#", "", "25", "#heroic#" },
        { 0,"","","" },
        { 29390, "INV_Relics_IdolofHealth", "=q4=繁花石像", "", "", "15", "#heroic#" },
        { 29388, "INV_Relics_LibramofHope", "=q4=悔悟聖契", "", "", "15", "#heroic#" },
        { 29389, "INV_Elemental_Primal_Earth", "=q4=震地圖騰", "", "", "15", "#heroic#" },
        { 0,"","","" },
        { 23572, "INV_Elemental_Primal_Nether", "=q3=原始地獄", "=ds=#e28#", "", "10", "#heroic#" },
        { 0,"","","" },
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#m17#" },
        };
        
    HardModeToken2 = {
        { 0, "INV_Box_01", "=q6=#a1#", "" },
        { 30762, "INV_Chest_Cloth_18", "=q4=地獄火織長袍", "=ds=#a1#, #s5#", "", "30", "#heroic#" },
        { 30764, "INV_Gauntlets_26", "=q4=地獄火織手套", "=ds=#a1#, #s9#", "", "20", "#heroic#" },
        { 30761, "INV_Pants_06", "=q4=地獄火織護腿", "=ds=#a1#, #s11#", "", "30", "#heroic#" },
        { 30763, "INV_Boots_02", "=q4=地獄火織長靴", "=ds=#a1#, #s12#", "", "20", "#heroic#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#a2#", "" },
        { 30776, "INV_Chest_Leather_07", "=q4=地獄硬化胸甲", "=ds=#a2#, #s5#", "", "30", "#heroic#" },
        { 30780, "INV_Gauntlets_26", "=q4=地獄硬化手套", "=ds=#a2#, #s9#", "", "20", "#heroic#" },
        { 30778, "INV_Pants_Leather_18", "=q4=地獄硬化護腿", "=ds=#a2#, #s11#", "", "30", "#heroic#" },
        { 30779, "INV_Boots_07", "=q4=地獄硬化長靴", "=ds=#a2#, #s12#", "", "20", "#heroic#" },
        { 0,"","","" },
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#m17#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#a3#", "" },
        { 30773, "INV_Chest_Plate08", "=q4=地獄鍛造鎖甲", "=ds=#a3#, #s5#", "", "30", "#heroic#" },
        { 30774, "INV_Gauntlets_10", "=q4=地獄鍛造手套", "=ds=#a3#, #s9#", "", "20", "#heroic#" },
        { 30772, "INV_Pants_Mail_14", "=q4=地獄鍛造護腿", "=ds=#a3#, #s11#", "", "30", "#heroic#" },
        { 30770, "INV_Boots_Chain_08", "=q4=地獄鍛造長靴", "=ds=#a3#, #s12#", "", "20", "#heroic#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#a4#", "" },
        { 30769, "INV_Chest_Plate08", "=q4=地獄鍛鍊胸甲", "=ds=#a4#, #s5#", "", "30", "#heroic#" },
        { 30767, "INV_Gauntlets_22", "=q4=地獄鍛鍊護手", "=ds=#a4#, #s9#", "", "20", "#heroic#" },
        { 30766, "INV_Pants_04", "=q4=地獄鍛鍊護腿", "=ds=#a4#, #s11#", "", "30", "#heroic#" },
        { 30768, "INV_Boots_Chain_08", "=q4=地獄鍛鍊長靴", "=ds=#a4#, #s12#", "", "20", "#heroic#" },
        };
        
    HardModeToken3 = {
        { 0, "INV_Box_01", "=q6=#s1#", "" },
        { 32089, "INV_Helmet_30", "=q4=禁法者兜帽", "=ds=#a1#, #s1#", "", "50", "#heroic#" },
        { 32090, "INV_Helmet_30", "=q4=那魯祈福兜帽", "=ds=#a1#, #s1#", "", "50", "#heroic#" },
        { 32088, "INV_Helmet_38", "=q4=怒獸者兜帽", "=ds=#a2#, #s1#", "", "50", "#heroic#" },
        { 32087, "INV_Helmet_73", "=q4=欺詐者面罩", "=ds=#a2#, #s1#", "", "50", "#heroic#" },
        { 32086, "INV_Helmet_69", "=q4=風暴大師的頭盔", "=ds=#a3#, #s1#", "", "50", "#heroic#" },
        { 32085, "INV_Helmet_72", "=q4=扭曲行者頭盔", "=ds=#a3#, #s1#", "", "50", "#heroic#" },
        { 32083, "INV_Helmet_01", "=q4=堅定面罩", "=ds=#a4#, #s1#", "", "50", "#heroic#" },
        { 32084, "INV_Helmet_16", "=q4=堅定勇士頭盔", "=ds=#a4#, #s1#", "", "50", "#heroic#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#m17#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#s4#", "" },
        { 29369, "INV_Misc_Cape_16", "=q4=移形機率披風", "=ds=#s4#", "", "25", "#heroic#" },
        { 29375, "INV_Misc_Cape_02", "=q4=主教的披風", "=ds=#s4#", "", "25", "#heroic#" },
        { 29382, "INV_Misc_Cape_18", "=q4=血騎士戰爭披風", "=ds=#s4#", "", "25", "#heroic#" },
        { 29385, "INV_Misc_Cape_Naxxramas_02", "=q4=旅行防禦者披風", "=ds=#s4#", "", "25", "#heroic#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#w8#", "" },
        { 29268, "INV_Shield_37", "=q4=麥索瑞爾榮譽之盾", "=ds=#w8#", "", "33", "#heroic#" },
        { 29267, "INV_Shield_33", "=q4=聖光背負者的信念盾牌", "=ds=#w8#", "", "33", "#heroic#" },
        { 29266, "INV_Shield_33", "=q4=寇達拉的藍色盾牌", "=ds=#w8#", "", "33", "#heroic#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#w4#", "" },
        { 29275, "INV_knife_1h_stratholme_d_03", "=q4=灼熱日光之刃", "=ds=#h4# #w4#", "", "50", "#heroic#" },
        };

-- Rare Mounts
        
    RareMounts = {
        { 21176, "INV_Misc_QirajiCrystal_05", "=q5=黑色其拉共鳴水晶", "=q2=#m4#" },
	{ 0,"","","" },
        { 13335, "Ability_Mount_Undeadhorse", "=q4=死亡軍馬的韁繩", "=q2=#n52#, =q1=#z6#", "0.10%" },
        { 19872, "Ability_Mount_Raptor", "=q4=拉札希迅猛龍",   "=q2=#n33#, =q1=#z8#", "0.43%" },
        { 19902, "Ability_Mount_JungleTiger", "=q4=迅捷祖利安猛虎", "=q2=#n28#, =q1=#z8#", " 0.70%" },
        { 13086, "Ability_Mount_PinkTiger", "=q4=冬泉霜刃豹韁繩", "=ds=#e12#" },
	{ 33225, "Ability_Mount_WhiteTiger", "=q4=Reins of the Swift Spectral Tiger", "=q2=#m24#" },
        { 23720, "Ability_Hunter_Pet_Turtle", "=q4=烏龜坐騎", "=q2=#m24#" },
	{ 0,"","","" },
        { 21218, "INV_Misc_QirajiCrystal_04", "=q3=藍色其拉共鳴水晶", "=q2=#n11#,  =q1=#z11#", "10.91%" },
        { 21323, "INV_Misc_QirajiCrystal_03", "=q3=綠色其拉共鳴水晶", "=q2=#n11#,  =q1=#z11#", "11.77%" },
        { 21321, "INV_Misc_QirajiCrystal_02", "=q3=紅色其拉共鳴水晶", "=q2=#n11#,  =q1=#z11#", "1.32%" },
        { 21324, "INV_Misc_QirajiCrystal_01", "=q3=黃色其拉共鳴水晶", "=q2=#n11#,  =q1=#z11#", "12.64%" },
	{ 0,"","","" },
	{ 0,"","","" },
        { 30609, "Ability_Mount_NetherDrakeElite", "=q4=迅捷虛空雛龍", "=q2=#m25#" },
	{ 0,"","","" },
        { 32458, "Inv_Misc_Summerfest_Brazierorange", "=q4=歐爾骨灰", "=q2=#n59#, =q1=#z19#" },
        { 30480, "Ability_Mount_Dreadsteed", "=q4=熾炎戰馬韁繩", "=q2=#n53#, =q1=#z12#", "0.25%" },
        { 32768, "INV-Mount_Raven_54", "=q4=Reins of the Raven Lord", "=q2=#n58#, =q1=#z16#" },
        };

-- Tabards
    
    Tabards1 = {
        { 23705, "INV_Misc_TabardPVP_02", "=q4=烈焰徽章", "=ds=#s7#, =q1=#m24#" },
        { 23709, "INV_Misc_TabardPVP_01", "=q4=冰霜徽章", "=ds=#s7#, =q1=#m24#" },
        { 31404, "INV_Shirt_15", "=q2=綠色伊利達瑞戰利大衣", "=ds=#s7#, =q1=#m4#" },
        { 31405, "INV_Shirt_15", "=q2=伊利達瑞紫色勝利短衣", "=ds=#s7#, =q1=#m4#" },
        { 23192, "INV_Misc_Cape_18", "=q2=血色十字軍大衣", "=ds=#s7#", "0.48%" },
        { 0,"","","" },
        { 31779, "INV_Shirt_GuildTabard_01", "=q1=奧多爾大衣", "=ds=#s7#" },
        { 31804, "INV_Shirt_GuildTabard_01", "=q1=塞納里奧遠征外衣", "=ds=#s7#" },
        { 23999, "INV_Shirt_GuildTabard_01", "=q1=榮譽堡軍旗", "=ds=#s7#, =ec1=#m7#" },
        { 31778, "INV_Shirt_GuildTabard_01", "=q1=陰鬱城軍服", "=ds=#s7#" },
        { 32828, "INV_Shirt_GuildTabard_01", "=q1=歐格利拉徽章", "=ds=#s7#" },
        { 31781, "INV_Shirt_GuildTabard_01", "=q1=薩塔軍服", "=ds=#s7#" },
        { 31775, "INV_Shirt_GuildTabard_01", "=q1=斯博格爾大衣", "=ds=#s7#" },
        { 22999, "INV_Shirt_GuildTabard_01", "=q1=銀色黎明外衣", "=ds=#s7#, =q1=#m4#" },
        { 24004, "INV_Shirt_GuildTabard_01", "=q1=索爾瑪大衣", "=ds=#s7#, =ec1=#m6#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 25549, "INV_Shirt_GuildTabard_01", "=q1=血騎士大衣", "=ds=#s7#, =ec1=#m6#" },
        { 31776, "INV_Shirt_GuildTabard_01", "=q1=聯合團紋章戰袍", "=ds=#s7#" },
        { 31774, "INV_Shirt_GuildTabard_01", "=q1=卡爾奈外衣", "=ds=#s7#, =ec1=#m7#" },
        { 31773, "INV_Shirt_GuildTabard_01", "=q1=瑪格哈軍服", "=ds=#s7#, =ec1=#m6#" },
        { 31780, "INV_Shirt_GuildTabard_01", "=q1=占卜者軍服", "=ds=#s7#" },
        { 32445, "INV_Shirt_GuildTabard_01", "=q1=空防大衣", "=ds=#s7#" },
        { 24344, "INV_Shirt_12", "=q1=阿格斯之手徽章", "=ds=#s7#, =q1=#m4#, =ec1=#m7#" },
        { 28788, "INV_Shirt_GuildTabard_01", "=q1=防禦者徽章", "=ds=#s7#, =q1=#m4#" },        
        };
        
    Tabards2 = {
        { 20132, "INV_Shirt_GuildTabard_01", "=q1=阿拉索軍服", "=ds=#s7#, =q1=#m4#, =ec1=#m7#" },
        { 20131, "INV_Shirt_GuildTabard_01", "=q1=污染者軍服", "=ds=#s7#, =q1=#m4#, =ec1=#m6#" },
        { 19032, "INV_Shirt_GuildTabard_01", "=q1=雷矛軍服", "=ds=#s7#, =ec1=#m7#" },
        { 19031, "INV_Shirt_GuildTabard_01", "=q1=霜狼軍服", "=ds=#s7#, =ec1=#m6#" },
        { 19506, "INV_Shirt_GuildTabard_01", "=q1=銀翼軍服", "=ds=#s7#, =ec1=#m7#" },
        { 19505, "INV_Shirt_GuildTabard_01", "=q1=戰歌軍服", "=ds=#s7#, =ec1=#m6#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 15196, "INV_Misc_TabardPVP_01", "=q1=海盜徽章", "=ds=#s7#, =ec1=#m7#" },
        { 15198, "INV_Misc_TabardPVP_03", "=q1=騎士彩帶", "=ds=#s7#, =ec1=#m7#" },        
        { 15197, "INV_Misc_TabardPVP_02", "=q1=斥候的徽章", "=ds=#s7#, =ec1=#m6#" },
        { 15199, "INV_Misc_TabardPVP_04", "=q1=石守衛的紋章", "=ds=#s7#, =ec1=#m6#" },
        };

-- Card Game Items

    CardGame1 = {
        { 0, "INV_Box_01", "=q6=#ud4#", "=q1=#ud1#" },
        { 23705, "INV_Misc_TabardPVP_02", "=q4=烈焰徽章", "=ds=#s7# =q1=#ud6#", },
        { 23713, "INV_Egg_02", "=q4=角鷹獸寶寶", "=ds=#e13# =q1=#ud7#", },
        { 23720, "Ability_Hunter_Pet_Turtle", "=q4=烏龜坐騎", "=ds=#e12# =q1=#ud8#", },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#ud4#", "=q1=#ud2#" },
        { 32588, "INV_Misc_Food_24", "=q3=巴那納斯護身符", "=ds=#e13# =q1=#ud9#", },
        { 32566, "INV_Box_01", "=q3=午餐籃", "=ds=#m20# =q1=#ud10#", },
        { 32542, "INV_Potion_27", "=q3=球中的小鬼", "=ds=#m20# =q1=#ud11#", },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#ud4#", "=q1=#ud3#" },
        { 33225, "Ability_Mount_WhiteTiger", "=q4=Reins of the Swift Spectral Tiger", "=ds=#e12#", },
        { 33224, "Ability_Mount_WhiteTiger", "=q3=Reins of the Spectral Tiger", "=ds=#e12#", },
        { 0, "?", "=q3=Fishing Chair", "", },
        { 0, "?", "=q3=Goblin Gumbo", "", },
        { 0, "INV_Box_01", "=q6=#ud5#", "" },
        { 23709, "INV_Misc_TabardPVP_01", "=q4=冰霜徽章", "=ds=#s7#", },
        { 23714, "INV_Misc_MissileSmall_Purple", "=q4=無止境的紫色煙火", "=ds=#s14#", },
        { 23716, "INV_Misc_Idol_01", "=q4=巨魔雕像", "=ds=#s14#", },
        };
    
    };
end